/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.naming;

import com.android.tools.r8.com.google.common.collect.Streams;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItem;
import com.android.tools.r8.graph.DexItemBasedString;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.DexTypeList;
import com.android.tools.r8.graph.DexValue;
import com.android.tools.r8.ir.code.ArrayPut;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.ConstString;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.InstancePut;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionIterator;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.Invoke;
import com.android.tools.r8.ir.code.InvokeMethod;
import com.android.tools.r8.ir.code.StaticPut;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import com.android.tools.r8.shaking.Enqueuer;
import com.android.tools.r8.utils.DescriptorUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class IdentifierNameStringMarker {
    private final Enqueuer.AppInfoWithLiveness appInfo;
    private final DexItemFactory dexItemFactory;
    private final Set<DexItem> identifierNameStrings;

    public IdentifierNameStringMarker(Enqueuer.AppInfoWithLiveness appInfo) {
        this.appInfo = appInfo;
        this.dexItemFactory = appInfo.dexItemFactory;
        this.identifierNameStrings = appInfo.identifierNameStrings;
    }

    public void decoupleIdentifierNameStringsInFields() {
        for (DexProgramClass clazz : this.appInfo.classes()) {
            clazz.forEachField(this::decoupleIdentifierNameStringInField);
        }
    }

    private void decoupleIdentifierNameStringInField(DexEncodedField encodedField) {
        if (!this.identifierNameStrings.contains(encodedField.field)) {
            return;
        }
        if (!(encodedField.staticValue instanceof DexValue.DexValueString)) {
            return;
        }
        DexString original = ((DexValue.DexValueString)encodedField.staticValue).getValue();
        DexItemBasedString itemBasedString = this.inferMemberOrTypeFromNameString(original);
        if (itemBasedString != null) {
            encodedField.staticValue = new DexValue.DexValueString(itemBasedString);
        }
    }

    public void decoupleIdentifierNameStringsInMethod(DexEncodedMethod encodedMethod, IRCode code) {
        for (BasicBlock block : code.blocks) {
            InstructionListIterator iterator = block.listIterator();
            while (iterator.hasNext()) {
                InvokeMethod invoke;
                DexMethod invokedMethod;
                Value in2;
                Value newIn;
                DexField field;
                Instruction instruction = (Instruction)iterator.next();
                if (instruction.isStaticPut()) {
                    StaticPut staticPut = instruction.asStaticPut();
                    field = staticPut.getField();
                    if (!this.identifierNameStrings.contains(field) || (newIn = this.decoupleIdentifierIfNecessary(code, iterator, staticPut, in2 = staticPut.inValue())) == in2) continue;
                    iterator.replaceCurrentInstruction(new StaticPut(staticPut.getType(), newIn, field));
                    encodedMethod.markUseIdentifierNameString();
                    continue;
                }
                if (instruction.isInstancePut()) {
                    InstancePut instancePut = instruction.asInstancePut();
                    field = instancePut.getField();
                    if (!this.identifierNameStrings.contains(field) || (newIn = this.decoupleIdentifierIfNecessary(code, iterator, instancePut, in2 = instancePut.value())) == in2) continue;
                    iterator.replaceCurrentInstruction(new InstancePut(instancePut.getType(), field, instancePut.object(), newIn));
                    encodedMethod.markUseIdentifierNameString();
                    continue;
                }
                if (!instruction.isInvokeMethod() || !this.identifierNameStrings.contains(invokedMethod = (invoke = instruction.asInvokeMethod()).getInvokedMethod())) continue;
                List<Value> ins = invoke.arguments();
                Value[] changes = new Value[ins.size()];
                if (this.isReflectiveCase(invokedMethod)) {
                    this.decoupleReflectiveMemberIdentifier(code, iterator, invoke, changes);
                } else {
                    for (int i = 0; i < ins.size(); ++i) {
                        Value in3 = ins.get(i);
                        Value newIn2 = this.decoupleIdentifierIfNecessary(code, iterator, invoke, in3);
                        if (newIn2 == in3) continue;
                        changes[i] = newIn2;
                    }
                }
                if (Arrays.stream(changes).allMatch(Objects::isNull)) continue;
                List<Value> newIns = Streams.mapWithIndex(ins.stream(), (in, index) -> changes[(int)index] != null ? changes[(int)index] : in).collect(Collectors.toList());
                iterator.replaceCurrentInstruction(Invoke.create(invoke.getType(), invokedMethod, invokedMethod.proto, invoke.outValue(), newIns));
                encodedMethod.markUseIdentifierNameString();
            }
        }
    }

    private Value decoupleIdentifierIfNecessary(IRCode code, InstructionListIterator iterator, Instruction base, Value in) {
        if (!in.isConstString()) {
            return in;
        }
        DexString original = in.getConstInstruction().asConstString().getValue();
        DexItemBasedString itemBasedString = this.inferMemberOrTypeFromNameString(original);
        if (itemBasedString == null) {
            return in;
        }
        return this.insertItemBasedString(code, iterator, base, in, itemBasedString);
    }

    private void decoupleReflectiveMemberIdentifier(IRCode code, InstructionListIterator iterator, InvokeMethod invoke, Value[] changes) {
        boolean isReferenceFieldUpdater;
        int positionOfIdentifier;
        List<Value> ins = invoke.arguments();
        Value in = ins.get(positionOfIdentifier = (isReferenceFieldUpdater = invoke.getReturnType().descriptor == this.dexItemFactory.referenceFieldUpdaterDescriptor) ? 2 : 1);
        if (!in.isConstString()) {
            return;
        }
        Value classValue = ins.get(0);
        if (!classValue.isConstClass()) {
            return;
        }
        DexType holderType = classValue.getConstInstruction().asConstClass().getValue();
        DexClass holder = this.appInfo.definitionFor(holderType);
        if (holder == null) {
            return;
        }
        DexString dexString = in.getConstInstruction().asConstString().getValue();
        DexItemBasedString itemBasedString = null;
        int numOfParams = ins.size();
        if (isReferenceFieldUpdater) {
            Value fieldTypeValue = ins.get(1);
            if (!fieldTypeValue.isConstClass()) {
                return;
            }
            DexType fieldType = fieldTypeValue.getConstInstruction().asConstClass().getValue();
            itemBasedString = this.inferFieldInHolder(holder, dexString.toString(), fieldType);
        } else if (numOfParams == 2) {
            itemBasedString = this.inferFieldInHolder(holder, dexString.toString(), null);
        } else {
            assert (numOfParams == 3);
            DexTypeList arguments = this.retrieveDexTypeListFromClassList(invoke, ins.get(2));
            itemBasedString = this.inferMethodInHolder(holder, dexString.toString(), arguments);
        }
        if (itemBasedString == null) {
            return;
        }
        Value newIn = this.insertItemBasedString(code, iterator, invoke, in, itemBasedString);
        if (newIn != in) {
            changes[positionOfIdentifier] = newIn;
        }
    }

    private Value insertItemBasedString(IRCode code, InstructionListIterator iterator, Instruction base, Value in, DexItemBasedString itemBasedString) {
        iterator.previous();
        Value newIn = code.createValue(in.outType(), in.getLocalInfo());
        ConstString decoupled = new ConstString(newIn, itemBasedString);
        decoupled.setPosition(base.getPosition());
        iterator.add(decoupled);
        iterator.next();
        return newIn;
    }

    private DexItemBasedString inferMemberOrTypeFromNameString(DexString dexString) {
        String maybeDescriptor;
        DexItemBasedString itemBasedString = this.inferMemberFromNameString(dexString);
        if (itemBasedString == null && (maybeDescriptor = DescriptorUtils.javaTypeToDescriptorIfValidJavaType(dexString.toString())) != null) {
            DexType type = this.dexItemFactory.createType(maybeDescriptor);
            itemBasedString = this.dexItemFactory.createItemBasedString(type);
        }
        return itemBasedString;
    }

    private DexItemBasedString inferMemberFromNameString(DexString dexString) {
        String identifier = dexString.toString();
        String typeIdentifier = null;
        String memberIdentifier = null;
        String[] items = identifier.split("#");
        if (items.length > 2) {
            return null;
        }
        if (items.length == 2) {
            typeIdentifier = items[0];
            memberIdentifier = items[1];
        } else {
            int lastDot = identifier.lastIndexOf(".");
            if (0 < lastDot && lastDot < identifier.length() - 1) {
                typeIdentifier = identifier.substring(0, lastDot);
                memberIdentifier = identifier.substring(lastDot + 1);
            }
        }
        if (typeIdentifier == null) {
            return null;
        }
        String maybeDescriptor = DescriptorUtils.javaTypeToDescriptorIfValidJavaType(typeIdentifier);
        if (maybeDescriptor == null) {
            return null;
        }
        DexType type = this.dexItemFactory.createType(maybeDescriptor);
        DexClass holder = this.appInfo.definitionFor(type);
        if (holder == null) {
            return null;
        }
        DexItemBasedString itemBasedString = this.inferFieldInHolder(holder, memberIdentifier, null);
        if (itemBasedString == null) {
            itemBasedString = this.inferMethodInHolder(holder, memberIdentifier, null);
        }
        return itemBasedString;
    }

    private DexItemBasedString inferFieldInHolder(DexClass holder, String name, DexType fieldType) {
        DexItemBasedString itemBasedString = null;
        for (DexEncodedField encodedField : holder.staticFields()) {
            if (!encodedField.field.name.toString().equals(name) || fieldType != null && encodedField.field.type != fieldType) continue;
            itemBasedString = this.dexItemFactory.createItemBasedString(encodedField.field);
            break;
        }
        if (itemBasedString == null) {
            for (DexEncodedField encodedField : holder.instanceFields()) {
                if (!encodedField.field.name.toString().equals(name) || fieldType != null && encodedField.field.type != fieldType) continue;
                itemBasedString = this.dexItemFactory.createItemBasedString(encodedField.field);
                break;
            }
        }
        return itemBasedString;
    }

    private DexItemBasedString inferMethodInHolder(DexClass holder, String name, DexTypeList arguments) {
        DexItemBasedString itemBasedString = null;
        for (DexEncodedMethod encodedMethod : holder.directMethods()) {
            if (!encodedMethod.method.name.toString().equals(name) || arguments != null && !encodedMethod.method.proto.parameters.equals(arguments)) continue;
            itemBasedString = this.dexItemFactory.createItemBasedString(encodedMethod.method);
            break;
        }
        if (itemBasedString == null) {
            for (DexEncodedMethod encodedMethod : holder.virtualMethods()) {
                if (!encodedMethod.method.name.toString().equals(name) || arguments != null && !encodedMethod.method.proto.parameters.equals(arguments)) continue;
                itemBasedString = this.dexItemFactory.createItemBasedString(encodedMethod.method);
                break;
            }
        }
        return itemBasedString;
    }

    private boolean isReflectiveCase(DexMethod method) {
        int arity = method.getArity();
        if (method.holder.descriptor == this.dexItemFactory.classDescriptor) {
            if (arity != 1 && arity != 2) {
                return false;
            }
            if (arity == 1 ? method.proto.returnType.descriptor != this.dexItemFactory.fieldDescriptor : method.proto.returnType.descriptor != this.dexItemFactory.methodDescriptor) {
                return false;
            }
            if (method.proto.parameters.values[0].descriptor != this.dexItemFactory.stringDescriptor) {
                return false;
            }
            if (arity == 2 && method.proto.parameters.values[1].descriptor != this.dexItemFactory.classArrayDescriptor) {
                return false;
            }
        } else if (method.holder.descriptor == this.dexItemFactory.intFieldUpdaterDescriptor || method.holder.descriptor == this.dexItemFactory.longFieldUpdaterDescriptor) {
            if (arity != 2) {
                return false;
            }
            if (method.proto.returnType.descriptor != method.holder.descriptor) {
                return false;
            }
            if (method.proto.parameters.values[0].descriptor != this.dexItemFactory.classDescriptor) {
                return false;
            }
            if (method.proto.parameters.values[1].descriptor != this.dexItemFactory.stringDescriptor) {
                return false;
            }
        } else if (method.holder.descriptor == this.dexItemFactory.referenceFieldUpdaterDescriptor) {
            if (arity != 3) {
                return false;
            }
            if (method.proto.returnType.descriptor != method.holder.descriptor) {
                return false;
            }
            if (method.proto.parameters.values[0].descriptor != this.dexItemFactory.classDescriptor) {
                return false;
            }
            if (method.proto.parameters.values[1].descriptor != this.dexItemFactory.classDescriptor) {
                return false;
            }
            if (method.proto.parameters.values[2].descriptor != this.dexItemFactory.stringDescriptor) {
                return false;
            }
        } else {
            if (arity != 2 && arity != 3) {
                return false;
            }
            if (arity == 2 ? method.proto.returnType.descriptor != this.dexItemFactory.fieldDescriptor : method.proto.returnType.descriptor != this.dexItemFactory.methodDescriptor) {
                return false;
            }
            if (method.proto.parameters.values[0].descriptor != this.dexItemFactory.classDescriptor) {
                return false;
            }
            if (method.proto.parameters.values[1].descriptor != this.dexItemFactory.stringDescriptor) {
                return false;
            }
            if (arity == 3 && method.proto.parameters.values[2].descriptor != this.dexItemFactory.classArrayDescriptor) {
                return false;
            }
        }
        return true;
    }

    private DexTypeList retrieveDexTypeListFromClassList(InvokeMethod invoke, Value classListValue) {
        Instruction instr2;
        if (!classListValue.definition.isInvokeNewArray() && !classListValue.definition.isNewArrayEmpty()) {
            return null;
        }
        BasicBlock block = classListValue.definition.getBlock();
        InstructionIterator iterator = block.iterator();
        iterator.nextUntil(instr -> instr == classListValue.definition);
        Set<Instruction> users = classListValue.definition.outValue().uniqueUsers();
        int maxIndex = -1;
        Int2ObjectArrayMap<DexType> typeMap = new Int2ObjectArrayMap<DexType>();
        while (iterator.hasNext() && (instr2 = (Instruction)iterator.next()) != invoke) {
            if (!users.contains(instr2)) continue;
            if (!instr2.isArrayPut()) {
                return null;
            }
            ArrayPut arrayPut = instr2.asArrayPut();
            assert (arrayPut.array() == classListValue);
            if (!arrayPut.value().isConstClass() || !arrayPut.index().isConstNumber()) {
                return null;
            }
            int index = arrayPut.index().getConstInstruction().asConstNumber().getIntValue();
            if (index < 0 || typeMap.containsKey((Object)index)) {
                return null;
            }
            maxIndex = maxIndex < index ? index : maxIndex;
            DexType type = arrayPut.value().getConstInstruction().asConstClass().getValue();
            typeMap.put(Integer.valueOf(index), type);
        }
        if (maxIndex < 0) {
            return DexTypeList.empty();
        }
        for (int i = 0; i <= maxIndex; ++i) {
            if (typeMap.containsKey((Object)i)) continue;
            return null;
        }
        DexType[] types = new DexType[maxIndex + 1];
        for (int i = 0; i <= maxIndex; ++i) {
            types[i] = (DexType)typeMap.get((Object)i);
        }
        return new DexTypeList(types);
    }
}

