/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.dex;

import com.android.tools.r8.ClassFileResourceProvider;
import com.android.tools.r8.ProgramResource;
import com.android.tools.r8.ResourceException;
import com.android.tools.r8.StringResource;
import com.android.tools.r8.dex.DexFile;
import com.android.tools.r8.dex.DexFileReader;
import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.graph.ClassKind;
import com.android.tools.r8.graph.DexApplication;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexClasspathClass;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexLibraryClass;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.JarApplicationReader;
import com.android.tools.r8.graph.JarClassFileReader;
import com.android.tools.r8.graph.LazyLoadedDexApplication;
import com.android.tools.r8.naming.ClassNameMapper;
import com.android.tools.r8.utils.AndroidApiLevel;
import com.android.tools.r8.utils.AndroidApp;
import com.android.tools.r8.utils.ClassProvider;
import com.android.tools.r8.utils.ClasspathClassCollection;
import com.android.tools.r8.utils.DescriptorUtils;
import com.android.tools.r8.utils.DexVersion;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.LibraryClassCollection;
import com.android.tools.r8.utils.MainDexList;
import com.android.tools.r8.utils.ProgramClassCollection;
import com.android.tools.r8.utils.StringDiagnostic;
import com.android.tools.r8.utils.ThreadUtils;
import com.android.tools.r8.utils.Timing;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collectors;

public class ApplicationReader {
    final InternalOptions options;
    final DexItemFactory itemFactory;
    final Timing timing;
    private final AndroidApp inputApp;

    public ApplicationReader(AndroidApp inputApp, InternalOptions options, Timing timing) {
        this.options = options;
        this.itemFactory = options.itemFactory;
        this.timing = timing;
        this.inputApp = inputApp;
    }

    public DexApplication read() throws IOException, ExecutionException {
        return this.read((StringResource)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DexApplication read(StringResource proguardMap) throws IOException, ExecutionException {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        try {
            DexApplication dexApplication = this.read(proguardMap, executor);
            return dexApplication;
        }
        finally {
            executor.shutdown();
        }
    }

    public final DexApplication read(ExecutorService executorService) throws IOException, ExecutionException {
        return this.read(null, executorService, ProgramClassCollection::resolveClassConflictImpl);
    }

    public final DexApplication read(StringResource proguardMap, ExecutorService executorService) throws IOException, ExecutionException {
        return this.read(proguardMap, executorService, ProgramClassCollection::resolveClassConflictImpl);
    }

    public final DexApplication read(StringResource proguardMap, ExecutorService executorService, ProgramClassConflictResolver resolver) throws IOException, ExecutionException {
        this.timing.begin("DexApplication.read");
        LazyLoadedDexApplication.Builder builder = DexApplication.builder(this.itemFactory, this.timing, resolver);
        try {
            ArrayList futures = new ArrayList();
            this.readProguardMap(proguardMap, builder, executorService, futures);
            this.readMainDexList(builder, executorService, futures);
            ClassReader classReader = new ClassReader(executorService, futures);
            classReader.readSources();
            ThreadUtils.awaitFutures(futures);
            classReader.initializeLazyClassCollection(builder);
        }
        catch (ResourceException e) {
            throw this.options.reporter.fatalError(new StringDiagnostic(e.getMessage(), e.getOrigin()));
        }
        finally {
            this.timing.end();
        }
        return builder.build();
    }

    private int verifyOrComputeMinApiLevel(int computedMinApiLevel, DexFile file) {
        DexVersion version = DexVersion.getDexVersion(file.getDexVersion());
        if (this.options.minApiLevel == AndroidApiLevel.getDefault().getLevel()) {
            computedMinApiLevel = Math.max(computedMinApiLevel, AndroidApiLevel.getMinAndroidApiLevel(version).getLevel());
        } else if (!version.matchesApiLevel(AndroidApiLevel.getAndroidApiLevel(this.options.minApiLevel))) {
            throw new CompilationError("Dex file with version '" + version.getIntValue() + "' cannot be used with min sdk level '" + this.options.minApiLevel + "'.");
        }
        return computedMinApiLevel;
    }

    private void readProguardMap(StringResource map, DexApplication.Builder<?> builder, ExecutorService executorService, List<Future<?>> futures) {
        if (map == null) {
            return;
        }
        futures.add(executorService.submit(() -> {
            try {
                String content = map.getString();
                builder.setProguardMap(ClassNameMapper.mapperFromString(content));
            }
            catch (ResourceException | IOException e) {
                throw new CompilationError("Failure to read proguard map file", e, map.getOrigin());
            }
        }));
    }

    private void readMainDexList(DexApplication.Builder<?> builder, ExecutorService executorService, List<Future<?>> futures) {
        if (this.inputApp.hasMainDexList()) {
            futures.add(executorService.submit(() -> {
                for (StringResource resource : this.inputApp.getMainDexListResources()) {
                    builder.addToMainDexList(MainDexList.parseList(resource, this.itemFactory));
                }
                builder.addToMainDexList(this.inputApp.getMainDexClasses().stream().map(clazz -> this.itemFactory.createType(DescriptorUtils.javaTypeToDescriptor(clazz))).collect(Collectors.toList()));
            }));
        }
    }

    private final class ClassReader {
        private final ExecutorService executorService;
        private final List<Future<?>> futures;
        private final Queue<DexProgramClass> programClasses = new ConcurrentLinkedQueue<DexProgramClass>();
        private final Queue<DexClasspathClass> classpathClasses = new ConcurrentLinkedQueue<DexClasspathClass>();
        private final Queue<DexLibraryClass> libraryClasses = new ConcurrentLinkedQueue<DexLibraryClass>();
        private final JarApplicationReader application;

        ClassReader(ExecutorService executorService, List<Future<?>> futures) {
            this.application = new JarApplicationReader(ApplicationReader.this.options);
            this.executorService = executorService;
            this.futures = futures;
        }

        private <T extends DexClass> void readDexSources(List<ProgramResource> dexSources, ClassKind classKind, Queue<T> classes) throws IOException, ResourceException {
            if (dexSources.size() > 0) {
                ArrayList<DexFileReader> fileReaders = new ArrayList<DexFileReader>(dexSources.size());
                int computedMinApiLevel = ApplicationReader.this.options.minApiLevel;
                for (ProgramResource input : dexSources) {
                    DexFile file = new DexFile(input);
                    computedMinApiLevel = ApplicationReader.this.verifyOrComputeMinApiLevel(computedMinApiLevel, file);
                    fileReaders.add(new DexFileReader(file, classKind, ApplicationReader.this.itemFactory));
                }
                ApplicationReader.this.options.minApiLevel = computedMinApiLevel;
                for (DexFileReader reader : fileReaders) {
                    DexFileReader.populateIndexTables(reader);
                }
                if (!ApplicationReader.this.options.skipReadingDexCode) {
                    for (DexFileReader reader : fileReaders) {
                        this.futures.add(this.executorService.submit(() -> {
                            reader.addCodeItemsTo();
                            reader.addClassDefsTo(classKind.bridgeConsumer(classes::add));
                        }));
                    }
                }
            }
        }

        private <T extends DexClass> void readClassSources(List<ProgramResource> classSources, ClassKind classKind, Queue<T> classes) {
            JarClassFileReader reader = new JarClassFileReader(this.application, classKind.bridgeConsumer(classes::add));
            for (ProgramResource input : classSources) {
                this.futures.add(this.executorService.submit(() -> {
                    try (InputStream is = input.getByteStream();){
                        reader.read(input.getOrigin(), classKind, is);
                    }
                    return null;
                }));
            }
        }

        void readSources() throws IOException, ResourceException {
            Collection<ProgramResource> resources = ApplicationReader.this.inputApp.computeAllProgramResources();
            ArrayList<ProgramResource> dexResources = new ArrayList<ProgramResource>(resources.size());
            ArrayList<ProgramResource> cfResources = new ArrayList<ProgramResource>(resources.size());
            for (ProgramResource resource : resources) {
                if (resource.getKind() == ProgramResource.Kind.DEX) {
                    dexResources.add(resource);
                    continue;
                }
                assert (resource.getKind() == ProgramResource.Kind.CF);
                cfResources.add(resource);
            }
            this.readDexSources(dexResources, ClassKind.PROGRAM, this.programClasses);
            this.readClassSources(cfResources, ClassKind.PROGRAM, this.programClasses);
        }

        private <T extends DexClass> ClassProvider<T> buildClassProvider(ClassKind classKind, Queue<T> preloadedClasses, List<ClassFileResourceProvider> resourceProviders, JarApplicationReader reader) {
            ArrayList providers = new ArrayList();
            if (!preloadedClasses.isEmpty()) {
                providers.add(ClassProvider.forPreloadedClasses(classKind, preloadedClasses));
            }
            for (ClassFileResourceProvider provider : resourceProviders) {
                providers.add(ClassProvider.forClassFileResources(classKind, provider, reader));
            }
            if (providers.isEmpty()) {
                return null;
            }
            return providers.size() == 1 ? (ClassProvider)providers.get(0) : ClassProvider.combine(classKind, providers);
        }

        void initializeLazyClassCollection(LazyLoadedDexApplication.Builder builder) {
            ClassProvider<DexLibraryClass> libraryClassProvider;
            for (DexProgramClass clazz : this.programClasses) {
                builder.addProgramClass(clazz.asProgramClass());
            }
            ClassProvider<DexClasspathClass> classpathClassProvider = this.buildClassProvider(ClassKind.CLASSPATH, this.classpathClasses, ApplicationReader.this.inputApp.getClasspathResourceProviders(), this.application);
            if (classpathClassProvider != null) {
                builder.setClasspathClassCollection(new ClasspathClassCollection(classpathClassProvider));
            }
            if ((libraryClassProvider = this.buildClassProvider(ClassKind.LIBRARY, this.libraryClasses, ApplicationReader.this.inputApp.getLibraryResourceProviders(), this.application)) != null) {
                builder.setLibraryClassCollection(new LibraryClassCollection(libraryClassProvider));
            }
        }
    }

    public static interface ProgramClassConflictResolver {
        public DexProgramClass resolveClassConflict(DexProgramClass var1, DexProgramClass var2);
    }
}

