/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.cf.code;

import com.android.tools.r8.cf.CfPrinter;
import com.android.tools.r8.cf.code.CfInstruction;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ReferenceSortedMap;
import com.android.tools.r8.org.objectweb.asm.MethodVisitor;
import com.android.tools.r8.org.objectweb.asm.Opcodes;
import java.util.List;

public class CfFrame
extends CfInstruction {
    private final Int2ReferenceSortedMap<DexType> locals;
    private final List<DexType> stack;

    public CfFrame(Int2ReferenceSortedMap<DexType> locals, List<DexType> stack) {
        this.locals = locals;
        this.stack = stack;
    }

    public Int2ReferenceSortedMap<DexType> getLocals() {
        return this.locals;
    }

    public List<DexType> getStack() {
        return this.stack;
    }

    @Override
    public void write(MethodVisitor visitor) {
        int stackCount = this.computeStackCount();
        Object[] stackTypes = this.computeStackTypes(stackCount);
        int localsCount = this.computeLocalsCount();
        Object[] localsTypes = this.computeLocalsTypes(localsCount);
        visitor.visitFrame(-1, localsCount, localsTypes, stackCount, stackTypes);
    }

    private boolean isWide(DexType type) {
        return type.isPrimitiveType() && (type.toShorty() == 'J' || type.toShorty() == 'D');
    }

    private int computeStackCount() {
        return this.stack.size();
    }

    private Object[] computeStackTypes(int stackCount) {
        assert (stackCount == this.stack.size());
        if (stackCount == 0) {
            return null;
        }
        Object[] stackTypes = new Object[stackCount];
        for (int i = 0; i < stackCount; ++i) {
            stackTypes[i] = this.getType(this.stack.get(i));
        }
        return stackTypes;
    }

    private int computeLocalsCount() {
        if (this.locals.isEmpty()) {
            return 0;
        }
        int maxRegister = this.locals.lastIntKey();
        int localsCount = 0;
        for (int i = 0; i <= maxRegister; ++i) {
            ++localsCount;
            DexType type = (DexType)this.locals.get(i);
            if (type == null || !this.isWide(type)) continue;
            ++i;
        }
        return localsCount;
    }

    private Object[] computeLocalsTypes(int localsCount) {
        if (localsCount == 0) {
            return null;
        }
        int maxRegister = this.locals.lastIntKey();
        Object[] localsTypes = new Object[localsCount];
        int localIndex = 0;
        for (int i = 0; i <= maxRegister; ++i) {
            DexType type = (DexType)this.locals.get(i);
            Object typeOpcode = this.getType(type);
            localsTypes[localIndex++] = typeOpcode;
            if (type == null || !this.isWide(type)) continue;
            ++i;
        }
        return localsTypes;
    }

    private Object getType(DexType type) {
        if (type == null) {
            return Opcodes.TOP;
        }
        if (type == DexItemFactory.nullValueType) {
            return Opcodes.NULL;
        }
        switch (type.toShorty()) {
            case 'L': {
                return type.getInternalName();
            }
            case 'I': {
                return Opcodes.INTEGER;
            }
            case 'F': {
                return Opcodes.FLOAT;
            }
            case 'J': {
                return Opcodes.LONG;
            }
            case 'D': {
                return Opcodes.DOUBLE;
            }
        }
        throw new Unreachable("Unexpected value type: " + type);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void print(CfPrinter printer) {
        printer.print(this);
    }
}

