/*
 * Decompiled with CFR 0.152.
 */
package org.jf.baksmali.Adaptors.Debug;

import java.io.IOException;
import org.jf.baksmali.Adaptors.ClassDefinition;
import org.jf.baksmali.Adaptors.Debug.DebugMethodItem;
import org.jf.baksmali.Adaptors.Debug.LocalFormatter;
import org.jf.baksmali.Adaptors.RegisterFormatter;
import org.jf.baksmali.formatter.BaksmaliWriter;
import org.jf.dexlib2.iface.debug.StartLocal;

public class StartLocalMethodItem
extends DebugMethodItem {
    private final ClassDefinition classDef;
    private final StartLocal startLocal;
    private final RegisterFormatter registerFormatter;

    public StartLocalMethodItem(ClassDefinition classDef, int codeAddress, int sortOrder, RegisterFormatter registerFormatter, StartLocal startLocal) {
        super(codeAddress, sortOrder);
        this.classDef = classDef;
        this.startLocal = startLocal;
        this.registerFormatter = registerFormatter;
    }

    @Override
    public boolean writeTo(BaksmaliWriter writer) throws IOException {
        writer.write(".local ");
        this.registerFormatter.writeTo(writer, this.startLocal.getRegister());
        String name = this.startLocal.getName();
        String type = this.startLocal.getType();
        String signature = this.startLocal.getSignature();
        if (name != null || type != null || signature != null) {
            writer.write(", ");
            LocalFormatter.writeLocal(writer, name, type, signature);
        }
        return true;
    }
}

