/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.immutable;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.jf.dexlib2.HiddenApiRestriction;
import org.jf.dexlib2.base.reference.BaseMethodReference;
import org.jf.dexlib2.iface.Annotation;
import org.jf.dexlib2.iface.Method;
import org.jf.dexlib2.iface.MethodImplementation;
import org.jf.dexlib2.iface.MethodParameter;
import org.jf.dexlib2.immutable.ImmutableAnnotation;
import org.jf.dexlib2.immutable.ImmutableMethodImplementation;
import org.jf.dexlib2.immutable.ImmutableMethodParameter;
import org.jf.util.ImmutableConverter;
import org.jf.util.ImmutableUtils;

public class ImmutableMethod
extends BaseMethodReference
implements Method {
    protected final String definingClass;
    protected final String name;
    protected final ImmutableList<? extends ImmutableMethodParameter> parameters;
    protected final String returnType;
    protected final int accessFlags;
    protected final ImmutableSet<? extends ImmutableAnnotation> annotations;
    protected final ImmutableSet<HiddenApiRestriction> hiddenApiRestrictions;
    protected final ImmutableMethodImplementation methodImplementation;
    private static final ImmutableConverter<ImmutableMethod, Method> CONVERTER = new ImmutableConverter<ImmutableMethod, Method>(){

        @Override
        protected boolean isImmutable(Method item) {
            return item instanceof ImmutableMethod;
        }

        @Override
        protected ImmutableMethod makeImmutable(Method item) {
            return ImmutableMethod.of(item);
        }
    };

    public ImmutableMethod(String definingClass, String name, Iterable<? extends MethodParameter> parameters, String returnType, int accessFlags, Set<? extends Annotation> annotations, Set<HiddenApiRestriction> hiddenApiRestrictions, MethodImplementation methodImplementation) {
        this.definingClass = definingClass;
        this.name = name;
        this.parameters = ImmutableMethodParameter.immutableListOf(parameters);
        this.returnType = returnType;
        this.accessFlags = accessFlags;
        this.annotations = ImmutableAnnotation.immutableSetOf(annotations);
        this.hiddenApiRestrictions = hiddenApiRestrictions == null ? ImmutableSet.of() : ImmutableSet.copyOf(hiddenApiRestrictions);
        this.methodImplementation = ImmutableMethodImplementation.of(methodImplementation);
    }

    public ImmutableMethod(String definingClass, String name, ImmutableList<? extends ImmutableMethodParameter> parameters, String returnType, int accessFlags, ImmutableSet<? extends ImmutableAnnotation> annotations, ImmutableSet<HiddenApiRestriction> hiddenApiRestrictions, ImmutableMethodImplementation methodImplementation) {
        this.definingClass = definingClass;
        this.name = name;
        this.parameters = ImmutableUtils.nullToEmptyList(parameters);
        this.returnType = returnType;
        this.accessFlags = accessFlags;
        this.annotations = ImmutableUtils.nullToEmptySet(annotations);
        this.hiddenApiRestrictions = ImmutableUtils.nullToEmptySet(hiddenApiRestrictions);
        this.methodImplementation = methodImplementation;
    }

    public static ImmutableMethod of(Method method) {
        if (method instanceof ImmutableMethod) {
            return (ImmutableMethod)method;
        }
        return new ImmutableMethod(method.getDefiningClass(), method.getName(), method.getParameters(), method.getReturnType(), method.getAccessFlags(), method.getAnnotations(), method.getHiddenApiRestrictions(), method.getImplementation());
    }

    @Override
    public String getDefiningClass() {
        return this.definingClass;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public ImmutableList<? extends CharSequence> getParameterTypes() {
        return this.parameters;
    }

    public ImmutableList<? extends ImmutableMethodParameter> getParameters() {
        return this.parameters;
    }

    @Override
    public String getReturnType() {
        return this.returnType;
    }

    @Override
    public int getAccessFlags() {
        return this.accessFlags;
    }

    public ImmutableSet<? extends ImmutableAnnotation> getAnnotations() {
        return this.annotations;
    }

    @Override
    public Set<HiddenApiRestriction> getHiddenApiRestrictions() {
        return this.hiddenApiRestrictions;
    }

    @Override
    public ImmutableMethodImplementation getImplementation() {
        return this.methodImplementation;
    }
}

