/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib;

import brut.androlib.AaptInvoker;
import brut.androlib.ApktoolProperties;
import brut.androlib.Config;
import brut.androlib.apk.ApkInfo;
import brut.androlib.apk.UsesFramework;
import brut.androlib.exceptions.AndrolibException;
import brut.androlib.res.Framework;
import brut.androlib.res.xml.ResXmlPatcher;
import brut.androlib.src.SmaliBuilder;
import brut.common.BrutException;
import brut.common.InvalidUnknownFileException;
import brut.common.RootUnknownFileException;
import brut.common.TraversalUnknownFileException;
import brut.directory.Directory;
import brut.directory.DirectoryException;
import brut.directory.ExtFile;
import brut.directory.ZipUtils;
import brut.util.BrutIO;
import brut.util.OS;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.commons.io.FileUtils;
import org.xml.sax.SAXException;

public class ApkBuilder {
    private static final Logger LOGGER = Logger.getLogger(ApkBuilder.class.getName());
    private final Config mConfig;
    private final ExtFile mApkDir;
    private ApkInfo mApkInfo;
    private int mMinSdkVersion = 0;
    private static final String[] APK_RESOURCES_FILENAMES = new String[]{"resources.arsc", "AndroidManifest.xml", "res", "r", "R"};
    private static final String[] APK_RESOURCES_WITHOUT_RES_FILENAMES = new String[]{"resources.arsc", "AndroidManifest.xml"};
    private static final String[] APP_RESOURCES_FILENAMES = new String[]{"AndroidManifest.xml", "res"};
    private static final String[] APK_MANIFEST_FILENAMES = new String[]{"AndroidManifest.xml"};

    public ApkBuilder(Config config, ExtFile apkDir) {
        this.mConfig = config;
        this.mApkDir = apkDir;
    }

    public void build(File outFile) throws BrutException {
        LOGGER.info("Using Apktool " + ApktoolProperties.getVersion());
        this.mApkInfo = ApkInfo.load(this.mApkDir);
        if (this.mApkInfo.getSdkInfo() != null && this.mApkInfo.getSdkInfo().get("minSdkVersion") != null) {
            String minSdkVersion = this.mApkInfo.getSdkInfo().get("minSdkVersion");
            this.mMinSdkVersion = this.mApkInfo.getMinSdkVersionFromAndroidCodename(minSdkVersion);
        }
        if (outFile == null) {
            String outFileName = this.mApkInfo.apkFileName;
            outFile = new File(this.mApkDir, "dist" + File.separator + (outFileName == null ? "out.apk" : outFileName));
        }
        new File(this.mApkDir, "build/apk").mkdirs();
        File manifest = new File(this.mApkDir, "AndroidManifest.xml");
        File manifestOriginal = new File(this.mApkDir, "AndroidManifest.xml.orig");
        this.buildSources();
        this.buildNonDefaultSources();
        this.buildManifestFile(manifest, manifestOriginal);
        this.buildResources();
        this.buildLibs();
        this.buildCopyOriginalFiles();
        this.buildApk(outFile);
        this.buildUnknownFiles(outFile);
        if (manifest.isFile() && manifest.exists() && manifestOriginal.isFile()) {
            try {
                if (new File(this.mApkDir, "AndroidManifest.xml").delete()) {
                    FileUtils.moveFile(manifestOriginal, manifest);
                }
            }
            catch (IOException ex) {
                throw new AndrolibException(ex.getMessage());
            }
        }
        LOGGER.info("Built apk into: " + outFile.getPath());
    }

    private void buildManifestFile(File manifest, File manifestOriginal) throws AndrolibException {
        if (new File(this.mApkDir, "resources.arsc").exists()) {
            return;
        }
        if (manifest.isFile() && manifest.exists()) {
            try {
                if (manifestOriginal.exists()) {
                    manifestOriginal.delete();
                }
                FileUtils.copyFile(manifest, manifestOriginal);
                ResXmlPatcher.fixingPublicAttrsInProviderAttributes(manifest);
            }
            catch (IOException ex) {
                throw new AndrolibException(ex.getMessage());
            }
        }
    }

    private void buildSources() throws AndrolibException {
        if (!this.buildSourcesRaw("classes.dex") && !this.buildSourcesSmali("smali", "classes.dex")) {
            LOGGER.warning("Could not find sources");
        }
    }

    private void buildNonDefaultSources() throws AndrolibException {
        try {
            Map<String, Directory> dirs = this.mApkDir.getDirectory().getDirs();
            for (Map.Entry<String, Directory> directory : dirs.entrySet()) {
                String filename;
                String name = directory.getKey();
                if (!name.startsWith("smali_") || this.buildSourcesRaw(filename = name.substring(name.indexOf("_") + 1) + ".dex") || this.buildSourcesSmali(name, filename)) continue;
                LOGGER.warning("Could not find sources");
            }
            File[] dexFiles = this.mApkDir.listFiles();
            if (dexFiles != null) {
                for (File dex : dexFiles) {
                    if (!dex.getName().endsWith(".dex") || dex.getName().equalsIgnoreCase("classes.dex")) continue;
                    this.buildSourcesRaw(dex.getName());
                }
            }
        }
        catch (DirectoryException ex) {
            throw new AndrolibException(ex);
        }
    }

    private boolean buildSourcesRaw(String filename) throws AndrolibException {
        File working = new File(this.mApkDir, filename);
        if (!working.exists()) {
            return false;
        }
        File stored = new File(this.mApkDir, "build/apk/" + filename);
        if (this.mConfig.forceBuildAll || this.isModified(working, stored)) {
            LOGGER.info("Copying " + this.mApkDir.toString() + " " + filename + " file...");
            try {
                BrutIO.copyAndClose(Files.newInputStream(working.toPath(), new OpenOption[0]), Files.newOutputStream(stored.toPath(), new OpenOption[0]));
                return true;
            }
            catch (IOException ex) {
                throw new AndrolibException(ex);
            }
        }
        return true;
    }

    private boolean buildSourcesSmali(String folder, String filename) throws AndrolibException {
        ExtFile smaliDir = new ExtFile(this.mApkDir, folder);
        if (!smaliDir.exists()) {
            return false;
        }
        File dex = new File(this.mApkDir, "build/apk/" + filename);
        if (!this.mConfig.forceBuildAll) {
            LOGGER.info("Checking whether sources has changed...");
        }
        if (this.mConfig.forceBuildAll || this.isModified(smaliDir, dex)) {
            LOGGER.info("Smaling " + folder + " folder into " + filename + "...");
            dex.delete();
            SmaliBuilder.build(smaliDir, dex, this.mConfig.apiLevel > 0 ? this.mConfig.apiLevel : this.mMinSdkVersion);
        }
        return true;
    }

    private void buildResources() throws BrutException {
        if (!(this.buildResourcesRaw() || this.buildResourcesFull() || this.buildManifest())) {
            LOGGER.warning("Could not find resources");
        }
    }

    private boolean buildResourcesRaw() throws AndrolibException {
        try {
            if (!new File(this.mApkDir, "resources.arsc").exists()) {
                return false;
            }
            File apkDir = new File(this.mApkDir, "build/apk");
            if (!this.mConfig.forceBuildAll) {
                LOGGER.info("Checking whether resources has changed...");
            }
            if (this.mConfig.forceBuildAll || this.isModified(this.newFiles(APK_RESOURCES_FILENAMES, this.mApkDir), this.newFiles(APK_RESOURCES_FILENAMES, apkDir))) {
                LOGGER.info("Copying raw resources...");
                this.mApkDir.getDirectory().copyToDir(apkDir, APK_RESOURCES_FILENAMES);
            }
            return true;
        }
        catch (DirectoryException ex) {
            throw new AndrolibException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean buildResourcesFull() throws AndrolibException {
        try {
            if (!new File(this.mApkDir, "res").exists()) {
                return false;
            }
            if (!this.mConfig.forceBuildAll) {
                LOGGER.info("Checking whether resources has changed...");
            }
            File apkDir = new File(this.mApkDir, "build/apk");
            File resourceFile = new File(apkDir.getParent(), "resources.zip");
            if (this.mConfig.forceBuildAll || this.isModified(this.newFiles(APP_RESOURCES_FILENAMES, this.mApkDir), this.newFiles(APK_RESOURCES_FILENAMES, apkDir)) || this.mConfig.isAapt2() && !this.isFile(resourceFile)) {
                LOGGER.info("Building resources...");
                if (this.mConfig.debugMode) {
                    if (this.mConfig.isAapt2()) {
                        LOGGER.info("Using aapt2 - setting 'debuggable' attribute to 'true' in AndroidManifest.xml");
                        ResXmlPatcher.setApplicationDebugTagTrue(new File(this.mApkDir, "AndroidManifest.xml"));
                    } else {
                        ResXmlPatcher.removeApplicationDebugTag(new File(this.mApkDir, "AndroidManifest.xml"));
                    }
                }
                if (this.mConfig.netSecConf) {
                    File netSecConfOrig;
                    ApkInfo meta = ApkInfo.load(new ExtFile(this.mApkDir));
                    if (meta.getSdkInfo() != null && meta.getSdkInfo().get("targetSdkVersion") != null && Integer.parseInt(meta.getSdkInfo().get("targetSdkVersion")) < 24) {
                        LOGGER.warning("Target SDK version is lower than 24! Network Security Configuration might be ignored!");
                    }
                    if ((netSecConfOrig = new File(this.mApkDir, "res/xml/network_security_config.xml")).exists()) {
                        LOGGER.info("Replacing existing network_security_config.xml!");
                        netSecConfOrig.delete();
                    }
                    ResXmlPatcher.modNetworkSecurityConfig(netSecConfOrig);
                    ResXmlPatcher.setNetworkSecurityConfig(new File(this.mApkDir, "AndroidManifest.xml"));
                    LOGGER.info("Added permissive network security config in manifest");
                }
                File apkFile = File.createTempFile("APKTOOL", null);
                apkFile.delete();
                resourceFile.delete();
                File ninePatch = new File(this.mApkDir, "9patch");
                if (!ninePatch.exists()) {
                    ninePatch = null;
                }
                AaptInvoker invoker = new AaptInvoker(this.mConfig, this.mApkInfo);
                invoker.invokeAapt(apkFile, new File(this.mApkDir, "AndroidManifest.xml"), new File(this.mApkDir, "res"), ninePatch, null, this.getIncludeFiles());
                ExtFile tmpExtFile = new ExtFile(apkFile);
                Directory tmpDir = tmpExtFile.getDirectory();
                try {
                    tmpDir.copyToDir(apkDir, tmpDir.containsDir("res") ? APK_RESOURCES_FILENAMES : APK_RESOURCES_WITHOUT_RES_FILENAMES);
                }
                catch (DirectoryException ex) {
                    LOGGER.warning(ex.getMessage());
                }
                finally {
                    tmpExtFile.close();
                }
                apkFile.delete();
            }
            return true;
        }
        catch (BrutException | IOException | ParserConfigurationException | TransformerException | SAXException ex) {
            throw new AndrolibException(ex);
        }
    }

    private boolean buildManifestRaw() throws AndrolibException {
        try {
            File apkDir = new File(this.mApkDir, "build/apk");
            LOGGER.info("Copying raw AndroidManifest.xml...");
            this.mApkDir.getDirectory().copyToDir(apkDir, APK_MANIFEST_FILENAMES);
            return true;
        }
        catch (DirectoryException ex) {
            throw new AndrolibException(ex);
        }
    }

    private boolean buildManifest() throws BrutException {
        try {
            if (!new File(this.mApkDir, "AndroidManifest.xml").exists()) {
                return false;
            }
            if (!this.mConfig.forceBuildAll) {
                LOGGER.info("Checking whether resources has changed...");
            }
            File apkDir = new File(this.mApkDir, "build/apk");
            if (this.mConfig.forceBuildAll || this.isModified(this.newFiles(APK_MANIFEST_FILENAMES, this.mApkDir), this.newFiles(APK_MANIFEST_FILENAMES, apkDir))) {
                LOGGER.info("Building AndroidManifest.xml...");
                File apkFile = File.createTempFile("APKTOOL", null);
                apkFile.delete();
                File ninePatch = new File(this.mApkDir, "9patch");
                if (!ninePatch.exists()) {
                    ninePatch = null;
                }
                AaptInvoker invoker = new AaptInvoker(this.mConfig, this.mApkInfo);
                invoker.invokeAapt(apkFile, new File(this.mApkDir, "AndroidManifest.xml"), null, ninePatch, null, this.getIncludeFiles());
                Directory tmpDir = new ExtFile(apkFile).getDirectory();
                tmpDir.copyToDir(apkDir, APK_MANIFEST_FILENAMES);
                apkFile.delete();
            }
            return true;
        }
        catch (DirectoryException | IOException ex) {
            throw new AndrolibException(ex);
        }
        catch (AndrolibException ex) {
            LOGGER.warning("Parse AndroidManifest.xml failed, treat it as raw file.");
            return this.buildManifestRaw();
        }
    }

    private void buildLibs() throws AndrolibException {
        this.buildLibrary("lib");
        this.buildLibrary("libs");
        this.buildLibrary("kotlin");
        this.buildLibrary("META-INF/services");
    }

    private void buildLibrary(String folder) throws AndrolibException {
        File working = new File(this.mApkDir, folder);
        if (!working.exists()) {
            return;
        }
        File stored = new File(this.mApkDir, "build/apk/" + folder);
        if (this.mConfig.forceBuildAll || this.isModified(working, stored)) {
            LOGGER.info("Copying libs... (/" + folder + ")");
            try {
                OS.rmdir(stored);
                OS.cpdir(working, stored);
            }
            catch (BrutException ex) {
                throw new AndrolibException(ex);
            }
        }
    }

    private void buildCopyOriginalFiles() throws AndrolibException {
        File originalDir;
        if (this.mConfig.copyOriginalFiles && (originalDir = new File(this.mApkDir, "original")).exists()) {
            try {
                LOGGER.info("Copy original files...");
                Directory in = new ExtFile(originalDir).getDirectory();
                if (in.containsFile("AndroidManifest.xml")) {
                    LOGGER.info("Copy AndroidManifest.xml...");
                    in.copyToDir(new File(this.mApkDir, "build/apk"), "AndroidManifest.xml");
                }
                if (in.containsFile("stamp-cert-sha256")) {
                    LOGGER.info("Copy stamp-cert-sha256...");
                    in.copyToDir(new File(this.mApkDir, "build/apk"), "stamp-cert-sha256");
                }
                if (in.containsDir("META-INF")) {
                    LOGGER.info("Copy META-INF...");
                    in.copyToDir(new File(this.mApkDir, "build/apk"), "META-INF");
                }
            }
            catch (DirectoryException ex) {
                throw new AndrolibException(ex);
            }
        }
    }

    private void buildUnknownFiles(File outFile) throws AndrolibException {
        if (this.mApkInfo.unknownFiles != null) {
            LOGGER.info("Copying unknown files/dir...");
            Map<String, String> files = this.mApkInfo.unknownFiles;
            File tempFile = new File(outFile.getParent(), outFile.getName() + ".apktool_temp");
            boolean renamed = outFile.renameTo(tempFile);
            if (!renamed) {
                throw new AndrolibException("Unable to rename temporary file");
            }
            try (ZipFile inputFile = new ZipFile(tempFile);
                 ZipOutputStream actualOutput = new ZipOutputStream(Files.newOutputStream(outFile.toPath(), new OpenOption[0]));){
                this.copyExistingFiles(inputFile, actualOutput);
                this.copyUnknownFiles(actualOutput, files);
            }
            catch (BrutException | IOException ex) {
                throw new AndrolibException(ex);
            }
            tempFile.delete();
        }
    }

    private void copyExistingFiles(ZipFile inputFile, ZipOutputStream outputFile) throws IOException {
        Enumeration<? extends ZipEntry> entries = inputFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = new ZipEntry(entries.nextElement());
            entry.setCompressedSize(-1L);
            outputFile.putNextEntry(entry);
            if (!entry.isDirectory()) {
                BrutIO.copy(inputFile, outputFile, entry);
            }
            outputFile.closeEntry();
        }
    }

    private void copyUnknownFiles(ZipOutputStream outputFile, Map<String, String> files) throws BrutException, IOException {
        File unknownFileDir = new File(this.mApkDir, "unknown");
        for (Map.Entry<String, String> unknownFileInfo : files.entrySet()) {
            File inputFile;
            try {
                inputFile = new File(unknownFileDir, BrutIO.sanitizeFilepath(unknownFileDir, unknownFileInfo.getKey()));
            }
            catch (InvalidUnknownFileException | RootUnknownFileException | TraversalUnknownFileException exception) {
                LOGGER.warning(String.format("Skipping file %s (%s)", unknownFileInfo.getKey(), exception.getMessage()));
                continue;
            }
            if (inputFile.isDirectory()) continue;
            ZipEntry newEntry = new ZipEntry(unknownFileInfo.getKey());
            int method = Integer.parseInt(unknownFileInfo.getValue());
            LOGGER.fine(String.format("Copying unknown file %s with method %d", unknownFileInfo.getKey(), method));
            if (method == 0) {
                newEntry.setMethod(0);
                newEntry.setSize(inputFile.length());
                newEntry.setCompressedSize(-1L);
                BufferedInputStream unknownFile = new BufferedInputStream(Files.newInputStream(inputFile.toPath(), new OpenOption[0]));
                CRC32 crc = BrutIO.calculateCrc(unknownFile);
                newEntry.setCrc(crc.getValue());
                unknownFile.close();
            } else {
                newEntry.setMethod(8);
            }
            outputFile.putNextEntry(newEntry);
            BrutIO.copy(inputFile, outputFile);
            outputFile.closeEntry();
        }
    }

    private void buildApk(File outApk) throws AndrolibException {
        LOGGER.info("Building apk file...");
        if (outApk.exists()) {
            outApk.delete();
        } else {
            File outDir = outApk.getParentFile();
            if (outDir != null && !outDir.exists()) {
                outDir.mkdirs();
            }
        }
        File assetDir = new File(this.mApkDir, "assets");
        if (!assetDir.exists()) {
            assetDir = null;
        }
        this.zipPackage(outApk, new File(this.mApkDir, "build/apk"), assetDir);
    }

    private void zipPackage(File apkFile, File rawDir, File assetDir) throws AndrolibException {
        try {
            ZipUtils.zipFolders(rawDir, apkFile, assetDir, this.mApkInfo.doNotCompress);
        }
        catch (BrutException | IOException ex) {
            throw new AndrolibException(ex);
        }
    }

    private File[] getIncludeFiles() throws AndrolibException {
        UsesFramework usesFramework = this.mApkInfo.usesFramework;
        if (usesFramework == null) {
            return null;
        }
        List<Integer> ids = usesFramework.ids;
        if (ids == null || ids.isEmpty()) {
            return null;
        }
        Framework framework = new Framework(this.mConfig);
        String tag = usesFramework.tag;
        File[] files = new File[ids.size()];
        int i = 0;
        for (int id : ids) {
            files[i++] = framework.getFrameworkApk(id, tag);
        }
        return files;
    }

    private boolean isModified(File working, File stored) {
        return !stored.exists() || BrutIO.recursiveModifiedTime(working) > BrutIO.recursiveModifiedTime(stored);
    }

    private boolean isFile(File working) {
        return working.exists();
    }

    private boolean isModified(File[] working, File[] stored) {
        for (File file : stored) {
            if (file.exists()) continue;
            return true;
        }
        return BrutIO.recursiveModifiedTime(working) > BrutIO.recursiveModifiedTime(stored);
    }

    private File[] newFiles(String[] names, File dir) {
        File[] files = new File[names.length];
        for (int i = 0; i < names.length; ++i) {
            files[i] = new File(dir, names[i]);
        }
        return files;
    }
}

