/*
 * Decompiled with CFR 0.152.
 */
package org.jf.util;

import android.support.annotation.NonNull;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.jf.util.StringWrapper;

public final class TwoColumnOutput {
    private final Writer out;
    private final int leftWidth;
    private final int rightWidth;
    private final String spacer;
    private String[] leftLines;
    private String[] rightLines;

    public TwoColumnOutput(@NonNull Writer out, int leftWidth, int rightWidth, @NonNull String spacer) {
        if (out == null) {
            TwoColumnOutput.$$$reportNull$$$0(0);
        }
        if (spacer == null) {
            TwoColumnOutput.$$$reportNull$$$0(1);
        }
        this.leftLines = null;
        this.rightLines = null;
        if (leftWidth < 1) {
            throw new IllegalArgumentException("leftWidth < 1");
        }
        if (rightWidth < 1) {
            throw new IllegalArgumentException("rightWidth < 1");
        }
        this.out = out;
        this.leftWidth = leftWidth;
        this.rightWidth = rightWidth;
        this.spacer = spacer;
    }

    public TwoColumnOutput(OutputStream out, int leftWidth, int rightWidth, String spacer) {
        this(new OutputStreamWriter(out), leftWidth, rightWidth, spacer);
    }

    public void write(String left, String right) throws IOException {
        this.leftLines = StringWrapper.wrapString(left, this.leftWidth, this.leftLines);
        this.rightLines = StringWrapper.wrapString(right, this.rightWidth, this.rightLines);
        int leftCount = this.leftLines.length;
        int rightCount = this.rightLines.length;
        for (int i = 0; i < leftCount || i < rightCount; ++i) {
            int remaining;
            String leftLine = null;
            String rightLine = null;
            if (i < leftCount && (leftLine = this.leftLines[i]) == null) {
                leftCount = i;
            }
            if (i < rightCount && (rightLine = this.rightLines[i]) == null) {
                rightCount = i;
            }
            if (leftLine == null && rightLine == null) continue;
            int written = 0;
            if (leftLine != null) {
                this.out.write(leftLine);
                written = leftLine.length();
            }
            if ((remaining = this.leftWidth - written) > 0) {
                TwoColumnOutput.writeSpaces(this.out, remaining);
            }
            this.out.write(this.spacer);
            if (rightLine != null) {
                this.out.write(rightLine);
            }
            this.out.write(10);
        }
    }

    private static void writeSpaces(Writer out, int amt) throws IOException {
        while (amt > 0) {
            out.write(32);
            --amt;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "out";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "spacer";
                break;
            }
        }
        objectArray[1] = "org/jf/util/TwoColumnOutput";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NonNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

