/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.writer.pool;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import java.io.IOException;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import org.jf.dexlib2.builder.MutableMethodImplementation;
import org.jf.dexlib2.iface.Annotation;
import org.jf.dexlib2.iface.ClassDef;
import org.jf.dexlib2.iface.ExceptionHandler;
import org.jf.dexlib2.iface.Field;
import org.jf.dexlib2.iface.Method;
import org.jf.dexlib2.iface.MethodImplementation;
import org.jf.dexlib2.iface.MethodParameter;
import org.jf.dexlib2.iface.TryBlock;
import org.jf.dexlib2.iface.debug.DebugItem;
import org.jf.dexlib2.iface.debug.EndLocal;
import org.jf.dexlib2.iface.debug.LineNumber;
import org.jf.dexlib2.iface.debug.RestartLocal;
import org.jf.dexlib2.iface.debug.SetSourceFile;
import org.jf.dexlib2.iface.debug.StartLocal;
import org.jf.dexlib2.iface.instruction.Instruction;
import org.jf.dexlib2.iface.instruction.ReferenceInstruction;
import org.jf.dexlib2.iface.reference.FieldReference;
import org.jf.dexlib2.iface.reference.MethodReference;
import org.jf.dexlib2.iface.reference.Reference;
import org.jf.dexlib2.iface.reference.StringReference;
import org.jf.dexlib2.iface.reference.TypeReference;
import org.jf.dexlib2.iface.value.EncodedValue;
import org.jf.dexlib2.immutable.value.ImmutableEncodedValueFactory;
import org.jf.dexlib2.util.EncodedValueUtils;
import org.jf.dexlib2.util.ReferenceUtil;
import org.jf.dexlib2.writer.ClassSection;
import org.jf.dexlib2.writer.DebugWriter;
import org.jf.dexlib2.writer.pool.AnnotationSetPool;
import org.jf.dexlib2.writer.pool.BasePool;
import org.jf.dexlib2.writer.pool.DexPool;
import org.jf.dexlib2.writer.pool.FieldPool;
import org.jf.dexlib2.writer.pool.MethodPool;
import org.jf.dexlib2.writer.pool.PoolClassDef;
import org.jf.dexlib2.writer.pool.PoolMethod;
import org.jf.dexlib2.writer.pool.StringPool;
import org.jf.dexlib2.writer.pool.TypeListPool;
import org.jf.dexlib2.writer.pool.TypePool;
import org.jf.util.AbstractForwardSequentialList;
import org.jf.util.CollectionUtils;
import org.jf.util.ExceptionWithContext;

public class ClassPool
extends BasePool<String, PoolClassDef>
implements ClassSection<CharSequence, CharSequence, TypeListPool.Key<? extends Collection<? extends CharSequence>>, PoolClassDef, Field, PoolMethod, Set<? extends Annotation>, EncodedValue> {
    private ImmutableList<PoolClassDef> sortedClasses;
    private static final Predicate<Field> HAS_INITIALIZER = new Predicate<Field>(){

        @Override
        public boolean apply(Field input) {
            EncodedValue encodedValue = input.getInitialValue();
            return encodedValue != null && !EncodedValueUtils.isDefaultValue(encodedValue);
        }
    };
    private static final Function<Field, EncodedValue> GET_INITIAL_VALUE = new Function<Field, EncodedValue>(){

        @Override
        public EncodedValue apply(Field input) {
            EncodedValue initialValue = input.getInitialValue();
            if (initialValue == null) {
                return ImmutableEncodedValueFactory.defaultValueForType(input.getType());
            }
            return initialValue;
        }
    };
    private static final Predicate<MethodParameter> HAS_PARAMETER_ANNOTATIONS = new Predicate<MethodParameter>(){

        @Override
        public boolean apply(MethodParameter input) {
            return input.getAnnotations().size() > 0;
        }
    };
    private static final Function<MethodParameter, Set<? extends Annotation>> PARAMETER_ANNOTATIONS = new Function<MethodParameter, Set<? extends Annotation>>(){

        @Override
        public Set<? extends Annotation> apply(MethodParameter input) {
            return input.getAnnotations();
        }
    };

    public ClassPool(@NonNull DexPool dexPool) {
        if (dexPool == null) {
            ClassPool.$$$reportNull$$$0(0);
        }
        super(dexPool);
        this.sortedClasses = null;
    }

    public void intern(@NonNull ClassDef classDef) {
        PoolClassDef poolClassDef;
        PoolClassDef prev;
        if (classDef == null) {
            ClassPool.$$$reportNull$$$0(1);
        }
        if ((prev = this.internedItems.put((poolClassDef = new PoolClassDef(classDef)).getType(), poolClassDef)) != null) {
            throw new ExceptionWithContext("Class %s has already been interned", poolClassDef.getType());
        }
        ((TypePool)this.dexPool.typeSection).intern(poolClassDef.getType());
        ((TypePool)this.dexPool.typeSection).internNullable(poolClassDef.getSuperclass());
        ((TypeListPool)this.dexPool.typeListSection).intern(poolClassDef.getInterfaces());
        ((StringPool)this.dexPool.stringSection).internNullable(poolClassDef.getSourceFile());
        HashSet<String> fields = new HashSet<String>();
        for (Field field : poolClassDef.getFields()) {
            String fieldDescriptor = ReferenceUtil.getShortFieldDescriptor(field);
            if (!fields.add(fieldDescriptor)) {
                throw new ExceptionWithContext("Multiple definitions for field %s->%s", poolClassDef.getType(), fieldDescriptor);
            }
            ((FieldPool)this.dexPool.fieldSection).intern(field);
            EncodedValue initialValue = field.getInitialValue();
            if (initialValue != null) {
                this.dexPool.internEncodedValue(initialValue);
            }
            ((AnnotationSetPool)this.dexPool.annotationSetSection).intern(field.getAnnotations());
        }
        HashSet<String> methods = new HashSet<String>();
        for (PoolMethod method : poolClassDef.getMethods()) {
            String methodDescriptor = ReferenceUtil.getMethodDescriptor(method, true);
            if (!methods.add(methodDescriptor)) {
                throw new ExceptionWithContext("Multiple definitions for method %s->%s", poolClassDef.getType(), methodDescriptor);
            }
            ((MethodPool)this.dexPool.methodSection).intern(method);
            this.internCode(method);
            this.internDebug(method);
            ((AnnotationSetPool)this.dexPool.annotationSetSection).intern(method.getAnnotations());
            for (MethodParameter methodParameter : method.getParameters()) {
                ((AnnotationSetPool)this.dexPool.annotationSetSection).intern(methodParameter.getAnnotations());
            }
        }
        ((AnnotationSetPool)this.dexPool.annotationSetSection).intern(poolClassDef.getAnnotations());
    }

    private void internCode(@NonNull Method method) {
        if (method == null) {
            ClassPool.$$$reportNull$$$0(2);
        }
        boolean hasInstruction = false;
        MethodImplementation methodImpl = method.getImplementation();
        if (methodImpl != null) {
            block6: for (Instruction instruction : methodImpl.getInstructions()) {
                hasInstruction = true;
                if (!(instruction instanceof ReferenceInstruction)) continue;
                Reference reference = ((ReferenceInstruction)instruction).getReference();
                switch (instruction.getOpcode().referenceType) {
                    case 0: {
                        ((StringPool)this.dexPool.stringSection).intern((StringReference)reference);
                        continue block6;
                    }
                    case 1: {
                        ((TypePool)this.dexPool.typeSection).intern((TypeReference)reference);
                        continue block6;
                    }
                    case 2: {
                        ((FieldPool)this.dexPool.fieldSection).intern((FieldReference)reference);
                        continue block6;
                    }
                    case 3: {
                        ((MethodPool)this.dexPool.methodSection).intern((MethodReference)reference);
                        continue block6;
                    }
                }
                throw new ExceptionWithContext("Unrecognized reference type: %d", instruction.getOpcode().referenceType);
            }
            List<? extends TryBlock<? extends ExceptionHandler>> tryBlocks = methodImpl.getTryBlocks();
            if (!hasInstruction && tryBlocks.size() > 0) {
                throw new ExceptionWithContext("Method %s has no instructions, but has try blocks.", ReferenceUtil.getMethodDescriptor(method));
            }
            for (TryBlock<? extends ExceptionHandler> tryBlock : methodImpl.getTryBlocks()) {
                for (ExceptionHandler exceptionHandler : tryBlock.getExceptionHandlers()) {
                    ((TypePool)this.dexPool.typeSection).internNullable(exceptionHandler.getExceptionType());
                }
            }
        }
    }

    private void internDebug(@NonNull Method method) {
        if (method == null) {
            ClassPool.$$$reportNull$$$0(3);
        }
        for (MethodParameter methodParameter : method.getParameters()) {
            String string = methodParameter.getName();
            if (string == null) continue;
            ((StringPool)this.dexPool.stringSection).intern(string);
        }
        MethodImplementation methodImpl = method.getImplementation();
        if (methodImpl != null) {
            for (DebugItem debugItem : methodImpl.getDebugItems()) {
                switch (debugItem.getDebugItemType()) {
                    case 3: {
                        StartLocal startLocal = (StartLocal)debugItem;
                        ((StringPool)this.dexPool.stringSection).internNullable(startLocal.getName());
                        ((TypePool)this.dexPool.typeSection).internNullable(startLocal.getType());
                        ((StringPool)this.dexPool.stringSection).internNullable(startLocal.getSignature());
                        break;
                    }
                    case 9: {
                        ((StringPool)this.dexPool.stringSection).internNullable(((SetSourceFile)debugItem).getSourceFile());
                    }
                }
            }
        }
    }

    @Override
    @NonNull
    public Collection<? extends PoolClassDef> getSortedClasses() {
        if (this.sortedClasses == null) {
            this.sortedClasses = Ordering.natural().immutableSortedCopy(this.internedItems.values());
        }
        ImmutableList<PoolClassDef> immutableList = this.sortedClasses;
        if (immutableList == null) {
            ClassPool.$$$reportNull$$$0(4);
        }
        return immutableList;
    }

    @Override
    @Nullable
    public Map.Entry<? extends PoolClassDef, Integer> getClassEntryByType(@Nullable CharSequence name) {
        if (name == null) {
            return null;
        }
        final PoolClassDef classDef = (PoolClassDef)this.internedItems.get(name.toString());
        if (classDef == null) {
            return null;
        }
        return new Map.Entry<PoolClassDef, Integer>(){

            @Override
            public PoolClassDef getKey() {
                return classDef;
            }

            @Override
            public Integer getValue() {
                return classDef.classDefIndex;
            }

            @Override
            public Integer setValue(Integer value) {
                classDef.classDefIndex = value;
                return classDef.classDefIndex;
            }
        };
    }

    @Override
    @NonNull
    public CharSequence getType(@NonNull PoolClassDef classDef) {
        if (classDef == null) {
            ClassPool.$$$reportNull$$$0(5);
        }
        String string = classDef.getType();
        if (string == null) {
            ClassPool.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Override
    public int getAccessFlags(@NonNull PoolClassDef classDef) {
        if (classDef == null) {
            ClassPool.$$$reportNull$$$0(7);
        }
        return classDef.getAccessFlags();
    }

    @Override
    @Nullable
    public CharSequence getSuperclass(@NonNull PoolClassDef classDef) {
        if (classDef == null) {
            ClassPool.$$$reportNull$$$0(8);
        }
        return classDef.getSuperclass();
    }

    @Override
    @Nullable
    public TypeListPool.Key<List<String>> getInterfaces(@NonNull PoolClassDef classDef) {
        if (classDef == null) {
            ClassPool.$$$reportNull$$$0(9);
        }
        return classDef.interfaces;
    }

    @Override
    @Nullable
    public CharSequence getSourceFile(@NonNull PoolClassDef classDef) {
        if (classDef == null) {
            ClassPool.$$$reportNull$$$0(10);
        }
        return classDef.getSourceFile();
    }

    @Override
    @Nullable
    public Collection<? extends EncodedValue> getStaticInitializers(@NonNull PoolClassDef classDef) {
        Iterable sortedStaticFields;
        int lastIndex;
        if (classDef == null) {
            ClassPool.$$$reportNull$$$0(11);
        }
        if ((lastIndex = CollectionUtils.lastIndexOf(sortedStaticFields = classDef.getStaticFields(), HAS_INITIALIZER)) > -1) {
            return new AbstractCollection<EncodedValue>((SortedSet)sortedStaticFields, lastIndex){
                final /* synthetic */ SortedSet val$sortedStaticFields;
                final /* synthetic */ int val$lastIndex;
                {
                    this.val$sortedStaticFields = sortedSet;
                    this.val$lastIndex = n;
                }

                @Override
                @NonNull
                public Iterator<EncodedValue> iterator() {
                    Iterator<EncodedValue> iterator = FluentIterable.from(this.val$sortedStaticFields).limit(this.val$lastIndex + 1).transform(GET_INITIAL_VALUE).iterator();
                    if (iterator == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    return iterator;
                }

                @Override
                public int size() {
                    return this.val$lastIndex + 1;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NonNull method %s.%s must not return null", "org/jf/dexlib2/writer/pool/ClassPool$4", "iterator"));
                }
            };
        }
        return null;
    }

    @Override
    @NonNull
    public Collection<? extends Field> getSortedStaticFields(@NonNull PoolClassDef classDef) {
        if (classDef == null) {
            ClassPool.$$$reportNull$$$0(12);
        }
        Iterable iterable = classDef.getStaticFields();
        if (iterable == null) {
            ClassPool.$$$reportNull$$$0(13);
        }
        return iterable;
    }

    @Override
    @NonNull
    public Collection<? extends Field> getSortedInstanceFields(@NonNull PoolClassDef classDef) {
        if (classDef == null) {
            ClassPool.$$$reportNull$$$0(14);
        }
        Iterable iterable = classDef.getInstanceFields();
        if (iterable == null) {
            ClassPool.$$$reportNull$$$0(15);
        }
        return iterable;
    }

    @Override
    @NonNull
    public Collection<? extends Field> getSortedFields(@NonNull PoolClassDef classDef) {
        if (classDef == null) {
            ClassPool.$$$reportNull$$$0(16);
        }
        Iterable iterable = classDef.getFields();
        if (iterable == null) {
            ClassPool.$$$reportNull$$$0(17);
        }
        return iterable;
    }

    @Override
    @NonNull
    public Collection<PoolMethod> getSortedDirectMethods(@NonNull PoolClassDef classDef) {
        if (classDef == null) {
            ClassPool.$$$reportNull$$$0(18);
        }
        Iterable iterable = classDef.getDirectMethods();
        if (iterable == null) {
            ClassPool.$$$reportNull$$$0(19);
        }
        return iterable;
    }

    @Override
    @NonNull
    public Collection<PoolMethod> getSortedVirtualMethods(@NonNull PoolClassDef classDef) {
        if (classDef == null) {
            ClassPool.$$$reportNull$$$0(20);
        }
        Iterable iterable = classDef.getVirtualMethods();
        if (iterable == null) {
            ClassPool.$$$reportNull$$$0(21);
        }
        return iterable;
    }

    @Override
    @NonNull
    public Collection<? extends PoolMethod> getSortedMethods(@NonNull PoolClassDef classDef) {
        if (classDef == null) {
            ClassPool.$$$reportNull$$$0(22);
        }
        Iterable iterable = classDef.getMethods();
        if (iterable == null) {
            ClassPool.$$$reportNull$$$0(23);
        }
        return iterable;
    }

    @Override
    public int getFieldAccessFlags(@NonNull Field field) {
        if (field == null) {
            ClassPool.$$$reportNull$$$0(24);
        }
        return field.getAccessFlags();
    }

    @Override
    public int getMethodAccessFlags(@NonNull PoolMethod method) {
        if (method == null) {
            ClassPool.$$$reportNull$$$0(25);
        }
        return method.getAccessFlags();
    }

    @Override
    @Nullable
    public Set<? extends Annotation> getClassAnnotations(@NonNull PoolClassDef classDef) {
        Set<? extends Annotation> annotations;
        if (classDef == null) {
            ClassPool.$$$reportNull$$$0(26);
        }
        if ((annotations = classDef.getAnnotations()).size() == 0) {
            return null;
        }
        return annotations;
    }

    @Override
    @Nullable
    public Set<? extends Annotation> getFieldAnnotations(@NonNull Field field) {
        Set<? extends Annotation> annotations;
        if (field == null) {
            ClassPool.$$$reportNull$$$0(27);
        }
        if ((annotations = field.getAnnotations()).size() == 0) {
            return null;
        }
        return annotations;
    }

    @Override
    @Nullable
    public Set<? extends Annotation> getMethodAnnotations(@NonNull PoolMethod method) {
        Set<? extends Annotation> annotations;
        if (method == null) {
            ClassPool.$$$reportNull$$$0(28);
        }
        if ((annotations = method.getAnnotations()).size() == 0) {
            return null;
        }
        return annotations;
    }

    @Override
    @Nullable
    public List<? extends Set<? extends Annotation>> getParameterAnnotations(@NonNull PoolMethod method) {
        List<? extends MethodParameter> parameters;
        boolean hasParameterAnnotations;
        if (method == null) {
            ClassPool.$$$reportNull$$$0(29);
        }
        if (hasParameterAnnotations = Iterables.any(parameters = method.getParameters(), HAS_PARAMETER_ANNOTATIONS)) {
            return new AbstractForwardSequentialList<Set<? extends Annotation>>(){

                @Override
                @NonNull
                public Iterator<Set<? extends Annotation>> iterator() {
                    Iterator<Set<? extends Annotation>> iterator = FluentIterable.from(parameters).transform(PARAMETER_ANNOTATIONS).iterator();
                    if (iterator == null) {
                        7.$$$reportNull$$$0(0);
                    }
                    return iterator;
                }

                @Override
                public int size() {
                    return parameters.size();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NonNull method %s.%s must not return null", "org/jf/dexlib2/writer/pool/ClassPool$7", "iterator"));
                }
            };
        }
        return null;
    }

    @Override
    @Nullable
    public Iterable<? extends DebugItem> getDebugItems(@NonNull PoolMethod method) {
        MethodImplementation impl;
        if (method == null) {
            ClassPool.$$$reportNull$$$0(30);
        }
        if ((impl = method.getImplementation()) != null) {
            return impl.getDebugItems();
        }
        return null;
    }

    @Override
    @Nullable
    public Iterable<CharSequence> getParameterNames(@NonNull PoolMethod method) {
        if (method == null) {
            ClassPool.$$$reportNull$$$0(31);
        }
        return Iterables.transform(method.getParameters(), new Function<MethodParameter, CharSequence>(){

            @Override
            @Nullable
            public CharSequence apply(MethodParameter input) {
                return input.getName();
            }
        });
    }

    @Override
    public int getRegisterCount(@NonNull PoolMethod method) {
        MethodImplementation impl;
        if (method == null) {
            ClassPool.$$$reportNull$$$0(32);
        }
        if ((impl = method.getImplementation()) != null) {
            return impl.getRegisterCount();
        }
        return 0;
    }

    @Override
    @Nullable
    public Iterable<? extends Instruction> getInstructions(@NonNull PoolMethod method) {
        MethodImplementation impl;
        if (method == null) {
            ClassPool.$$$reportNull$$$0(33);
        }
        if ((impl = method.getImplementation()) != null) {
            return impl.getInstructions();
        }
        return null;
    }

    @Override
    @NonNull
    public List<? extends TryBlock<? extends ExceptionHandler>> getTryBlocks(@NonNull PoolMethod method) {
        MethodImplementation impl;
        if (method == null) {
            ClassPool.$$$reportNull$$$0(34);
        }
        if ((impl = method.getImplementation()) != null) {
            List<? extends TryBlock<? extends ExceptionHandler>> list = impl.getTryBlocks();
            if (list == null) {
                ClassPool.$$$reportNull$$$0(35);
            }
            return list;
        }
        ImmutableList immutableList = ImmutableList.of();
        if (immutableList == null) {
            ClassPool.$$$reportNull$$$0(36);
        }
        return immutableList;
    }

    @Override
    @Nullable
    public CharSequence getExceptionType(@NonNull ExceptionHandler handler) {
        if (handler == null) {
            ClassPool.$$$reportNull$$$0(37);
        }
        return handler.getExceptionType();
    }

    @Override
    @NonNull
    public MutableMethodImplementation makeMutableMethodImplementation(@NonNull PoolMethod poolMethod) {
        if (poolMethod == null) {
            ClassPool.$$$reportNull$$$0(38);
        }
        MutableMethodImplementation mutableMethodImplementation = new MutableMethodImplementation(poolMethod.getImplementation());
        if (mutableMethodImplementation == null) {
            ClassPool.$$$reportNull$$$0(39);
        }
        return mutableMethodImplementation;
    }

    @Override
    public void setEncodedArrayOffset(@NonNull PoolClassDef classDef, int offset) {
        if (classDef == null) {
            ClassPool.$$$reportNull$$$0(40);
        }
        classDef.encodedArrayOffset = offset;
    }

    @Override
    public int getEncodedArrayOffset(@NonNull PoolClassDef classDef) {
        if (classDef == null) {
            ClassPool.$$$reportNull$$$0(41);
        }
        return classDef.encodedArrayOffset;
    }

    @Override
    public void setAnnotationDirectoryOffset(@NonNull PoolClassDef classDef, int offset) {
        if (classDef == null) {
            ClassPool.$$$reportNull$$$0(42);
        }
        classDef.annotationDirectoryOffset = offset;
    }

    @Override
    public int getAnnotationDirectoryOffset(@NonNull PoolClassDef classDef) {
        if (classDef == null) {
            ClassPool.$$$reportNull$$$0(43);
        }
        return classDef.annotationDirectoryOffset;
    }

    @Override
    public void setAnnotationSetRefListOffset(@NonNull PoolMethod method, int offset) {
        if (method == null) {
            ClassPool.$$$reportNull$$$0(44);
        }
        method.annotationSetRefListOffset = offset;
    }

    @Override
    public int getAnnotationSetRefListOffset(@NonNull PoolMethod method) {
        if (method == null) {
            ClassPool.$$$reportNull$$$0(45);
        }
        return method.annotationSetRefListOffset;
    }

    @Override
    public void setCodeItemOffset(@NonNull PoolMethod method, int offset) {
        if (method == null) {
            ClassPool.$$$reportNull$$$0(46);
        }
        method.codeItemOffset = offset;
    }

    @Override
    public int getCodeItemOffset(@NonNull PoolMethod method) {
        if (method == null) {
            ClassPool.$$$reportNull$$$0(47);
        }
        return method.codeItemOffset;
    }

    @Override
    public void writeDebugItem(@NonNull DebugWriter<CharSequence, CharSequence> writer, DebugItem debugItem) throws IOException {
        if (writer == null) {
            ClassPool.$$$reportNull$$$0(48);
        }
        switch (debugItem.getDebugItemType()) {
            case 3: {
                StartLocal startLocal = (StartLocal)debugItem;
                writer.writeStartLocal(startLocal.getCodeAddress(), startLocal.getRegister(), startLocal.getName(), startLocal.getType(), startLocal.getSignature());
                break;
            }
            case 5: {
                EndLocal endLocal = (EndLocal)debugItem;
                writer.writeEndLocal(endLocal.getCodeAddress(), endLocal.getRegister());
                break;
            }
            case 6: {
                RestartLocal restartLocal = (RestartLocal)debugItem;
                writer.writeRestartLocal(restartLocal.getCodeAddress(), restartLocal.getRegister());
                break;
            }
            case 7: {
                writer.writePrologueEnd(debugItem.getCodeAddress());
                break;
            }
            case 8: {
                writer.writeEpilogueBegin(debugItem.getCodeAddress());
                break;
            }
            case 10: {
                LineNumber lineNumber = (LineNumber)debugItem;
                writer.writeLineNumber(lineNumber.getCodeAddress(), lineNumber.getLineNumber());
                break;
            }
            case 9: {
                SetSourceFile setSourceFile = (SetSourceFile)debugItem;
                writer.writeSetSourceFile(setSourceFile.getCodeAddress(), setSourceFile.getSourceFile());
            }
            default: {
                throw new ExceptionWithContext("Unexpected debug item type: %d", debugItem.getDebugItemType());
            }
        }
    }

    @Override
    public int getItemIndex(@NonNull PoolClassDef classDef) {
        if (classDef == null) {
            ClassPool.$$$reportNull$$$0(49);
        }
        return classDef.classDefIndex;
    }

    @Override
    @NonNull
    public Collection<? extends Map.Entry<PoolClassDef, Integer>> getItems() {
        AbstractCollection<Map.Entry<PoolClassDef, Integer>> abstractCollection = new AbstractCollection<Map.Entry<PoolClassDef, Integer>>(){

            @Override
            @NonNull
            public Iterator<Map.Entry<PoolClassDef, Integer>> iterator() {
                Iterator<Map.Entry<PoolClassDef, Integer>> iterator = new Iterator<Map.Entry<PoolClassDef, Integer>>(){
                    Iterator<PoolClassDef> iter;
                    {
                        this.iter = ClassPool.this.internedItems.values().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iter.hasNext();
                    }

                    @Override
                    public Map.Entry<PoolClassDef, Integer> next() {
                        class MapEntry
                        implements Map.Entry<PoolClassDef, Integer> {
                            @NonNull
                            private final PoolClassDef classDef;

                            public MapEntry(PoolClassDef classDef) {
                                if (classDef == null) {
                                    MapEntry.$$$reportNull$$$0(0);
                                }
                                this.classDef = classDef;
                            }

                            @Override
                            public PoolClassDef getKey() {
                                return this.classDef;
                            }

                            @Override
                            public Integer getValue() {
                                return this.classDef.classDefIndex;
                            }

                            @Override
                            public Integer setValue(Integer value) {
                                int prev = this.classDef.classDefIndex;
                                this.classDef.classDefIndex = value;
                                return prev;
                            }

                            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                throw new IllegalArgumentException(String.format("Argument for @NonNull parameter '%s' of %s.%s must not be null", "classDef", "org/jf/dexlib2/writer/pool/ClassPool$1MapEntry", "<init>"));
                            }
                        }
                        return new MapEntry(this.iter.next());
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
                if (iterator == null) {
                    9.$$$reportNull$$$0(0);
                }
                return iterator;
            }

            @Override
            public int size() {
                return ClassPool.this.internedItems.size();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NonNull method %s.%s must not return null", "org/jf/dexlib2/writer/pool/ClassPool$9", "iterator"));
            }
        };
        if (abstractCollection == null) {
            ClassPool.$$$reportNull$$$0(50);
        }
        return abstractCollection;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NonNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 35: 
            case 36: 
            case 39: 
            case 50: {
                string = "@NonNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 35: 
            case 36: 
            case 39: 
            case 50: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dexPool";
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 26: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classDef";
                break;
            }
            case 2: 
            case 3: 
            case 25: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 4: 
            case 6: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 35: 
            case 36: 
            case 39: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jf/dexlib2/writer/pool/ClassPool";
                break;
            }
            case 24: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "poolMethod";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "writer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jf/dexlib2/writer/pool/ClassPool";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSortedClasses";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getSortedStaticFields";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getSortedInstanceFields";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getSortedFields";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getSortedDirectMethods";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getSortedVirtualMethods";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getSortedMethods";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getTryBlocks";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "makeMutableMethodImplementation";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "getItems";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "intern";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "internCode";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "internDebug";
                break;
            }
            case 4: 
            case 6: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 35: 
            case 36: 
            case 39: 
            case 50: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getType";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getAccessFlags";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getSuperclass";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getInterfaces";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getSourceFile";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getStaticInitializers";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getSortedStaticFields";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getSortedInstanceFields";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getSortedFields";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getSortedDirectMethods";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getSortedVirtualMethods";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getSortedMethods";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getFieldAccessFlags";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getMethodAccessFlags";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getClassAnnotations";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getFieldAnnotations";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getMethodAnnotations";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getParameterAnnotations";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getDebugItems";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getParameterNames";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getRegisterCount";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getInstructions";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getTryBlocks";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getExceptionType";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "makeMutableMethodImplementation";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "setEncodedArrayOffset";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getEncodedArrayOffset";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "setAnnotationDirectoryOffset";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotationDirectoryOffset";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "setAnnotationSetRefListOffset";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotationSetRefListOffset";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "setCodeItemOffset";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getCodeItemOffset";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "writeDebugItem";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "getItemIndex";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 35: 
            case 36: 
            case 39: 
            case 50: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

