/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.writer;

import android.support.annotation.NonNull;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Ordering;
import com.google.common.primitives.Ints;
import java.io.IOException;
import java.util.Comparator;
import java.util.List;
import org.jf.dexlib2.Opcode;
import org.jf.dexlib2.Opcodes;
import org.jf.dexlib2.iface.instruction.DualReferenceInstruction;
import org.jf.dexlib2.iface.instruction.ReferenceInstruction;
import org.jf.dexlib2.iface.instruction.SwitchElement;
import org.jf.dexlib2.iface.instruction.formats.ArrayPayload;
import org.jf.dexlib2.iface.instruction.formats.Instruction10t;
import org.jf.dexlib2.iface.instruction.formats.Instruction10x;
import org.jf.dexlib2.iface.instruction.formats.Instruction11n;
import org.jf.dexlib2.iface.instruction.formats.Instruction11x;
import org.jf.dexlib2.iface.instruction.formats.Instruction12x;
import org.jf.dexlib2.iface.instruction.formats.Instruction20bc;
import org.jf.dexlib2.iface.instruction.formats.Instruction20t;
import org.jf.dexlib2.iface.instruction.formats.Instruction21c;
import org.jf.dexlib2.iface.instruction.formats.Instruction21ih;
import org.jf.dexlib2.iface.instruction.formats.Instruction21lh;
import org.jf.dexlib2.iface.instruction.formats.Instruction21s;
import org.jf.dexlib2.iface.instruction.formats.Instruction21t;
import org.jf.dexlib2.iface.instruction.formats.Instruction22b;
import org.jf.dexlib2.iface.instruction.formats.Instruction22c;
import org.jf.dexlib2.iface.instruction.formats.Instruction22cs;
import org.jf.dexlib2.iface.instruction.formats.Instruction22s;
import org.jf.dexlib2.iface.instruction.formats.Instruction22t;
import org.jf.dexlib2.iface.instruction.formats.Instruction22x;
import org.jf.dexlib2.iface.instruction.formats.Instruction23x;
import org.jf.dexlib2.iface.instruction.formats.Instruction30t;
import org.jf.dexlib2.iface.instruction.formats.Instruction31c;
import org.jf.dexlib2.iface.instruction.formats.Instruction31i;
import org.jf.dexlib2.iface.instruction.formats.Instruction31t;
import org.jf.dexlib2.iface.instruction.formats.Instruction32x;
import org.jf.dexlib2.iface.instruction.formats.Instruction35c;
import org.jf.dexlib2.iface.instruction.formats.Instruction35mi;
import org.jf.dexlib2.iface.instruction.formats.Instruction35ms;
import org.jf.dexlib2.iface.instruction.formats.Instruction3rc;
import org.jf.dexlib2.iface.instruction.formats.Instruction3rmi;
import org.jf.dexlib2.iface.instruction.formats.Instruction3rms;
import org.jf.dexlib2.iface.instruction.formats.Instruction45cc;
import org.jf.dexlib2.iface.instruction.formats.Instruction4rcc;
import org.jf.dexlib2.iface.instruction.formats.Instruction51l;
import org.jf.dexlib2.iface.instruction.formats.PackedSwitchPayload;
import org.jf.dexlib2.iface.instruction.formats.SparseSwitchPayload;
import org.jf.dexlib2.iface.reference.FieldReference;
import org.jf.dexlib2.iface.reference.MethodProtoReference;
import org.jf.dexlib2.iface.reference.MethodReference;
import org.jf.dexlib2.iface.reference.Reference;
import org.jf.dexlib2.iface.reference.StringReference;
import org.jf.dexlib2.iface.reference.TypeReference;
import org.jf.dexlib2.writer.DexDataWriter;
import org.jf.dexlib2.writer.FieldSection;
import org.jf.dexlib2.writer.MethodSection;
import org.jf.dexlib2.writer.ProtoSection;
import org.jf.dexlib2.writer.StringSection;
import org.jf.dexlib2.writer.TypeSection;
import org.jf.util.ExceptionWithContext;

public class InstructionWriter<StringRef extends StringReference, TypeRef extends TypeReference, FieldRefKey extends FieldReference, MethodRefKey extends MethodReference, ProtoRefKey extends MethodProtoReference> {
    @NonNull
    private final Opcodes opcodes;
    @NonNull
    private final DexDataWriter writer;
    @NonNull
    private final StringSection<?, StringRef> stringSection;
    @NonNull
    private final TypeSection<?, ?, TypeRef> typeSection;
    @NonNull
    private final FieldSection<?, ?, FieldRefKey, ?> fieldSection;
    @NonNull
    private final MethodSection<?, ?, ?, MethodRefKey, ?> methodSection;
    @NonNull
    private final ProtoSection<?, ?, ProtoRefKey, ?> protoSection;
    private final Comparator<SwitchElement> switchElementComparator;

    @NonNull
    static <StringRef extends StringReference, TypeRef extends TypeReference, FieldRefKey extends FieldReference, MethodRefKey extends MethodReference, ProtoRefKey extends MethodProtoReference> InstructionWriter<StringRef, TypeRef, FieldRefKey, MethodRefKey, ProtoRefKey> makeInstructionWriter(@NonNull Opcodes opcodes, @NonNull DexDataWriter writer, @NonNull StringSection<?, StringRef> stringSection, @NonNull TypeSection<?, ?, TypeRef> typeSection, @NonNull FieldSection<?, ?, FieldRefKey, ?> fieldSection, @NonNull MethodSection<?, ?, ?, MethodRefKey, ?> methodSection, @NonNull ProtoSection<?, ?, ProtoRefKey, ?> protoSection) {
        if (opcodes == null) {
            InstructionWriter.$$$reportNull$$$0(0);
        }
        if (writer == null) {
            InstructionWriter.$$$reportNull$$$0(1);
        }
        if (stringSection == null) {
            InstructionWriter.$$$reportNull$$$0(2);
        }
        if (typeSection == null) {
            InstructionWriter.$$$reportNull$$$0(3);
        }
        if (fieldSection == null) {
            InstructionWriter.$$$reportNull$$$0(4);
        }
        if (methodSection == null) {
            InstructionWriter.$$$reportNull$$$0(5);
        }
        if (protoSection == null) {
            InstructionWriter.$$$reportNull$$$0(6);
        }
        InstructionWriter<StringRef, TypeRef, FieldRefKey, MethodRefKey, ProtoRefKey> instructionWriter = new InstructionWriter<StringRef, TypeRef, FieldRefKey, MethodRefKey, ProtoRefKey>(opcodes, writer, stringSection, typeSection, fieldSection, methodSection, protoSection);
        if (instructionWriter == null) {
            InstructionWriter.$$$reportNull$$$0(7);
        }
        return instructionWriter;
    }

    InstructionWriter(@NonNull Opcodes opcodes, @NonNull DexDataWriter writer, @NonNull StringSection<?, StringRef> stringSection, @NonNull TypeSection<?, ?, TypeRef> typeSection, @NonNull FieldSection<?, ?, FieldRefKey, ?> fieldSection, @NonNull MethodSection<?, ?, ?, MethodRefKey, ?> methodSection, @NonNull ProtoSection<?, ?, ProtoRefKey, ?> protoSection) {
        if (opcodes == null) {
            InstructionWriter.$$$reportNull$$$0(8);
        }
        if (writer == null) {
            InstructionWriter.$$$reportNull$$$0(9);
        }
        if (stringSection == null) {
            InstructionWriter.$$$reportNull$$$0(10);
        }
        if (typeSection == null) {
            InstructionWriter.$$$reportNull$$$0(11);
        }
        if (fieldSection == null) {
            InstructionWriter.$$$reportNull$$$0(12);
        }
        if (methodSection == null) {
            InstructionWriter.$$$reportNull$$$0(13);
        }
        if (protoSection == null) {
            InstructionWriter.$$$reportNull$$$0(14);
        }
        this.switchElementComparator = new Comparator<SwitchElement>(){

            @Override
            public int compare(SwitchElement element1, SwitchElement element2) {
                return Ints.compare(element1.getKey(), element2.getKey());
            }
        };
        this.opcodes = opcodes;
        this.writer = writer;
        this.stringSection = stringSection;
        this.typeSection = typeSection;
        this.fieldSection = fieldSection;
        this.methodSection = methodSection;
        this.protoSection = protoSection;
    }

    private short getOpcodeValue(Opcode opcode) {
        Short value = this.opcodes.getOpcodeValue(opcode);
        if (value == null) {
            throw new ExceptionWithContext("Instruction %s is invalid for api %d", opcode.name, this.opcodes.api);
        }
        return value;
    }

    public void write(@NonNull Instruction10t instruction) {
        if (instruction == null) {
            InstructionWriter.$$$reportNull$$$0(15);
        }
        try {
            this.writer.write(this.getOpcodeValue(instruction.getOpcode()));
            this.writer.write(instruction.getCodeOffset());
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void write(@NonNull Instruction10x instruction) {
        if (instruction == null) {
            InstructionWriter.$$$reportNull$$$0(16);
        }
        try {
            this.writer.write(this.getOpcodeValue(instruction.getOpcode()));
            this.writer.write(0);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void write(@NonNull Instruction11n instruction) {
        if (instruction == null) {
            InstructionWriter.$$$reportNull$$$0(17);
        }
        try {
            this.writer.write(this.getOpcodeValue(instruction.getOpcode()));
            this.writer.write(InstructionWriter.packNibbles(instruction.getRegisterA(), instruction.getNarrowLiteral()));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void write(@NonNull Instruction11x instruction) {
        if (instruction == null) {
            InstructionWriter.$$$reportNull$$$0(18);
        }
        try {
            this.writer.write(this.getOpcodeValue(instruction.getOpcode()));
            this.writer.write(instruction.getRegisterA());
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void write(@NonNull Instruction12x instruction) {
        if (instruction == null) {
            InstructionWriter.$$$reportNull$$$0(19);
        }
        try {
            this.writer.write(this.getOpcodeValue(instruction.getOpcode()));
            this.writer.write(InstructionWriter.packNibbles(instruction.getRegisterA(), instruction.getRegisterB()));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void write(@NonNull Instruction20bc instruction) {
        if (instruction == null) {
            InstructionWriter.$$$reportNull$$$0(20);
        }
        try {
            this.writer.write(this.getOpcodeValue(instruction.getOpcode()));
            this.writer.write(instruction.getVerificationError());
            this.writer.writeUshort(this.getReferenceIndex(instruction));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void write(@NonNull Instruction20t instruction) {
        if (instruction == null) {
            InstructionWriter.$$$reportNull$$$0(21);
        }
        try {
            this.writer.write(this.getOpcodeValue(instruction.getOpcode()));
            this.writer.write(0);
            this.writer.writeShort(instruction.getCodeOffset());
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void write(@NonNull Instruction21c instruction) {
        if (instruction == null) {
            InstructionWriter.$$$reportNull$$$0(22);
        }
        try {
            this.writer.write(this.getOpcodeValue(instruction.getOpcode()));
            this.writer.write(instruction.getRegisterA());
            this.writer.writeUshort(this.getReferenceIndex(instruction));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void write(@NonNull Instruction21ih instruction) {
        if (instruction == null) {
            InstructionWriter.$$$reportNull$$$0(23);
        }
        try {
            this.writer.write(this.getOpcodeValue(instruction.getOpcode()));
            this.writer.write(instruction.getRegisterA());
            this.writer.writeShort(instruction.getHatLiteral());
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void write(@NonNull Instruction21lh instruction) {
        if (instruction == null) {
            InstructionWriter.$$$reportNull$$$0(24);
        }
        try {
            this.writer.write(this.getOpcodeValue(instruction.getOpcode()));
            this.writer.write(instruction.getRegisterA());
            this.writer.writeShort(instruction.getHatLiteral());
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void write(@NonNull Instruction21s instruction) {
        if (instruction == null) {
            InstructionWriter.$$$reportNull$$$0(25);
        }
        try {
            this.writer.write(this.getOpcodeValue(instruction.getOpcode()));
            this.writer.write(instruction.getRegisterA());
            this.writer.writeShort(instruction.getNarrowLiteral());
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void write(@NonNull Instruction21t instruction) {
        if (instruction == null) {
            InstructionWriter.$$$reportNull$$$0(26);
        }
        try {
            this.writer.write(this.getOpcodeValue(instruction.getOpcode()));
            this.writer.write(instruction.getRegisterA());
            this.writer.writeShort(instruction.getCodeOffset());
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void write(@NonNull Instruction22b instruction) {
        if (instruction == null) {
            InstructionWriter.$$$reportNull$$$0(27);
        }
        try {
            this.writer.write(this.getOpcodeValue(instruction.getOpcode()));
            this.writer.write(instruction.getRegisterA());
            this.writer.write(instruction.getRegisterB());
            this.writer.write(instruction.getNarrowLiteral());
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void write(@NonNull Instruction22c instruction) {
        if (instruction == null) {
            InstructionWriter.$$$reportNull$$$0(28);
        }
        try {
            this.writer.write(this.getOpcodeValue(instruction.getOpcode()));
            this.writer.write(InstructionWriter.packNibbles(instruction.getRegisterA(), instruction.getRegisterB()));
            this.writer.writeUshort(this.getReferenceIndex(instruction));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void write(@NonNull Instruction22cs instruction) {
        if (instruction == null) {
            InstructionWriter.$$$reportNull$$$0(29);
        }
        try {
            this.writer.write(this.getOpcodeValue(instruction.getOpcode()));
            this.writer.write(InstructionWriter.packNibbles(instruction.getRegisterA(), instruction.getRegisterB()));
            this.writer.writeUshort(instruction.getFieldOffset());
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void write(@NonNull Instruction22s instruction) {
        if (instruction == null) {
            InstructionWriter.$$$reportNull$$$0(30);
        }
        try {
            this.writer.write(this.getOpcodeValue(instruction.getOpcode()));
            this.writer.write(InstructionWriter.packNibbles(instruction.getRegisterA(), instruction.getRegisterB()));
            this.writer.writeShort(instruction.getNarrowLiteral());
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void write(@NonNull Instruction22t instruction) {
        if (instruction == null) {
            InstructionWriter.$$$reportNull$$$0(31);
        }
        try {
            this.writer.write(this.getOpcodeValue(instruction.getOpcode()));
            this.writer.write(InstructionWriter.packNibbles(instruction.getRegisterA(), instruction.getRegisterB()));
            this.writer.writeShort(instruction.getCodeOffset());
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void write(@NonNull Instruction22x instruction) {
        if (instruction == null) {
            InstructionWriter.$$$reportNull$$$0(32);
        }
        try {
            this.writer.write(this.getOpcodeValue(instruction.getOpcode()));
            this.writer.write(instruction.getRegisterA());
            this.writer.writeUshort(instruction.getRegisterB());
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void write(@NonNull Instruction23x instruction) {
        if (instruction == null) {
            InstructionWriter.$$$reportNull$$$0(33);
        }
        try {
            this.writer.write(this.getOpcodeValue(instruction.getOpcode()));
            this.writer.write(instruction.getRegisterA());
            this.writer.write(instruction.getRegisterB());
            this.writer.write(instruction.getRegisterC());
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void write(@NonNull Instruction30t instruction) {
        if (instruction == null) {
            InstructionWriter.$$$reportNull$$$0(34);
        }
        try {
            this.writer.write(this.getOpcodeValue(instruction.getOpcode()));
            this.writer.write(0);
            this.writer.writeInt(instruction.getCodeOffset());
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void write(@NonNull Instruction31c instruction) {
        if (instruction == null) {
            InstructionWriter.$$$reportNull$$$0(35);
        }
        try {
            this.writer.write(this.getOpcodeValue(instruction.getOpcode()));
            this.writer.write(instruction.getRegisterA());
            this.writer.writeInt(this.getReferenceIndex(instruction));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void write(@NonNull Instruction31i instruction) {
        if (instruction == null) {
            InstructionWriter.$$$reportNull$$$0(36);
        }
        try {
            this.writer.write(this.getOpcodeValue(instruction.getOpcode()));
            this.writer.write(instruction.getRegisterA());
            this.writer.writeInt(instruction.getNarrowLiteral());
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void write(@NonNull Instruction31t instruction) {
        if (instruction == null) {
            InstructionWriter.$$$reportNull$$$0(37);
        }
        try {
            this.writer.write(this.getOpcodeValue(instruction.getOpcode()));
            this.writer.write(instruction.getRegisterA());
            this.writer.writeInt(instruction.getCodeOffset());
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void write(@NonNull Instruction32x instruction) {
        if (instruction == null) {
            InstructionWriter.$$$reportNull$$$0(38);
        }
        try {
            this.writer.write(this.getOpcodeValue(instruction.getOpcode()));
            this.writer.write(0);
            this.writer.writeUshort(instruction.getRegisterA());
            this.writer.writeUshort(instruction.getRegisterB());
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void write(@NonNull Instruction35c instruction) {
        if (instruction == null) {
            InstructionWriter.$$$reportNull$$$0(39);
        }
        try {
            this.writer.write(this.getOpcodeValue(instruction.getOpcode()));
            this.writer.write(InstructionWriter.packNibbles(instruction.getRegisterG(), instruction.getRegisterCount()));
            this.writer.writeUshort(this.getReferenceIndex(instruction));
            this.writer.write(InstructionWriter.packNibbles(instruction.getRegisterC(), instruction.getRegisterD()));
            this.writer.write(InstructionWriter.packNibbles(instruction.getRegisterE(), instruction.getRegisterF()));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void write(@NonNull Instruction35mi instruction) {
        if (instruction == null) {
            InstructionWriter.$$$reportNull$$$0(40);
        }
        try {
            this.writer.write(this.getOpcodeValue(instruction.getOpcode()));
            this.writer.write(InstructionWriter.packNibbles(instruction.getRegisterG(), instruction.getRegisterCount()));
            this.writer.writeUshort(instruction.getInlineIndex());
            this.writer.write(InstructionWriter.packNibbles(instruction.getRegisterC(), instruction.getRegisterD()));
            this.writer.write(InstructionWriter.packNibbles(instruction.getRegisterE(), instruction.getRegisterF()));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void write(@NonNull Instruction35ms instruction) {
        if (instruction == null) {
            InstructionWriter.$$$reportNull$$$0(41);
        }
        try {
            this.writer.write(this.getOpcodeValue(instruction.getOpcode()));
            this.writer.write(InstructionWriter.packNibbles(instruction.getRegisterG(), instruction.getRegisterCount()));
            this.writer.writeUshort(instruction.getVtableIndex());
            this.writer.write(InstructionWriter.packNibbles(instruction.getRegisterC(), instruction.getRegisterD()));
            this.writer.write(InstructionWriter.packNibbles(instruction.getRegisterE(), instruction.getRegisterF()));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void write(@NonNull Instruction3rc instruction) {
        if (instruction == null) {
            InstructionWriter.$$$reportNull$$$0(42);
        }
        try {
            this.writer.write(this.getOpcodeValue(instruction.getOpcode()));
            this.writer.write(instruction.getRegisterCount());
            this.writer.writeUshort(this.getReferenceIndex(instruction));
            this.writer.writeUshort(instruction.getStartRegister());
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void write(@NonNull Instruction3rmi instruction) {
        if (instruction == null) {
            InstructionWriter.$$$reportNull$$$0(43);
        }
        try {
            this.writer.write(this.getOpcodeValue(instruction.getOpcode()));
            this.writer.write(instruction.getRegisterCount());
            this.writer.writeUshort(instruction.getInlineIndex());
            this.writer.writeUshort(instruction.getStartRegister());
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void write(@NonNull Instruction3rms instruction) {
        if (instruction == null) {
            InstructionWriter.$$$reportNull$$$0(44);
        }
        try {
            this.writer.write(this.getOpcodeValue(instruction.getOpcode()));
            this.writer.write(instruction.getRegisterCount());
            this.writer.writeUshort(instruction.getVtableIndex());
            this.writer.writeUshort(instruction.getStartRegister());
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void write(@NonNull Instruction45cc instruction) {
        if (instruction == null) {
            InstructionWriter.$$$reportNull$$$0(45);
        }
        try {
            this.writer.write(this.getOpcodeValue(instruction.getOpcode()));
            this.writer.write(InstructionWriter.packNibbles(instruction.getRegisterG(), instruction.getRegisterCount()));
            this.writer.writeUshort(this.getReferenceIndex(instruction));
            this.writer.write(InstructionWriter.packNibbles(instruction.getRegisterC(), instruction.getRegisterD()));
            this.writer.write(InstructionWriter.packNibbles(instruction.getRegisterE(), instruction.getRegisterF()));
            this.writer.writeUshort(this.getReference2Index(instruction));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void write(@NonNull Instruction4rcc instruction) {
        if (instruction == null) {
            InstructionWriter.$$$reportNull$$$0(46);
        }
        try {
            this.writer.write(this.getOpcodeValue(instruction.getOpcode()));
            this.writer.write(instruction.getRegisterCount());
            this.writer.writeUshort(this.getReferenceIndex(instruction));
            this.writer.writeUshort(instruction.getStartRegister());
            this.writer.writeUshort(this.getReference2Index(instruction));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void write(@NonNull Instruction51l instruction) {
        if (instruction == null) {
            InstructionWriter.$$$reportNull$$$0(47);
        }
        try {
            this.writer.write(this.getOpcodeValue(instruction.getOpcode()));
            this.writer.write(instruction.getRegisterA());
            this.writer.writeLong(instruction.getWideLiteral());
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void write(@NonNull ArrayPayload instruction) {
        if (instruction == null) {
            InstructionWriter.$$$reportNull$$$0(48);
        }
        try {
            this.writer.writeUshort(this.getOpcodeValue(instruction.getOpcode()));
            this.writer.writeUshort(instruction.getElementWidth());
            List<Number> elements = instruction.getArrayElements();
            this.writer.writeInt(elements.size());
            switch (instruction.getElementWidth()) {
                case 1: {
                    for (Number element : elements) {
                        this.writer.write(element.byteValue());
                    }
                    break;
                }
                case 2: {
                    for (Number element : elements) {
                        this.writer.writeShort(element.shortValue());
                    }
                    break;
                }
                case 4: {
                    for (Number element : elements) {
                        this.writer.writeInt(element.intValue());
                    }
                    break;
                }
                case 8: {
                    for (Number element : elements) {
                        this.writer.writeLong(element.longValue());
                    }
                    break;
                }
            }
            if ((this.writer.getPosition() & 1) != 0) {
                this.writer.write(0);
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void write(@NonNull SparseSwitchPayload instruction) {
        if (instruction == null) {
            InstructionWriter.$$$reportNull$$$0(49);
        }
        try {
            this.writer.writeUbyte(0);
            this.writer.writeUbyte(this.getOpcodeValue(instruction.getOpcode()) >> 8);
            ImmutableList<? extends SwitchElement> elements = Ordering.from(this.switchElementComparator).immutableSortedCopy(instruction.getSwitchElements());
            this.writer.writeUshort(elements.size());
            for (SwitchElement switchElement : elements) {
                this.writer.writeInt(switchElement.getKey());
            }
            for (SwitchElement switchElement : elements) {
                this.writer.writeInt(switchElement.getOffset());
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void write(@NonNull PackedSwitchPayload instruction) {
        if (instruction == null) {
            InstructionWriter.$$$reportNull$$$0(50);
        }
        try {
            this.writer.writeUbyte(0);
            this.writer.writeUbyte(this.getOpcodeValue(instruction.getOpcode()) >> 8);
            List<? extends SwitchElement> elements = instruction.getSwitchElements();
            this.writer.writeUshort(elements.size());
            if (elements.size() == 0) {
                this.writer.writeInt(0);
            } else {
                this.writer.writeInt(elements.get(0).getKey());
                for (SwitchElement switchElement : elements) {
                    this.writer.writeInt(switchElement.getOffset());
                }
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static int packNibbles(int a, int b) {
        return b << 4 | a;
    }

    private int getReferenceIndex(ReferenceInstruction referenceInstruction) {
        return this.getReferenceIndex(referenceInstruction.getReferenceType(), referenceInstruction.getReference());
    }

    private int getReference2Index(DualReferenceInstruction referenceInstruction) {
        return this.getReferenceIndex(referenceInstruction.getReferenceType2(), referenceInstruction.getReference2());
    }

    private int getReferenceIndex(int referenceType, Reference reference) {
        switch (referenceType) {
            case 2: {
                return this.fieldSection.getItemIndex((FieldReference)reference);
            }
            case 3: {
                return this.methodSection.getItemIndex((MethodReference)reference);
            }
            case 0: {
                return this.stringSection.getItemIndex((StringReference)reference);
            }
            case 1: {
                return this.typeSection.getItemIndex((TypeReference)reference);
            }
            case 4: {
                return this.protoSection.getItemIndex((MethodProtoReference)reference);
            }
        }
        throw new ExceptionWithContext("Unknown reference type: %d", referenceType);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NonNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NonNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "opcodes";
                break;
            }
            case 1: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "writer";
                break;
            }
            case 2: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringSection";
                break;
            }
            case 3: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeSection";
                break;
            }
            case 4: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldSection";
                break;
            }
            case 5: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodSection";
                break;
            }
            case 6: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "protoSection";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jf/dexlib2/writer/InstructionWriter";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instruction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jf/dexlib2/writer/InstructionWriter";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "makeInstructionWriter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "makeInstructionWriter";
                break;
            }
            case 7: {
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "write";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

