/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.writer;

import android.support.annotation.NonNull;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Ordering;
import java.io.IOException;
import java.util.Collection;
import org.jf.dexlib2.base.BaseAnnotationElement;
import org.jf.dexlib2.iface.AnnotationElement;
import org.jf.dexlib2.iface.reference.FieldReference;
import org.jf.dexlib2.iface.reference.MethodReference;
import org.jf.dexlib2.writer.AnnotationSection;
import org.jf.dexlib2.writer.DexDataWriter;
import org.jf.dexlib2.writer.FieldSection;
import org.jf.dexlib2.writer.MethodSection;
import org.jf.dexlib2.writer.StringSection;
import org.jf.dexlib2.writer.TypeSection;

public abstract class EncodedValueWriter<StringKey, TypeKey, FieldRefKey extends FieldReference, MethodRefKey extends MethodReference, AnnotationElement extends AnnotationElement, EncodedValue> {
    @NonNull
    private final DexDataWriter writer;
    @NonNull
    private final StringSection<StringKey, ?> stringSection;
    @NonNull
    private final TypeSection<?, TypeKey, ?> typeSection;
    @NonNull
    private final FieldSection<?, ?, FieldRefKey, ?> fieldSection;
    @NonNull
    private final MethodSection<?, ?, ?, MethodRefKey, ?> methodSection;
    @NonNull
    private final AnnotationSection<StringKey, TypeKey, ?, AnnotationElement, EncodedValue> annotationSection;

    public EncodedValueWriter(@NonNull DexDataWriter writer, @NonNull StringSection<StringKey, ?> stringSection, @NonNull TypeSection<?, TypeKey, ?> typeSection, @NonNull FieldSection<?, ?, FieldRefKey, ?> fieldSection, @NonNull MethodSection<?, ?, ?, MethodRefKey, ?> methodSection, @NonNull AnnotationSection<StringKey, TypeKey, ?, AnnotationElement, EncodedValue> annotationSection) {
        if (writer == null) {
            EncodedValueWriter.$$$reportNull$$$0(0);
        }
        if (stringSection == null) {
            EncodedValueWriter.$$$reportNull$$$0(1);
        }
        if (typeSection == null) {
            EncodedValueWriter.$$$reportNull$$$0(2);
        }
        if (fieldSection == null) {
            EncodedValueWriter.$$$reportNull$$$0(3);
        }
        if (methodSection == null) {
            EncodedValueWriter.$$$reportNull$$$0(4);
        }
        if (annotationSection == null) {
            EncodedValueWriter.$$$reportNull$$$0(5);
        }
        this.writer = writer;
        this.stringSection = stringSection;
        this.typeSection = typeSection;
        this.fieldSection = fieldSection;
        this.methodSection = methodSection;
        this.annotationSection = annotationSection;
    }

    protected abstract void writeEncodedValue(@NonNull EncodedValue var1) throws IOException;

    public void writeAnnotation(TypeKey annotationType, Collection<? extends AnnotationElement> elements) throws IOException {
        this.writer.writeEncodedValueHeader(29, 0);
        this.writer.writeUleb128(this.typeSection.getItemIndex(annotationType));
        this.writer.writeUleb128(elements.size());
        ImmutableList<AnnotationElement> sortedElements = Ordering.from(BaseAnnotationElement.BY_NAME).immutableSortedCopy(elements);
        for (AnnotationElement element : sortedElements) {
            this.writer.writeUleb128(this.stringSection.getItemIndex(this.annotationSection.getElementName(element)));
            this.writeEncodedValue(this.annotationSection.getElementValue(element));
        }
    }

    public void writeArray(Collection<? extends EncodedValue> elements) throws IOException {
        this.writer.writeEncodedValueHeader(28, 0);
        this.writer.writeUleb128(elements.size());
        for (EncodedValue element : elements) {
            this.writeEncodedValue(element);
        }
    }

    public void writeBoolean(boolean value) throws IOException {
        this.writer.writeEncodedValueHeader(31, value ? 1 : 0);
    }

    public void writeByte(byte value) throws IOException {
        this.writer.writeEncodedInt(0, value);
    }

    public void writeChar(char value) throws IOException {
        this.writer.writeEncodedUint(3, value);
    }

    public void writeDouble(double value) throws IOException {
        this.writer.writeEncodedDouble(17, value);
    }

    public void writeEnum(@NonNull FieldRefKey value) throws IOException {
        if (value == null) {
            EncodedValueWriter.$$$reportNull$$$0(6);
        }
        this.writer.writeEncodedUint(27, this.fieldSection.getItemIndex(value));
    }

    public void writeField(@NonNull FieldRefKey value) throws IOException {
        if (value == null) {
            EncodedValueWriter.$$$reportNull$$$0(7);
        }
        this.writer.writeEncodedUint(25, this.fieldSection.getItemIndex(value));
    }

    public void writeFloat(float value) throws IOException {
        this.writer.writeEncodedFloat(16, value);
    }

    public void writeInt(int value) throws IOException {
        this.writer.writeEncodedInt(4, value);
    }

    public void writeLong(long value) throws IOException {
        this.writer.writeEncodedLong(6, value);
    }

    public void writeMethod(@NonNull MethodRefKey value) throws IOException {
        if (value == null) {
            EncodedValueWriter.$$$reportNull$$$0(8);
        }
        this.writer.writeEncodedUint(26, this.methodSection.getItemIndex(value));
    }

    public void writeNull() throws IOException {
        this.writer.write(30);
    }

    public void writeShort(int value) throws IOException {
        this.writer.writeEncodedInt(2, value);
    }

    public void writeString(@NonNull StringKey value) throws IOException {
        if (value == null) {
            EncodedValueWriter.$$$reportNull$$$0(9);
        }
        this.writer.writeEncodedUint(23, this.stringSection.getItemIndex(value));
    }

    public void writeType(@NonNull TypeKey value) throws IOException {
        if (value == null) {
            EncodedValueWriter.$$$reportNull$$$0(10);
        }
        this.writer.writeEncodedUint(24, this.typeSection.getItemIndex(value));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "writer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringSection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeSection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldSection";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodSection";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationSection";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        objectArray2[1] = "org/jf/dexlib2/writer/EncodedValueWriter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "writeEnum";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "writeField";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "writeMethod";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "writeString";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "writeType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NonNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

