/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.immutable.instruction;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.jf.dexlib2.Format;
import org.jf.dexlib2.Opcode;
import org.jf.dexlib2.iface.instruction.formats.ArrayPayload;
import org.jf.dexlib2.immutable.instruction.ImmutableInstruction;
import org.jf.util.ImmutableUtils;

public class ImmutableArrayPayload
extends ImmutableInstruction
implements ArrayPayload {
    public static final Opcode OPCODE = Opcode.ARRAY_PAYLOAD;
    protected final int elementWidth;
    @NonNull
    protected final ImmutableList<Number> arrayElements;

    public ImmutableArrayPayload(int elementWidth, @Nullable List<Number> arrayElements) {
        super(OPCODE);
        this.elementWidth = elementWidth;
        this.arrayElements = arrayElements == null ? ImmutableList.of() : ImmutableList.copyOf(arrayElements);
    }

    public ImmutableArrayPayload(int elementWidth, @Nullable ImmutableList<Number> arrayElements) {
        super(OPCODE);
        this.elementWidth = elementWidth;
        this.arrayElements = ImmutableUtils.nullToEmptyList(arrayElements);
    }

    @NonNull
    public static ImmutableArrayPayload of(ArrayPayload instruction) {
        if (instruction instanceof ImmutableArrayPayload) {
            ImmutableArrayPayload immutableArrayPayload = (ImmutableArrayPayload)instruction;
            if (immutableArrayPayload == null) {
                ImmutableArrayPayload.$$$reportNull$$$0(0);
            }
            return immutableArrayPayload;
        }
        ImmutableArrayPayload immutableArrayPayload = new ImmutableArrayPayload(instruction.getElementWidth(), instruction.getArrayElements());
        if (immutableArrayPayload == null) {
            ImmutableArrayPayload.$$$reportNull$$$0(1);
        }
        return immutableArrayPayload;
    }

    @Override
    public int getElementWidth() {
        return this.elementWidth;
    }

    @Override
    @NonNull
    public List<Number> getArrayElements() {
        ImmutableList<Number> immutableList = this.arrayElements;
        if (immutableList == null) {
            ImmutableArrayPayload.$$$reportNull$$$0(2);
        }
        return immutableList;
    }

    @Override
    public int getCodeUnits() {
        return 4 + (this.elementWidth * this.arrayElements.size() + 1) / 2;
    }

    @Override
    public Format getFormat() {
        return ImmutableArrayPayload.OPCODE.format;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jf/dexlib2/immutable/instruction/ImmutableArrayPayload";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "of";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getArrayElements";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NonNull method %s.%s must not return null", objectArray));
    }
}

