/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.dexbacked.util;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Iterator;
import org.jf.dexlib2.AccessFlags;
import org.jf.dexlib2.dexbacked.DexBackedDexFile;
import org.jf.dexlib2.dexbacked.DexBackedMethod;
import org.jf.dexlib2.dexbacked.DexBackedMethodImplementation;
import org.jf.dexlib2.dexbacked.DexReader;
import org.jf.dexlib2.dexbacked.util.ParameterIterator;
import org.jf.dexlib2.dexbacked.util.VariableSizeIterator;
import org.jf.dexlib2.dexbacked.util.VariableSizeLookaheadIterator;
import org.jf.dexlib2.iface.debug.DebugItem;
import org.jf.dexlib2.iface.debug.EndLocal;
import org.jf.dexlib2.iface.debug.LocalInfo;
import org.jf.dexlib2.immutable.debug.ImmutableEndLocal;
import org.jf.dexlib2.immutable.debug.ImmutableEpilogueBegin;
import org.jf.dexlib2.immutable.debug.ImmutableLineNumber;
import org.jf.dexlib2.immutable.debug.ImmutablePrologueEnd;
import org.jf.dexlib2.immutable.debug.ImmutableRestartLocal;
import org.jf.dexlib2.immutable.debug.ImmutableSetSourceFile;
import org.jf.dexlib2.immutable.debug.ImmutableStartLocal;

public abstract class DebugInfo
implements Iterable<DebugItem> {
    @NonNull
    public abstract Iterator<String> getParameterNames(@Nullable DexReader var1);

    public abstract int getSize();

    public static DebugInfo newOrEmpty(@NonNull DexBackedDexFile dexFile, int debugInfoOffset, @NonNull DexBackedMethodImplementation methodImpl) {
        if (dexFile == null) {
            DebugInfo.$$$reportNull$$$0(0);
        }
        if (methodImpl == null) {
            DebugInfo.$$$reportNull$$$0(1);
        }
        if (debugInfoOffset == 0) {
            return EmptyDebugInfo.INSTANCE;
        }
        return new DebugInfoImpl(dexFile, debugInfoOffset, methodImpl);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "dexFile";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "methodImpl";
                break;
            }
        }
        objectArray[1] = "org/jf/dexlib2/dexbacked/util/DebugInfo";
        objectArray[2] = "newOrEmpty";
        throw new IllegalArgumentException(String.format("Argument for @NonNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class DebugInfoImpl
    extends DebugInfo {
        @NonNull
        public final DexBackedDexFile dexFile;
        private final int debugInfoOffset;
        @NonNull
        private final DexBackedMethodImplementation methodImpl;
        private static final LocalInfo EMPTY_LOCAL_INFO = new LocalInfo(){

            @Override
            @Nullable
            public String getName() {
                return null;
            }

            @Override
            @Nullable
            public String getType() {
                return null;
            }

            @Override
            @Nullable
            public String getSignature() {
                return null;
            }
        };

        public DebugInfoImpl(@NonNull DexBackedDexFile dexFile, int debugInfoOffset, @NonNull DexBackedMethodImplementation methodImpl) {
            if (dexFile == null) {
                DebugInfoImpl.$$$reportNull$$$0(0);
            }
            if (methodImpl == null) {
                DebugInfoImpl.$$$reportNull$$$0(1);
            }
            this.dexFile = dexFile;
            this.debugInfoOffset = debugInfoOffset;
            this.methodImpl = methodImpl;
        }

        @Override
        @NonNull
        public Iterator<DebugItem> iterator() {
            DexReader reader = this.dexFile.readerAt(this.debugInfoOffset);
            final int lineNumberStart = reader.readBigUleb128();
            int registerCount = this.methodImpl.getRegisterCount();
            Object[] locals = new LocalInfo[registerCount];
            Arrays.fill(locals, EMPTY_LOCAL_INFO);
            DexBackedMethod method = this.methodImpl.method;
            ParameterIterator parameterIterator = new ParameterIterator(method.getParameterTypes(), method.getParameterAnnotations(), this.getParameterNames(reader));
            int parameterIndex = 0;
            if (!AccessFlags.STATIC.isSet(this.methodImpl.method.getAccessFlags())) {
                locals[parameterIndex++] = new LocalInfo(){

                    @Override
                    public String getName() {
                        return "this";
                    }

                    @Override
                    public String getType() {
                        return ((DebugInfoImpl)this).methodImpl.method.getDefiningClass();
                    }

                    @Override
                    public String getSignature() {
                        return null;
                    }
                };
            }
            while (parameterIterator.hasNext()) {
                locals[parameterIndex++] = (LocalInfo)parameterIterator.next();
            }
            if (parameterIndex < registerCount) {
                Object currentLocal;
                String type;
                int localIndex = registerCount - 1;
                while (--parameterIndex > -1 && ((type = (currentLocal = locals[parameterIndex]).getType()) == null || !type.equals("J") && !type.equals("D") || --localIndex != parameterIndex)) {
                    locals[localIndex] = currentLocal;
                    locals[parameterIndex] = EMPTY_LOCAL_INFO;
                    --localIndex;
                }
            }
            VariableSizeLookaheadIterator<DebugItem> variableSizeLookaheadIterator = new VariableSizeLookaheadIterator<DebugItem>(this.dexFile, reader.getOffset(), (LocalInfo[])locals){
                private int codeAddress;
                private int lineNumber;
                final /* synthetic */ LocalInfo[] val$locals;
                {
                    this.val$locals = localInfoArray;
                    super(dexFile, offset);
                    this.codeAddress = 0;
                    this.lineNumber = lineNumberStart;
                }

                @Override
                @Nullable
                protected DebugItem readNextItem(@NonNull DexReader reader) {
                    int next;
                    if (reader == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    block12: while (true) {
                        next = reader.readUbyte();
                        switch (next) {
                            case 0: {
                                return (DebugItem)this.endOfData();
                            }
                            case 1: {
                                int addressDiff = reader.readSmallUleb128();
                                this.codeAddress += addressDiff;
                                continue block12;
                            }
                            case 2: {
                                int lineDiff = reader.readSleb128();
                                this.lineNumber += lineDiff;
                                continue block12;
                            }
                            case 3: {
                                int register = reader.readSmallUleb128();
                                String name = dexFile.getOptionalString(reader.readSmallUleb128() - 1);
                                String type = dexFile.getOptionalType(reader.readSmallUleb128() - 1);
                                ImmutableStartLocal startLocal = new ImmutableStartLocal(this.codeAddress, register, name, type, null);
                                if (register >= 0 && register < this.val$locals.length) {
                                    this.val$locals[register] = startLocal;
                                }
                                return startLocal;
                            }
                            case 4: {
                                int register = reader.readSmallUleb128();
                                String name = dexFile.getOptionalString(reader.readSmallUleb128() - 1);
                                String type = dexFile.getOptionalType(reader.readSmallUleb128() - 1);
                                String signature = dexFile.getOptionalString(reader.readSmallUleb128() - 1);
                                ImmutableStartLocal startLocal = new ImmutableStartLocal(this.codeAddress, register, name, type, signature);
                                if (register >= 0 && register < this.val$locals.length) {
                                    this.val$locals[register] = startLocal;
                                }
                                return startLocal;
                            }
                            case 5: {
                                LocalInfo localInfo;
                                int register = reader.readSmallUleb128();
                                boolean replaceLocalInTable = true;
                                if (register >= 0 && register < this.val$locals.length) {
                                    localInfo = this.val$locals[register];
                                } else {
                                    localInfo = EMPTY_LOCAL_INFO;
                                    replaceLocalInTable = false;
                                }
                                if (localInfo instanceof EndLocal) {
                                    localInfo = EMPTY_LOCAL_INFO;
                                    replaceLocalInTable = false;
                                }
                                ImmutableEndLocal endLocal = new ImmutableEndLocal(this.codeAddress, register, localInfo.getName(), localInfo.getType(), localInfo.getSignature());
                                if (replaceLocalInTable) {
                                    this.val$locals[register] = endLocal;
                                }
                                return endLocal;
                            }
                            case 6: {
                                int register = reader.readSmallUleb128();
                                LocalInfo localInfo = register >= 0 && register < this.val$locals.length ? this.val$locals[register] : EMPTY_LOCAL_INFO;
                                ImmutableRestartLocal restartLocal = new ImmutableRestartLocal(this.codeAddress, register, localInfo.getName(), localInfo.getType(), localInfo.getSignature());
                                if (register >= 0 && register < this.val$locals.length) {
                                    this.val$locals[register] = restartLocal;
                                }
                                return restartLocal;
                            }
                            case 7: {
                                return new ImmutablePrologueEnd(this.codeAddress);
                            }
                            case 8: {
                                return new ImmutableEpilogueBegin(this.codeAddress);
                            }
                            case 9: {
                                String sourceFile = dexFile.getOptionalString(reader.readSmallUleb128() - 1);
                                return new ImmutableSetSourceFile(this.codeAddress, sourceFile);
                            }
                        }
                        break;
                    }
                    int adjusted = next - 10;
                    this.codeAddress += adjusted / 15;
                    this.lineNumber += adjusted % 15 - 4;
                    return new ImmutableLineNumber(this.codeAddress, this.lineNumber);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NonNull parameter '%s' of %s.%s must not be null", "reader", "org/jf/dexlib2/dexbacked/util/DebugInfo$DebugInfoImpl$3", "readNextItem"));
                }
            };
            if (variableSizeLookaheadIterator == null) {
                DebugInfoImpl.$$$reportNull$$$0(2);
            }
            return variableSizeLookaheadIterator;
        }

        @NonNull
        public VariableSizeIterator<String> getParameterNames(@Nullable DexReader reader) {
            if (reader == null) {
                reader = this.dexFile.readerAt(this.debugInfoOffset);
                reader.skipUleb128();
            }
            int parameterNameCount = reader.readSmallUleb128();
            VariableSizeIterator<String> variableSizeIterator = new VariableSizeIterator<String>(reader, parameterNameCount){

                @Override
                protected String readNextItem(@NonNull DexReader reader, int index) {
                    if (reader == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    return dexFile.getOptionalString(reader.readSmallUleb128() - 1);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NonNull parameter '%s' of %s.%s must not be null", "reader", "org/jf/dexlib2/dexbacked/util/DebugInfo$DebugInfoImpl$4", "readNextItem"));
                }
            };
            if (variableSizeIterator == null) {
                DebugInfoImpl.$$$reportNull$$$0(3);
            }
            return variableSizeIterator;
        }

        @Override
        public int getSize() {
            Iterator<DebugItem> iter = this.iterator();
            while (iter.hasNext()) {
                iter.next();
            }
            return ((VariableSizeLookaheadIterator)iter).getReaderOffset() - this.debugInfoOffset;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NonNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NonNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dexFile";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "methodImpl";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jf/dexlib2/dexbacked/util/DebugInfo$DebugInfoImpl";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jf/dexlib2/dexbacked/util/DebugInfo$DebugInfoImpl";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "iterator";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getParameterNames";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class EmptyDebugInfo
    extends DebugInfo {
        public static final EmptyDebugInfo INSTANCE = new EmptyDebugInfo();

        private EmptyDebugInfo() {
        }

        @Override
        @NonNull
        public Iterator<DebugItem> iterator() {
            Iterator iterator = ImmutableSet.of().iterator();
            if (iterator == null) {
                EmptyDebugInfo.$$$reportNull$$$0(0);
            }
            return iterator;
        }

        @Override
        @NonNull
        public Iterator<String> getParameterNames(@Nullable DexReader reader) {
            Iterator iterator = ImmutableSet.of().iterator();
            if (iterator == null) {
                EmptyDebugInfo.$$$reportNull$$$0(1);
            }
            return iterator;
        }

        @Override
        public int getSize() {
            return 0;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "org/jf/dexlib2/dexbacked/util/DebugInfo$EmptyDebugInfo";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "iterator";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getParameterNames";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NonNull method %s.%s must not return null", objectArray));
        }
    }
}

