/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.dexbacked.raw;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.common.base.Joiner;
import org.jf.dexlib2.AccessFlags;
import org.jf.dexlib2.dexbacked.DexBackedDexFile;
import org.jf.dexlib2.dexbacked.raw.MapItem;
import org.jf.dexlib2.dexbacked.raw.RawDexFile;
import org.jf.dexlib2.dexbacked.raw.SectionAnnotator;
import org.jf.dexlib2.dexbacked.raw.StringIdItem;
import org.jf.dexlib2.dexbacked.raw.TypeIdItem;
import org.jf.dexlib2.dexbacked.raw.TypeListItem;
import org.jf.dexlib2.dexbacked.raw.util.DexAnnotator;
import org.jf.dexlib2.util.AnnotatedBytes;

public class ClassDefItem {
    public static final int ITEM_SIZE = 32;
    public static final int CLASS_OFFSET = 0;
    public static final int ACCESS_FLAGS_OFFSET = 4;
    public static final int SUPERCLASS_OFFSET = 8;
    public static final int INTERFACES_OFFSET = 12;
    public static final int SOURCE_FILE_OFFSET = 16;
    public static final int ANNOTATIONS_OFFSET = 20;
    public static final int CLASS_DATA_OFFSET = 24;
    public static final int STATIC_VALUES_OFFSET = 28;

    @NonNull
    public static SectionAnnotator makeAnnotator(@NonNull DexAnnotator annotator, @NonNull MapItem mapItem) {
        if (annotator == null) {
            ClassDefItem.$$$reportNull$$$0(0);
        }
        if (mapItem == null) {
            ClassDefItem.$$$reportNull$$$0(1);
        }
        SectionAnnotator sectionAnnotator = new SectionAnnotator(annotator, mapItem){
            private SectionAnnotator classDataAnnotator = null;

            @Override
            public void annotateSection(@NonNull AnnotatedBytes out) {
                if (out == null) {
                    1.$$$reportNull$$$0(0);
                }
                this.classDataAnnotator = this.annotator.getAnnotator(8192);
                super.annotateSection(out);
            }

            @Override
            @NonNull
            public String getItemName() {
                if ("class_def_item" == null) {
                    1.$$$reportNull$$$0(1);
                }
                return "class_def_item";
            }

            @Override
            protected void annotateItem(@NonNull AnnotatedBytes out, int itemIndex, @Nullable String itemIdentity) {
                if (out == null) {
                    1.$$$reportNull$$$0(2);
                }
                int classIndex = this.dexFile.readSmallUint(out.getCursor());
                out.annotate(4, "class_idx = %s", TypeIdItem.getReferenceAnnotation(this.dexFile, classIndex));
                int accessFlags = this.dexFile.readInt(out.getCursor());
                out.annotate(4, "access_flags = 0x%x: %s", accessFlags, Joiner.on('|').join((Object[])AccessFlags.getAccessFlagsForClass(accessFlags)));
                int superclassIndex = this.dexFile.readOptionalUint(out.getCursor());
                out.annotate(4, "superclass_idx = %s", TypeIdItem.getOptionalReferenceAnnotation(this.dexFile, superclassIndex));
                int interfacesOffset = this.dexFile.readSmallUint(out.getCursor());
                out.annotate(4, "interfaces_off = %s", TypeListItem.getReferenceAnnotation(this.dexFile, interfacesOffset));
                int sourceFileIdx = this.dexFile.readOptionalUint(out.getCursor());
                out.annotate(4, "source_file_idx = %s", StringIdItem.getOptionalReferenceAnnotation(this.dexFile, sourceFileIdx));
                int annotationsOffset = this.dexFile.readSmallUint(out.getCursor());
                if (annotationsOffset == 0) {
                    out.annotate(4, "annotations_off = annotations_directory_item[NO_OFFSET]", new Object[0]);
                } else {
                    out.annotate(4, "annotations_off = annotations_directory_item[0x%x]", annotationsOffset);
                }
                int classDataOffset = this.dexFile.readSmallUint(out.getCursor());
                if (classDataOffset == 0) {
                    out.annotate(4, "class_data_off = class_data_item[NO_OFFSET]", new Object[0]);
                } else {
                    out.annotate(4, "class_data_off = class_data_item[0x%x]", classDataOffset);
                    this.addClassDataIdentity(classDataOffset, this.dexFile.getType(classIndex));
                }
                int staticValuesOffset = this.dexFile.readSmallUint(out.getCursor());
                if (staticValuesOffset == 0) {
                    out.annotate(4, "static_values_off = encoded_array_item[NO_OFFSET]", new Object[0]);
                } else {
                    out.annotate(4, "static_values_off = encoded_array_item[0x%x]", staticValuesOffset);
                }
            }

            private void addClassDataIdentity(int classDataOffset, String classType) {
                if (this.classDataAnnotator != null) {
                    this.classDataAnnotator.setItemIdentity(classDataOffset, classType);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NonNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NonNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "out";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jf/dexlib2/dexbacked/raw/ClassDefItem$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jf/dexlib2/dexbacked/raw/ClassDefItem$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getItemName";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "annotateSection";
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "annotateItem";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        if (sectionAnnotator == null) {
            ClassDefItem.$$$reportNull$$$0(2);
        }
        return sectionAnnotator;
    }

    @NonNull
    public static String asString(@NonNull DexBackedDexFile dexFile, int classIndex) {
        if (dexFile == null) {
            ClassDefItem.$$$reportNull$$$0(3);
        }
        int offset = dexFile.getClassDefItemOffset(classIndex);
        int typeIndex = dexFile.readSmallUint(offset + 0);
        String string = dexFile.getType(typeIndex);
        if (string == null) {
            ClassDefItem.$$$reportNull$$$0(4);
        }
        return string;
    }

    public static String[] getClasses(@NonNull RawDexFile dexFile) {
        MapItem mapItem;
        if (dexFile == null) {
            ClassDefItem.$$$reportNull$$$0(5);
        }
        if ((mapItem = dexFile.getMapItemForSection(6)) == null) {
            return new String[0];
        }
        int classCount = mapItem.getItemCount();
        String[] ret = new String[classCount];
        for (int i = 0; i < classCount; ++i) {
            ret[i] = ClassDefItem.asString(dexFile, i);
        }
        return ret;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NonNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: {
                string = "@NonNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotator";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapItem";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jf/dexlib2/dexbacked/raw/ClassDefItem";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dexFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jf/dexlib2/dexbacked/raw/ClassDefItem";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "makeAnnotator";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "asString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "makeAnnotator";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "asString";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getClasses";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

