/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.dexbacked;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import com.google.common.io.ByteStreams;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.jf.dexlib2.Opcodes;
import org.jf.dexlib2.dexbacked.BaseDexBuffer;
import org.jf.dexlib2.dexbacked.DexBackedDexFile;
import org.jf.dexlib2.iface.MultiDexContainer;
import org.jf.util.AbstractForwardSequentialList;

public class OatFile
extends BaseDexBuffer
implements MultiDexContainer<OatDexFile> {
    private static final byte[] ELF_MAGIC = new byte[]{127, 69, 76, 70};
    private static final byte[] OAT_MAGIC = new byte[]{111, 97, 116, 10};
    private static final int MIN_ELF_HEADER_SIZE = 52;
    private static final int MIN_OAT_VERSION = 56;
    private static final int MAX_OAT_VERSION = 86;
    public static final int UNSUPPORTED = 0;
    public static final int SUPPORTED = 1;
    public static final int UNKNOWN = 2;
    private final boolean is64bit;
    @NonNull
    private final OatHeader oatHeader;
    @NonNull
    private final Opcodes opcodes;
    @Nullable
    private final VdexProvider vdexProvider;

    public OatFile(@NonNull byte[] buf) {
        if (buf == null) {
            OatFile.$$$reportNull$$$0(0);
        }
        this(buf, null);
    }

    public OatFile(@NonNull byte[] buf, @Nullable VdexProvider vdexProvider) {
        if (buf == null) {
            OatFile.$$$reportNull$$$0(1);
        }
        super(buf);
        if (buf.length < 52) {
            throw new NotAnOatFileException();
        }
        OatFile.verifyMagic(buf);
        if (buf[4] == 1) {
            this.is64bit = false;
        } else if (buf[4] == 2) {
            this.is64bit = true;
        } else {
            throw new InvalidOatFileException(String.format("Invalid word-size value: %x", buf[5]));
        }
        OatHeader oatHeader = null;
        SymbolTable symbolTable = this.getSymbolTable();
        for (SymbolTable.Symbol symbol : symbolTable.getSymbols()) {
            if (!symbol.getName().equals("oatdata")) continue;
            oatHeader = new OatHeader(symbol.getFileOffset());
            break;
        }
        if (oatHeader == null) {
            throw new InvalidOatFileException("Oat file has no oatdata symbol");
        }
        this.oatHeader = oatHeader;
        if (!oatHeader.isValid()) {
            throw new InvalidOatFileException("Invalid oat magic value");
        }
        this.opcodes = Opcodes.forArtVersion(oatHeader.getVersion());
        this.vdexProvider = vdexProvider;
    }

    private static void verifyMagic(byte[] buf) {
        for (int i = 0; i < ELF_MAGIC.length; ++i) {
            if (buf[i] == ELF_MAGIC[i]) continue;
            throw new NotAnOatFileException();
        }
    }

    public static OatFile fromInputStream(@NonNull InputStream is) throws IOException {
        if (is == null) {
            OatFile.$$$reportNull$$$0(2);
        }
        return OatFile.fromInputStream(is, null);
    }

    public static OatFile fromInputStream(@NonNull InputStream is, @Nullable VdexProvider vdexProvider) throws IOException {
        if (is == null) {
            OatFile.$$$reportNull$$$0(3);
        }
        if (!is.markSupported()) {
            throw new IllegalArgumentException("InputStream must support mark");
        }
        is.mark(4);
        byte[] partialHeader = new byte[4];
        try {
            ByteStreams.readFully(is, partialHeader);
        }
        catch (EOFException ex) {
            throw new NotAnOatFileException();
        }
        finally {
            is.reset();
        }
        OatFile.verifyMagic(partialHeader);
        is.reset();
        byte[] buf = ByteStreams.toByteArray(is);
        return new OatFile(buf, vdexProvider);
    }

    public int getOatVersion() {
        return this.oatHeader.getVersion();
    }

    public int isSupportedVersion() {
        int version = this.getOatVersion();
        if (version < 56) {
            return 0;
        }
        if (version <= 86) {
            return 1;
        }
        return 2;
    }

    @NonNull
    public List<String> getBootClassPath() {
        if (this.getOatVersion() < 75) {
            ImmutableList<String> immutableList = ImmutableList.of();
            if (immutableList == null) {
                OatFile.$$$reportNull$$$0(4);
            }
            return immutableList;
        }
        String bcp = this.oatHeader.getKeyValue("bootclasspath");
        if (bcp == null) {
            ImmutableList<String> immutableList = ImmutableList.of();
            if (immutableList == null) {
                OatFile.$$$reportNull$$$0(5);
            }
            return immutableList;
        }
        List<String> list = Arrays.asList(bcp.split(":"));
        if (list == null) {
            OatFile.$$$reportNull$$$0(6);
        }
        return list;
    }

    @Override
    @NonNull
    public Opcodes getOpcodes() {
        Opcodes opcodes = this.opcodes;
        if (opcodes == null) {
            OatFile.$$$reportNull$$$0(7);
        }
        return opcodes;
    }

    @NonNull
    public List<OatDexFile> getDexFiles() {
        AbstractForwardSequentialList<OatDexFile> abstractForwardSequentialList = new AbstractForwardSequentialList<OatDexFile>(){

            @Override
            public int size() {
                return OatFile.this.oatHeader.getDexFileCount();
            }

            @Override
            @NonNull
            public Iterator<OatDexFile> iterator() {
                Iterator<OatDexFile> iterator = Iterators.transform(new DexEntryIterator(), new Function<DexEntry, OatDexFile>(){

                    @Override
                    @Nullable
                    public OatDexFile apply(DexEntry dexEntry) {
                        return dexEntry.getDexFile();
                    }
                });
                if (iterator == null) {
                    1.$$$reportNull$$$0(0);
                }
                return iterator;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NonNull method %s.%s must not return null", "org/jf/dexlib2/dexbacked/OatFile$1", "iterator"));
            }
        };
        if (abstractForwardSequentialList == null) {
            OatFile.$$$reportNull$$$0(8);
        }
        return abstractForwardSequentialList;
    }

    @Override
    @NonNull
    public List<String> getDexEntryNames() throws IOException {
        AbstractForwardSequentialList<String> abstractForwardSequentialList = new AbstractForwardSequentialList<String>(){

            @Override
            public int size() {
                return OatFile.this.oatHeader.getDexFileCount();
            }

            @Override
            @NonNull
            public Iterator<String> iterator() {
                Iterator<String> iterator = Iterators.transform(new DexEntryIterator(), new Function<DexEntry, String>(){

                    @Override
                    @Nullable
                    public String apply(DexEntry dexEntry) {
                        return dexEntry.entryName;
                    }
                });
                if (iterator == null) {
                    2.$$$reportNull$$$0(0);
                }
                return iterator;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NonNull method %s.%s must not return null", "org/jf/dexlib2/dexbacked/OatFile$2", "iterator"));
            }
        };
        if (abstractForwardSequentialList == null) {
            OatFile.$$$reportNull$$$0(9);
        }
        return abstractForwardSequentialList;
    }

    @Override
    @Nullable
    public OatDexFile getEntry(@NonNull String entryName) throws IOException {
        if (entryName == null) {
            OatFile.$$$reportNull$$$0(10);
        }
        DexEntryIterator iterator = new DexEntryIterator();
        while (iterator.hasNext()) {
            DexEntry entry = iterator.next();
            if (!entry.entryName.equals(entryName)) continue;
            return entry.getDexFile();
        }
        return null;
    }

    @NonNull
    private List<SectionHeader> getSections() {
        int entryCount;
        int entrySize;
        int offset;
        if (this.is64bit) {
            offset = this.readLongAsSmallUint(40);
            entrySize = this.readUshort(58);
            entryCount = this.readUshort(60);
        } else {
            offset = this.readSmallUint(32);
            entrySize = this.readUshort(46);
            entryCount = this.readUshort(48);
        }
        if (offset + entrySize * entryCount > this.buf.length) {
            throw new InvalidOatFileException("The ELF section headers extend past the end of the file");
        }
        AbstractList<SectionHeader> abstractList = new AbstractList<SectionHeader>(){

            @Override
            public SectionHeader get(int index) {
                if (index < 0 || index >= entryCount) {
                    throw new IndexOutOfBoundsException();
                }
                if (OatFile.this.is64bit) {
                    return new SectionHeader64Bit(offset + index * entrySize);
                }
                return new SectionHeader32Bit(offset + index * entrySize);
            }

            @Override
            public int size() {
                return entryCount;
            }
        };
        if (abstractList == null) {
            OatFile.$$$reportNull$$$0(11);
        }
        return abstractList;
    }

    @NonNull
    private SymbolTable getSymbolTable() {
        for (SectionHeader header : this.getSections()) {
            if (header.getType() != 11) continue;
            SymbolTable symbolTable = new SymbolTable(header);
            if (symbolTable == null) {
                OatFile.$$$reportNull$$$0(12);
            }
            return symbolTable;
        }
        throw new InvalidOatFileException("Oat file has no symbol table");
    }

    @NonNull
    private StringTable getSectionNameStringTable() {
        StringTable stringTable;
        block3: {
            int index = this.readUshort(50);
            if (index == 0) {
                throw new InvalidOatFileException("There is no section name string table");
            }
            try {
                stringTable = new StringTable(this.getSections().get(index));
                if (stringTable != null) break block3;
            }
            catch (IndexOutOfBoundsException ex) {
                throw new InvalidOatFileException("The section index for the section name string table is invalid");
            }
            OatFile.$$$reportNull$$$0(13);
        }
        return stringTable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NonNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                string = "@NonNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buf";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "is";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jf/dexlib2/dexbacked/OatFile";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entryName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jf/dexlib2/dexbacked/OatFile";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getBootClassPath";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getOpcodes";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDexFiles";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getDexEntryNames";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getSections";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getSymbolTable";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getSectionNameStringTable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "fromInputStream";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getEntry";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface VdexProvider {
        @Nullable
        public byte[] getVdex();
    }

    public static class NotAnOatFileException
    extends RuntimeException {
    }

    public static class InvalidOatFileException
    extends RuntimeException {
        public InvalidOatFileException(String message) {
            super(message);
        }
    }

    private class DexEntryIterator
    implements Iterator<DexEntry> {
        int index = 0;
        int offset = OatFile.access$000(OatFile.this).getDexListStart();

        private DexEntryIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.index < OatFile.this.oatHeader.getDexFileCount();
        }

        @Override
        public DexEntry next() {
            byte[] buf;
            int filenameLength = OatFile.this.readSmallUint(this.offset);
            this.offset += 4;
            String filename = new String(OatFile.this.buf, this.offset, filenameLength, Charset.forName("US-ASCII"));
            this.offset += filenameLength;
            this.offset += 4;
            int dexOffset = OatFile.this.readSmallUint(this.offset);
            this.offset += 4;
            if (OatFile.this.getOatVersion() >= 87 && OatFile.this.vdexProvider != null && OatFile.this.vdexProvider.getVdex() != null) {
                buf = OatFile.this.vdexProvider.getVdex();
            } else {
                buf = OatFile.this.buf;
                dexOffset += OatFile.this.oatHeader.headerOffset;
            }
            if (OatFile.this.getOatVersion() >= 75) {
                this.offset += 4;
            }
            if (OatFile.this.getOatVersion() >= 73) {
                this.offset += 4;
            }
            if (OatFile.this.getOatVersion() < 75) {
                int classCount = OatFile.this.readSmallUint(dexOffset + 96);
                this.offset += 4 * classCount;
            }
            ++this.index;
            return new DexEntry(filename, buf, dexOffset);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class DexEntry {
        public final String entryName;
        public final byte[] buf;
        public final int dexOffset;

        public DexEntry(String entryName, byte[] buf, int dexOffset) {
            this.entryName = entryName;
            this.buf = buf;
            this.dexOffset = dexOffset;
        }

        public OatDexFile getDexFile() {
            return new OatDexFile(this.buf, this.dexOffset, this.entryName);
        }
    }

    private class StringTable {
        private final int offset;
        private final int size;

        public StringTable(SectionHeader header) {
            if (header == null) {
                StringTable.$$$reportNull$$$0(0);
            }
            this.offset = header.getOffset();
            this.size = header.getSize();
            if (this.offset + this.size > OatFile.this.buf.length) {
                throw new InvalidOatFileException("String table extends past end of file");
            }
        }

        @NonNull
        public String getString(int index) {
            int start;
            if (index >= this.size) {
                throw new InvalidOatFileException("String index is out of bounds");
            }
            int end = start = this.offset + index;
            while (OatFile.this.buf[end] != 0) {
                if (++end < this.offset + this.size) continue;
                throw new InvalidOatFileException("String extends past end of string table");
            }
            String string = new String(OatFile.this.buf, start, end - start, Charset.forName("US-ASCII"));
            if (string == null) {
                StringTable.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NonNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NonNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "header";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jf/dexlib2/dexbacked/OatFile$StringTable";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jf/dexlib2/dexbacked/OatFile$StringTable";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getString";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    class SymbolTable {
        @NonNull
        private final StringTable stringTable;
        private final int offset;
        private final int entryCount;
        private final int entrySize;

        public SymbolTable(SectionHeader header) {
            if (header == null) {
                SymbolTable.$$$reportNull$$$0(0);
            }
            try {
                this.stringTable = new StringTable((SectionHeader)OatFile.this.getSections().get(header.getLink()));
            }
            catch (IndexOutOfBoundsException ex) {
                throw new InvalidOatFileException("String table section index is invalid");
            }
            this.offset = header.getOffset();
            this.entrySize = header.getEntrySize();
            this.entryCount = header.getSize() / this.entrySize;
            if (this.offset + this.entryCount * this.entrySize > OatFile.this.buf.length) {
                throw new InvalidOatFileException("Symbol table extends past end of file");
            }
        }

        @NonNull
        public List<Symbol> getSymbols() {
            AbstractList<Symbol> abstractList = new AbstractList<Symbol>(){

                @Override
                public Symbol get(int index) {
                    if (index < 0 || index >= SymbolTable.this.entryCount) {
                        throw new IndexOutOfBoundsException();
                    }
                    if (OatFile.this.is64bit) {
                        return new Symbol64(SymbolTable.this.offset + index * SymbolTable.this.entrySize);
                    }
                    return new Symbol32(SymbolTable.this.offset + index * SymbolTable.this.entrySize);
                }

                @Override
                public int size() {
                    return SymbolTable.this.entryCount;
                }
            };
            if (abstractList == null) {
                SymbolTable.$$$reportNull$$$0(1);
            }
            return abstractList;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NonNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NonNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "header";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jf/dexlib2/dexbacked/OatFile$SymbolTable";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jf/dexlib2/dexbacked/OatFile$SymbolTable";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSymbols";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        public class Symbol64
        extends Symbol {
            public Symbol64(int offset) {
                super(offset);
            }

            @Override
            @NonNull
            public String getName() {
                String string = SymbolTable.this.stringTable.getString(OatFile.this.readSmallUint(this.offset));
                if (string == null) {
                    Symbol64.$$$reportNull$$$0(0);
                }
                return string;
            }

            @Override
            public long getValue() {
                return OatFile.this.readLong(this.offset + 8);
            }

            @Override
            public int getSize() {
                return OatFile.this.readLongAsSmallUint(this.offset + 16);
            }

            @Override
            public int getSectionIndex() {
                return OatFile.this.readUshort(this.offset + 6);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NonNull method %s.%s must not return null", "org/jf/dexlib2/dexbacked/OatFile$SymbolTable$Symbol64", "getName"));
            }
        }

        public class Symbol32
        extends Symbol {
            public Symbol32(int offset) {
                super(offset);
            }

            @Override
            @NonNull
            public String getName() {
                String string = SymbolTable.this.stringTable.getString(OatFile.this.readSmallUint(this.offset));
                if (string == null) {
                    Symbol32.$$$reportNull$$$0(0);
                }
                return string;
            }

            @Override
            public long getValue() {
                return OatFile.this.readSmallUint(this.offset + 4);
            }

            @Override
            public int getSize() {
                return OatFile.this.readSmallUint(this.offset + 8);
            }

            @Override
            public int getSectionIndex() {
                return OatFile.this.readUshort(this.offset + 14);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NonNull method %s.%s must not return null", "org/jf/dexlib2/dexbacked/OatFile$SymbolTable$Symbol32", "getName"));
            }
        }

        public abstract class Symbol {
            protected final int offset;

            public Symbol(int offset) {
                this.offset = offset;
            }

            @NonNull
            public abstract String getName();

            public abstract long getValue();

            public abstract int getSize();

            public abstract int getSectionIndex();

            public int getFileOffset() {
                SectionHeader sectionHeader;
                try {
                    sectionHeader = (SectionHeader)OatFile.this.getSections().get(this.getSectionIndex());
                }
                catch (IndexOutOfBoundsException ex) {
                    throw new InvalidOatFileException("Section index for symbol is out of bounds");
                }
                long sectionAddress = sectionHeader.getAddress();
                int sectionOffset = sectionHeader.getOffset();
                int sectionSize = sectionHeader.getSize();
                long symbolAddress = this.getValue();
                if (symbolAddress < sectionAddress || symbolAddress >= sectionAddress + (long)sectionSize) {
                    throw new InvalidOatFileException("symbol address lies outside it's associated section");
                }
                long fileOffset = (long)sectionOffset + (this.getValue() - sectionAddress);
                assert (fileOffset <= Integer.MAX_VALUE);
                return (int)fileOffset;
            }
        }
    }

    private class SectionHeader64Bit
    extends SectionHeader {
        public SectionHeader64Bit(int offset) {
            super(offset);
        }

        @Override
        public long getAddress() {
            return OatFile.this.readLong(this.offset + 16);
        }

        @Override
        public int getOffset() {
            return OatFile.this.readLongAsSmallUint(this.offset + 24);
        }

        @Override
        public int getSize() {
            return OatFile.this.readLongAsSmallUint(this.offset + 32);
        }

        @Override
        public int getLink() {
            return OatFile.this.readSmallUint(this.offset + 40);
        }

        @Override
        public int getEntrySize() {
            return OatFile.this.readLongAsSmallUint(this.offset + 56);
        }
    }

    private class SectionHeader32Bit
    extends SectionHeader {
        public SectionHeader32Bit(int offset) {
            super(offset);
        }

        @Override
        public long getAddress() {
            return (long)OatFile.this.readInt(this.offset + 12) & 0xFFFFFFFFL;
        }

        @Override
        public int getOffset() {
            return OatFile.this.readSmallUint(this.offset + 16);
        }

        @Override
        public int getSize() {
            return OatFile.this.readSmallUint(this.offset + 20);
        }

        @Override
        public int getLink() {
            return OatFile.this.readSmallUint(this.offset + 24);
        }

        @Override
        public int getEntrySize() {
            return OatFile.this.readSmallUint(this.offset + 36);
        }
    }

    private abstract class SectionHeader {
        protected final int offset;
        public static final int TYPE_DYNAMIC_SYMBOL_TABLE = 11;

        public SectionHeader(int offset) {
            this.offset = offset;
        }

        @NonNull
        public String getName() {
            String string = OatFile.this.getSectionNameStringTable().getString(OatFile.this.readSmallUint(this.offset));
            if (string == null) {
                SectionHeader.$$$reportNull$$$0(0);
            }
            return string;
        }

        public int getType() {
            return OatFile.this.readInt(this.offset + 4);
        }

        public abstract long getAddress();

        public abstract int getOffset();

        public abstract int getSize();

        public abstract int getLink();

        public abstract int getEntrySize();

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NonNull method %s.%s must not return null", "org/jf/dexlib2/dexbacked/OatFile$SectionHeader", "getName"));
        }
    }

    private class OatHeader {
        private final int headerOffset;

        public OatHeader(int offset) {
            this.headerOffset = offset;
        }

        public boolean isValid() {
            int i;
            for (i = 0; i < OAT_MAGIC.length; ++i) {
                if (OatFile.this.buf[this.headerOffset + i] == OAT_MAGIC[i]) continue;
                return false;
            }
            for (i = 4; i < 7; ++i) {
                if (OatFile.this.buf[this.headerOffset + i] >= 48 && OatFile.this.buf[this.headerOffset + i] <= 57) continue;
                return false;
            }
            return OatFile.this.buf[this.headerOffset + 7] == 0;
        }

        public int getVersion() {
            return Integer.valueOf(new String(OatFile.this.buf, this.headerOffset + 4, 3));
        }

        public int getDexFileCount() {
            return OatFile.this.readSmallUint(this.headerOffset + 20);
        }

        public int getKeyValueStoreSize() {
            if (this.getVersion() < 56) {
                throw new IllegalStateException("Unsupported oat version");
            }
            int fieldOffset = 68;
            return OatFile.this.readSmallUint(this.headerOffset + fieldOffset);
        }

        public int getHeaderSize() {
            if (this.getVersion() < 56) {
                throw new IllegalStateException("Unsupported oat version");
            }
            return 72 + this.getKeyValueStoreSize();
        }

        @Nullable
        public String getKeyValue(@NonNull String key) {
            int offset;
            if (key == null) {
                OatHeader.$$$reportNull$$$0(0);
            }
            int size = this.getKeyValueStoreSize();
            int endOffset = offset + size;
            for (offset = this.headerOffset + 72; offset < endOffset; ++offset) {
                int keyEndOffset;
                String k;
                int keyStartOffset = offset;
                while (offset < endOffset && OatFile.this.buf[offset] != 0) {
                    ++offset;
                }
                if (offset >= endOffset) {
                    throw new InvalidOatFileException("Oat file contains truncated key value store");
                }
                if (!(k = new String(OatFile.this.buf, keyStartOffset, (keyEndOffset = offset++) - keyStartOffset)).equals(key)) continue;
                int valueStartOffset = offset;
                while (offset < endOffset && OatFile.this.buf[offset] != 0) {
                    ++offset;
                }
                if (offset >= endOffset) {
                    throw new InvalidOatFileException("Oat file contains truncated key value store");
                }
                int valueEndOffset = offset;
                return new String(OatFile.this.buf, valueStartOffset, valueEndOffset - valueStartOffset);
            }
            return null;
        }

        public int getDexListStart() {
            return this.headerOffset + this.getHeaderSize();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NonNull parameter '%s' of %s.%s must not be null", "key", "org/jf/dexlib2/dexbacked/OatFile$OatHeader", "getKeyValue"));
        }
    }

    public class OatDexFile
    extends DexBackedDexFile
    implements MultiDexContainer.MultiDexFile {
        @NonNull
        public final String filename;

        public OatDexFile(byte[] buf, @NonNull int offset, String filename) {
            if (filename == null) {
                OatDexFile.$$$reportNull$$$0(0);
            }
            super(OatFile.this.opcodes, buf, offset);
            this.filename = filename;
        }

        @Override
        @NonNull
        public String getEntryName() {
            String string = this.filename;
            if (string == null) {
                OatDexFile.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NonNull
        public OatFile getContainer() {
            OatFile oatFile = OatFile.this;
            if (oatFile == null) {
                OatDexFile.$$$reportNull$$$0(2);
            }
            return oatFile;
        }

        @Override
        public boolean hasOdexOpcodes() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NonNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NonNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filename";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jf/dexlib2/dexbacked/OatFile$OatDexFile";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jf/dexlib2/dexbacked/OatFile$OatDexFile";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEntryName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getContainer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

