/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.analysis;

import android.support.annotation.NonNull;
import com.google.common.collect.ImmutableList;
import org.jf.dexlib2.analysis.AnalyzedInstruction;
import org.jf.dexlib2.iface.Method;
import org.jf.dexlib2.iface.instruction.InlineIndexInstruction;
import org.jf.dexlib2.iface.instruction.VariableRegisterInstruction;
import org.jf.dexlib2.immutable.ImmutableMethod;
import org.jf.dexlib2.immutable.ImmutableMethodParameter;
import org.jf.dexlib2.immutable.util.ParamUtil;

public abstract class InlineMethodResolver {
    public static final int STATIC = 8;
    public static final int VIRTUAL = 1;
    public static final int DIRECT = 2;

    @NonNull
    public static InlineMethodResolver createInlineMethodResolver(int odexVersion) {
        if (odexVersion == 35) {
            InlineMethodResolver_version35 inlineMethodResolver_version35 = new InlineMethodResolver_version35();
            if (inlineMethodResolver_version35 == null) {
                InlineMethodResolver.$$$reportNull$$$0(0);
            }
            return inlineMethodResolver_version35;
        }
        if (odexVersion == 36) {
            InlineMethodResolver_version36 inlineMethodResolver_version36 = new InlineMethodResolver_version36();
            if (inlineMethodResolver_version36 == null) {
                InlineMethodResolver.$$$reportNull$$$0(1);
            }
            return inlineMethodResolver_version36;
        }
        throw new RuntimeException(String.format("odex version %d is not supported yet", odexVersion));
    }

    protected InlineMethodResolver() {
    }

    @NonNull
    private static Method inlineMethod(int accessFlags, @NonNull String cls, @NonNull String name, @NonNull String params, @NonNull String returnType) {
        if (cls == null) {
            InlineMethodResolver.$$$reportNull$$$0(2);
        }
        if (name == null) {
            InlineMethodResolver.$$$reportNull$$$0(3);
        }
        if (params == null) {
            InlineMethodResolver.$$$reportNull$$$0(4);
        }
        if (returnType == null) {
            InlineMethodResolver.$$$reportNull$$$0(5);
        }
        ImmutableList<ImmutableMethodParameter> paramList = ImmutableList.copyOf(ParamUtil.parseParamString(params));
        ImmutableMethod immutableMethod = new ImmutableMethod(cls, name, paramList, returnType, accessFlags, null, null);
        if (immutableMethod == null) {
            InlineMethodResolver.$$$reportNull$$$0(6);
        }
        return immutableMethod;
    }

    @NonNull
    public abstract Method resolveExecuteInline(@NonNull AnalyzedInstruction var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NonNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NonNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jf/dexlib2/analysis/InlineMethodResolver";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cls";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "returnType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createInlineMethodResolver";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jf/dexlib2/analysis/InlineMethodResolver";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "inlineMethod";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "inlineMethod";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class InlineMethodResolver_version36
    extends InlineMethodResolver {
        private final Method[] inlineMethods;
        private final Method indexOfIMethod = InlineMethodResolver.access$000(1, "Ljava/lang/String;", "indexOf", "I", "I");
        private final Method indexOfIIMethod = InlineMethodResolver.access$000(1, "Ljava/lang/String;", "indexOf", "II", "I");
        private final Method fastIndexOfMethod = InlineMethodResolver.access$000(2, "Ljava/lang/String;", "fastIndexOf", "II", "I");
        private final Method isEmptyMethod = InlineMethodResolver.access$000(1, "Ljava/lang/String;", "isEmpty", "", "Z");

        public InlineMethodResolver_version36() {
            this.inlineMethods = new Method[]{InlineMethodResolver.inlineMethod(8, "Lorg/apache/harmony/dalvik/NativeTestTarget;", "emptyInlineMethod", "", "V"), InlineMethodResolver.inlineMethod(1, "Ljava/lang/String;", "charAt", "I", "C"), InlineMethodResolver.inlineMethod(1, "Ljava/lang/String;", "compareTo", "Ljava/lang/String;", "I"), InlineMethodResolver.inlineMethod(1, "Ljava/lang/String;", "equals", "Ljava/lang/Object;", "Z"), null, null, InlineMethodResolver.inlineMethod(1, "Ljava/lang/String;", "length", "", "I"), InlineMethodResolver.inlineMethod(8, "Ljava/lang/Math;", "abs", "I", "I"), InlineMethodResolver.inlineMethod(8, "Ljava/lang/Math;", "abs", "J", "J"), InlineMethodResolver.inlineMethod(8, "Ljava/lang/Math;", "abs", "F", "F"), InlineMethodResolver.inlineMethod(8, "Ljava/lang/Math;", "abs", "D", "D"), InlineMethodResolver.inlineMethod(8, "Ljava/lang/Math;", "min", "II", "I"), InlineMethodResolver.inlineMethod(8, "Ljava/lang/Math;", "max", "II", "I"), InlineMethodResolver.inlineMethod(8, "Ljava/lang/Math;", "sqrt", "D", "D"), InlineMethodResolver.inlineMethod(8, "Ljava/lang/Math;", "cos", "D", "D"), InlineMethodResolver.inlineMethod(8, "Ljava/lang/Math;", "sin", "D", "D"), InlineMethodResolver.inlineMethod(8, "Ljava/lang/Float;", "floatToIntBits", "F", "I"), InlineMethodResolver.inlineMethod(8, "Ljava/lang/Float;", "floatToRawIntBits", "F", "I"), InlineMethodResolver.inlineMethod(8, "Ljava/lang/Float;", "intBitsToFloat", "I", "F"), InlineMethodResolver.inlineMethod(8, "Ljava/lang/Double;", "doubleToLongBits", "D", "J"), InlineMethodResolver.inlineMethod(8, "Ljava/lang/Double;", "doubleToRawLongBits", "D", "J"), InlineMethodResolver.inlineMethod(8, "Ljava/lang/Double;", "longBitsToDouble", "J", "D"), InlineMethodResolver.inlineMethod(8, "Ljava/lang/StrictMath;", "abs", "I", "I"), InlineMethodResolver.inlineMethod(8, "Ljava/lang/StrictMath;", "abs", "J", "J"), InlineMethodResolver.inlineMethod(8, "Ljava/lang/StrictMath;", "abs", "F", "F"), InlineMethodResolver.inlineMethod(8, "Ljava/lang/StrictMath;", "abs", "D", "D"), InlineMethodResolver.inlineMethod(8, "Ljava/lang/StrictMath;", "min", "II", "I"), InlineMethodResolver.inlineMethod(8, "Ljava/lang/StrictMath;", "max", "II", "I"), InlineMethodResolver.inlineMethod(8, "Ljava/lang/StrictMath;", "sqrt", "D", "D")};
        }

        @Override
        @NonNull
        public Method resolveExecuteInline(@NonNull AnalyzedInstruction analyzedInstruction) {
            InlineIndexInstruction instruction;
            int inlineIndex;
            if (analyzedInstruction == null) {
                InlineMethodResolver_version36.$$$reportNull$$$0(0);
            }
            if ((inlineIndex = (instruction = (InlineIndexInstruction)analyzedInstruction.instruction).getInlineIndex()) < 0 || inlineIndex >= this.inlineMethods.length) {
                throw new RuntimeException("Invalid method index: " + inlineIndex);
            }
            if (inlineIndex == 4) {
                int parameterCount = ((VariableRegisterInstruction)((Object)instruction)).getRegisterCount();
                if (parameterCount == 2) {
                    Method method = this.indexOfIMethod;
                    if (method == null) {
                        InlineMethodResolver_version36.$$$reportNull$$$0(1);
                    }
                    return method;
                }
                if (parameterCount == 3) {
                    Method method = this.fastIndexOfMethod;
                    if (method == null) {
                        InlineMethodResolver_version36.$$$reportNull$$$0(2);
                    }
                    return method;
                }
                throw new RuntimeException("Could not determine the correct inline method to use");
            }
            if (inlineIndex == 5) {
                int parameterCount = ((VariableRegisterInstruction)((Object)instruction)).getRegisterCount();
                if (parameterCount == 3) {
                    Method method = this.indexOfIIMethod;
                    if (method == null) {
                        InlineMethodResolver_version36.$$$reportNull$$$0(3);
                    }
                    return method;
                }
                if (parameterCount == 1) {
                    Method method = this.isEmptyMethod;
                    if (method == null) {
                        InlineMethodResolver_version36.$$$reportNull$$$0(4);
                    }
                    return method;
                }
                throw new RuntimeException("Could not determine the correct inline method to use");
            }
            Method method = this.inlineMethods[inlineIndex];
            if (method == null) {
                InlineMethodResolver_version36.$$$reportNull$$$0(5);
            }
            return method;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NonNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    string = "@NonNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "analyzedInstruction";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jf/dexlib2/analysis/InlineMethodResolver$InlineMethodResolver_version36";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jf/dexlib2/analysis/InlineMethodResolver$InlineMethodResolver_version36";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "resolveExecuteInline";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "resolveExecuteInline";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class InlineMethodResolver_version35
    extends InlineMethodResolver {
        private final Method[] inlineMethods = new Method[]{InlineMethodResolver.access$000(8, "Lorg/apache/harmony/dalvik/NativeTestTarget;", "emptyInlineMethod", "", "V"), InlineMethodResolver.access$000(1, "Ljava/lang/String;", "charAt", "I", "C"), InlineMethodResolver.access$000(1, "Ljava/lang/String;", "compareTo", "Ljava/lang/String;", "I"), InlineMethodResolver.access$000(1, "Ljava/lang/String;", "equals", "Ljava/lang/Object;", "Z"), InlineMethodResolver.access$000(1, "Ljava/lang/String;", "length", "", "I"), InlineMethodResolver.access$000(8, "Ljava/lang/Math;", "abs", "I", "I"), InlineMethodResolver.access$000(8, "Ljava/lang/Math;", "abs", "J", "J"), InlineMethodResolver.access$000(8, "Ljava/lang/Math;", "abs", "F", "F"), InlineMethodResolver.access$000(8, "Ljava/lang/Math;", "abs", "D", "D"), InlineMethodResolver.access$000(8, "Ljava/lang/Math;", "min", "II", "I"), InlineMethodResolver.access$000(8, "Ljava/lang/Math;", "max", "II", "I"), InlineMethodResolver.access$000(8, "Ljava/lang/Math;", "sqrt", "D", "D"), InlineMethodResolver.access$000(8, "Ljava/lang/Math;", "cos", "D", "D"), InlineMethodResolver.access$000(8, "Ljava/lang/Math;", "sin", "D", "D")};

        @Override
        @NonNull
        public Method resolveExecuteInline(@NonNull AnalyzedInstruction analyzedInstruction) {
            InlineIndexInstruction instruction;
            int inlineIndex;
            if (analyzedInstruction == null) {
                InlineMethodResolver_version35.$$$reportNull$$$0(0);
            }
            if ((inlineIndex = (instruction = (InlineIndexInstruction)analyzedInstruction.instruction).getInlineIndex()) < 0 || inlineIndex >= this.inlineMethods.length) {
                throw new RuntimeException("Invalid inline index: " + inlineIndex);
            }
            Method method = this.inlineMethods[inlineIndex];
            if (method == null) {
                InlineMethodResolver_version35.$$$reportNull$$$0(1);
            }
            return method;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NonNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NonNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "analyzedInstruction";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jf/dexlib2/analysis/InlineMethodResolver$InlineMethodResolver_version35";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jf/dexlib2/analysis/InlineMethodResolver$InlineMethodResolver_version35";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "resolveExecuteInline";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "resolveExecuteInline";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

