/*
 * Decompiled with CFR 0.152.
 */
package org.jf.baksmali.Adaptors.Format;

import android.support.annotation.NonNull;
import java.io.IOException;
import org.jf.baksmali.Adaptors.Format.InstructionMethodItem;
import org.jf.baksmali.Adaptors.LabelMethodItem;
import org.jf.baksmali.Adaptors.MethodDefinition;
import org.jf.baksmali.BaksmaliOptions;
import org.jf.dexlib2.Opcode;
import org.jf.dexlib2.iface.instruction.OffsetInstruction;
import org.jf.util.IndentingWriter;

public class OffsetInstructionFormatMethodItem
extends InstructionMethodItem<OffsetInstruction> {
    protected LabelMethodItem label;

    public OffsetInstructionFormatMethodItem(@NonNull BaksmaliOptions options, @NonNull MethodDefinition methodDef, int codeAddress, OffsetInstruction instruction) {
        if (options == null) {
            OffsetInstructionFormatMethodItem.$$$reportNull$$$0(0);
        }
        if (methodDef == null) {
            OffsetInstructionFormatMethodItem.$$$reportNull$$$0(1);
        }
        super(methodDef, codeAddress, instruction);
        this.label = new LabelMethodItem(options, codeAddress + instruction.getCodeOffset(), this.getLabelPrefix());
        this.label = methodDef.getLabelCache().internLabel(this.label);
    }

    @Override
    protected void writeTargetLabel(IndentingWriter writer) throws IOException {
        this.label.writeTo(writer);
    }

    public LabelMethodItem getLabel() {
        return this.label;
    }

    private String getLabelPrefix() {
        Opcode opcode = ((OffsetInstruction)this.instruction).getOpcode();
        switch (opcode.format) {
            case Format10t: 
            case Format20t: 
            case Format30t: {
                return "goto_";
            }
            case Format21t: 
            case Format22t: {
                return "cond_";
            }
            case Format31t: {
                if (opcode == Opcode.FILL_ARRAY_DATA) {
                    return "array_";
                }
                if (opcode == Opcode.PACKED_SWITCH) {
                    return "pswitch_data_";
                }
                return "sswitch_data_";
            }
        }
        assert (false);
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "options";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "methodDef";
                break;
            }
        }
        objectArray[1] = "org/jf/baksmali/Adaptors/Format/OffsetInstructionFormatMethodItem";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NonNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

