/*
 * Decompiled with CFR 0.152.
 */
package bin.zip;

import bin.zip.ZipEntry;
import bin.zip.ZipFile;
import bin.zip.ZipLong;
import bin.zip.ZipShort;
import bin.zip.encoding.ZipEncoding;
import bin.zip.encoding.ZipEncodingHelper;
import bin.zip.extrafield.UnicodeCommentExtraField;
import bin.zip.extrafield.UnicodePathExtraField;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import java.util.zip.ZipException;

public class ZipOutputStream
extends FilterOutputStream {
    public static final int LEVEL_BEST = 9;
    public static final int LEVEL_BETTER = 7;
    public static final int LEVEL_DEFAULT = -1;
    public static final int LEVEL_FASTER = 3;
    public static final int LEVEL_FASTEST = 1;
    private static final int BYTE_MASK = 255;
    private static final int SHORT = 2;
    private static final int WORD = 4;
    public static final int BUFFER_SIZE = 10240;
    private static final int DEFLATER_BLOCK_SIZE = 8192;
    public static final int DEFLATED = 8;
    public static final int DEFAULT_COMPRESSION = -1;
    public static final int STORED = 0;
    static final String DEFAULT_ENCODING = null;
    public static final int UFT8_NAMES_FLAG = 2048;
    public static final int EFS_FLAG = 2048;
    private ZipEntry entry;
    private String comment = "";
    private int level = -1;
    private boolean hasCompressionLevelChanged = false;
    private int method = 8;
    private final List<ZipEntry> entries = new LinkedList<ZipEntry>();
    private final CRC32 crc = new CRC32();
    private long written = 0L;
    private long dataStart = 0L;
    private long localDataStart = 0L;
    private long cdOffset = 0L;
    private long cdLength = 0L;
    private static final byte[] ZERO = new byte[]{0, 0};
    private static final byte[] LZERO = new byte[]{0, 0, 0, 0};
    private final Map<ZipEntry, Long> offsets = new HashMap<ZipEntry, Long>();
    private String encoding = null;
    private ZipEncoding zipEncoding = ZipEncodingHelper.UTF8_ZIP_ENCODING;
    protected Deflater def = new Deflater(this.level, true);
    protected byte[] buf = new byte[512];
    private RandomAccessFile raf = null;
    private boolean useUTF8Flag = true;
    private boolean fallbackToUTF8 = false;
    private UnicodeExtraFieldPolicy createUnicodeExtraFields = UnicodeExtraFieldPolicy.NEVER;
    private boolean currentIsRawEntry;
    protected static final byte[] LFH_SIG = ZipLong.getBytes(67324752L);
    protected static final byte[] DD_SIG = ZipLong.getBytes(134695760L);
    protected static final byte[] CFH_SIG = ZipLong.getBytes(33639248L);
    protected static final byte[] EOCD_SIG = ZipLong.getBytes(101010256L);

    public ZipOutputStream(OutputStream out) {
        super(out);
    }

    public ZipOutputStream(File file) throws IOException {
        super(null);
        try {
            this.raf = new RandomAccessFile(file, "rw");
            this.raf.setLength(0L);
        }
        catch (IOException e) {
            if (this.raf != null) {
                try {
                    this.raf.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.raf = null;
            }
            this.out = new FileOutputStream(file);
        }
    }

    public boolean isSeekable() {
        return this.raf != null;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
        boolean isUTF8 = ZipEncodingHelper.isUTF8(encoding);
        ZipEncoding zipEncoding = this.zipEncoding = isUTF8 ? ZipEncodingHelper.UTF8_ZIP_ENCODING : ZipEncodingHelper.getZipEncoding(encoding);
        if (this.useUTF8Flag && !isUTF8) {
            this.useUTF8Flag = false;
        }
    }

    public void setZipEncoding(ZipEncoding zipEncoding) {
        this.zipEncoding = zipEncoding;
        this.encoding = zipEncoding.getEncoding();
        if (this.useUTF8Flag && !ZipEncodingHelper.isUTF8(this.encoding)) {
            this.useUTF8Flag = false;
        }
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setUseLanguageEncodingFlag(boolean b) {
        this.useUTF8Flag = b && ZipEncodingHelper.isUTF8(this.encoding);
    }

    public void setCreateUnicodeExtraFields(UnicodeExtraFieldPolicy b) {
        this.createUnicodeExtraFields = b;
    }

    public void setFallbackToUTF8(boolean b) {
        this.fallbackToUTF8 = b;
    }

    public void finish() throws IOException {
        this.closeEntry();
        this.cdOffset = this.written;
        for (ZipEntry entry1 : this.entries) {
            this.writeCentralFileHeader(entry1);
        }
        this.cdLength = this.written - this.cdOffset;
        this.writeCentralDirectoryEnd();
        this.offsets.clear();
        this.entries.clear();
        this.def.end();
    }

    public void closeEntry() throws IOException {
        if (this.entry == null) {
            return;
        }
        if (this.currentIsRawEntry) {
            this.crc.reset();
        } else {
            long realCrc = this.crc.getValue();
            this.crc.reset();
            if (this.entry.getMethod() == 8) {
                this.def.finish();
                while (!this.def.finished()) {
                    this.deflate();
                }
                this.entry.setSize(ZipOutputStream.adjustToLong(this.def.getTotalIn()));
                this.entry.setCompressedSize(ZipOutputStream.adjustToLong(this.def.getTotalOut()));
                this.entry.setCrc(realCrc);
                this.def.reset();
                this.written += this.entry.getCompressedSize();
            } else if (this.raf == null) {
                if (this.entry.getCrc() != realCrc) {
                    throw new ZipException("bad CRC checksum for entry " + this.entry.getName() + ": " + Long.toHexString(this.entry.getCrc()) + " instead of " + Long.toHexString(realCrc));
                }
                if (this.entry.getSize() != this.written - this.dataStart) {
                    throw new ZipException("bad size for entry " + this.entry.getName() + ": " + this.entry.getSize() + " instead of " + (this.written - this.dataStart));
                }
            } else {
                long size = this.written - this.dataStart;
                this.entry.setSize(size);
                this.entry.setCompressedSize(size);
                this.entry.setCrc(realCrc);
            }
            if (this.raf != null) {
                long save = this.raf.getFilePointer();
                this.raf.seek(this.localDataStart);
                byte[] data = new byte[12];
                ZipLong.putLong(this.entry.getCrc(), data, 0);
                ZipLong.putLong(this.entry.getCompressedSize(), data, 4);
                ZipLong.putLong(this.entry.getSize(), data, 8);
                this.writeOut(data);
                this.raf.seek(save);
            }
        }
        this.writeDataDescriptor(this.entry);
        this.entry = null;
    }

    public void writeFully(InputStream is) throws IOException {
        int len;
        byte[] b = new byte[10240];
        while ((len = is.read(b)) > 0) {
            this.write(b, 0, len);
        }
    }

    public void copyZipEntry(ZipEntry zipEntry, ZipFile zipFile) throws IOException {
        int len;
        InputStream rawInputStream = zipFile.getRawInputStream(zipEntry);
        this.putNextRawEntry(zipEntry);
        byte[] b = new byte[10240];
        while ((len = rawInputStream.read(b)) > 0) {
            this.writeRaw(b, 0, len);
        }
        this.closeEntry();
    }

    public void putNextEntry(String entryName) throws IOException {
        this.putNextEntry(new ZipEntry(entryName));
    }

    public void putNextEntry(ZipEntry ze) throws IOException {
        this.closeEntry();
        this.entry = ze;
        this.entries.add(this.entry);
        this.currentIsRawEntry = false;
        if (this.entry.getMethod() == -1) {
            this.entry.setMethod(this.method);
        }
        if (this.entry.getTime() == -1L) {
            this.entry.setTime(System.currentTimeMillis());
        }
        if (this.entry.getMethod() == 0 && this.raf == null) {
            if (this.entry.getSize() == -1L) {
                throw new ZipException("uncompressed size is required for STORED method when not writing to a file");
            }
            if (this.entry.getCrc() == -1L) {
                throw new ZipException("crc checksum is required for STORED method when not writing to a file");
            }
            this.entry.setCompressedSize(this.entry.getSize());
        }
        if (this.entry.getMethod() == 8 && this.hasCompressionLevelChanged) {
            this.def.setLevel(this.level);
            this.hasCompressionLevelChanged = false;
        }
        this.writeLocalFileHeader(this.entry);
    }

    public void putNextRawEntry(ZipEntry ze) throws IOException {
        this.closeEntry();
        this.entry = ze;
        this.entries.add(this.entry);
        this.currentIsRawEntry = true;
        if (this.entry.getMethod() == 0 && this.raf == null) {
            if (this.entry.getSize() == -1L) {
                throw new ZipException("uncompressed size is required for STORED method when not writing to a file");
            }
            if (this.entry.getCrc() == -1L) {
                throw new ZipException("crc checksum is required for STORED method when not writing to a file");
            }
            this.entry.setCompressedSize(this.entry.getSize());
        }
        if (this.entry.getMethod() == 8 && this.hasCompressionLevelChanged) {
            this.def.setLevel(this.level);
            this.hasCompressionLevelChanged = false;
        }
        this.writeLocalFileHeader(this.entry);
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setLevel(int level) {
        if (level < -1 || level > 9) {
            throw new IllegalArgumentException("Invalid compression level: " + level);
        }
        this.hasCompressionLevelChanged = this.level != level;
        this.level = level;
    }

    public void setMethod(int method) {
        this.method = method;
    }

    @Override
    public void write(byte[] b, int offset, int length) throws IOException {
        if (this.entry.getMethod() == 8) {
            if (length > 0 && !this.def.finished()) {
                if (length <= 8192) {
                    this.def.setInput(b, offset, length);
                    this.deflateUntilInputIsNeeded();
                } else {
                    int fullblocks = length / 8192;
                    for (int i = 0; i < fullblocks; ++i) {
                        this.def.setInput(b, offset + i * 8192, 8192);
                        this.deflateUntilInputIsNeeded();
                    }
                    int done = fullblocks * 8192;
                    if (done < length) {
                        this.def.setInput(b, offset + done, length - done);
                        this.deflateUntilInputIsNeeded();
                    }
                }
            }
        } else {
            this.writeOut(b, offset, length);
            this.written += (long)length;
        }
        this.crc.update(b, offset, length);
    }

    public void writeRaw(byte[] b, int offset, int length) throws IOException {
        this.writeOut(b, offset, length);
        this.written += (long)length;
    }

    public void writeRaw(byte[] b) throws IOException {
        this.writeRaw(b, 0, b.length);
    }

    @Override
    public void write(int b) throws IOException {
        byte[] buff = new byte[]{(byte)(b & 0xFF)};
        this.write(buff, 0, 1);
    }

    @Override
    public void close() throws IOException {
        this.finish();
        if (this.raf != null) {
            this.raf.close();
        }
        if (this.out != null) {
            this.out.close();
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.out != null) {
            this.out.flush();
        }
    }

    protected final void deflate() throws IOException {
        int len = this.def.deflate(this.buf, 0, this.buf.length);
        if (len > 0) {
            this.writeOut(this.buf, 0, len);
        }
    }

    protected void writeLocalFileHeader(ZipEntry ze) throws IOException {
        long len;
        boolean encodable = this.zipEncoding.canEncode(ze.getName());
        ZipEncoding entryEncoding = !encodable && this.fallbackToUTF8 ? ZipEncodingHelper.UTF8_ZIP_ENCODING : this.zipEncoding;
        ByteBuffer name = entryEncoding.encode(ze.getName());
        if (this.createUnicodeExtraFields != UnicodeExtraFieldPolicy.NEVER) {
            String comm;
            if (this.createUnicodeExtraFields == UnicodeExtraFieldPolicy.ALWAYS || !encodable) {
                ze.addExtraField(new UnicodePathExtraField(ze.getName(), name.array(), name.arrayOffset(), name.limit()));
            }
            if ((comm = ze.getComment()) != null && !"".equals(comm)) {
                boolean commentEncodable = this.zipEncoding.canEncode(comm);
                if (this.createUnicodeExtraFields == UnicodeExtraFieldPolicy.ALWAYS || !commentEncodable) {
                    ByteBuffer commentB = entryEncoding.encode(comm);
                    ze.addExtraField(new UnicodeCommentExtraField(comm, commentB.array(), commentB.arrayOffset(), commentB.limit()));
                }
            }
        }
        this.offsets.put(ze, this.written);
        byte[] data = new byte[30 + name.limit()];
        ZipOutputStream.putBytes(LFH_SIG, data, 0);
        this.written += 4L;
        int zipMethod = ze.getMethod();
        this.writeVersionNeededToExtractAndGeneralPurposeBits(data, 4, zipMethod, !encodable && this.fallbackToUTF8);
        this.written += 4L;
        ZipShort.putShort(zipMethod, data, 8);
        this.written += 2L;
        ZipLong.putLong(ZipOutputStream.toDosTime(ze.getTime()), data, 10);
        this.written += 4L;
        this.localDataStart = this.written;
        if (this.currentIsRawEntry) {
            ZipLong.putLong(ze.getCrc(), data, 14);
            ZipLong.putLong(ze.getCompressedSize(), data, 18);
            ZipLong.putLong(ze.getSize(), data, 22);
        } else if (zipMethod != 8 && this.raf == null) {
            ZipLong.putLong(ze.getCrc(), data, 14);
            ZipLong.putLong(ze.getSize(), data, 18);
            ZipLong.putLong(ze.getSize(), data, 22);
        }
        this.written += 12L;
        ZipShort.putShort(name.limit(), data, 26);
        this.written += 2L;
        byte[] extra = ze.getLocalFileDataExtra();
        if (ze.getMethod() == 0 && (len = this.written + 2L + (long)name.limit() + (long)extra.length) % 4L != 0L) {
            int extraLen = 4 - (int)((this.written + 2L + (long)name.limit()) % 4L);
            extra = new byte[extraLen];
        }
        ZipShort.putShort(extra.length, data, 28);
        this.written += 2L;
        ZipOutputStream.putBytes(name.array(), name.arrayOffset(), name.limit(), data, 30);
        this.written += (long)name.limit();
        this.writeOut(data);
        if (extra.length > 0) {
            this.writeOut(extra);
            this.written += (long)extra.length;
        }
        this.dataStart = this.written;
    }

    private static void putBytes(byte[] value, int start, int length, byte[] buf, int offset) {
        for (int i = 0; i < length; ++i) {
            buf[offset++] = value[start + i];
        }
    }

    private static void putBytes(byte[] value, byte[] buf, int offset) {
        ZipOutputStream.putBytes(value, 0, value.length, buf, offset);
    }

    protected void writeDataDescriptor(ZipEntry ze) throws IOException {
        if (ze.getMethod() != 8 || this.raf != null) {
            return;
        }
        byte[] data = new byte[16];
        ZipOutputStream.putBytes(DD_SIG, data, 0);
        ZipLong.putLong(this.entry.getCrc(), data, 4);
        ZipLong.putLong(this.entry.getCompressedSize(), data, 8);
        ZipLong.putLong(this.entry.getSize(), data, 12);
        this.writeOut(data);
        this.written += 16L;
    }

    protected void writeCentralFileHeader(ZipEntry ze) throws IOException {
        int zipMethod = ze.getMethod();
        boolean encodable = this.zipEncoding.canEncode(ze.getName());
        ZipEncoding entryEncoding = !encodable && this.fallbackToUTF8 ? ZipEncodingHelper.UTF8_ZIP_ENCODING : this.zipEncoding;
        ByteBuffer name = entryEncoding.encode(ze.getName());
        byte[] extra = ze.getCentralDirectoryExtra();
        String comm = ze.getComment();
        if (comm == null) {
            comm = "";
        }
        ByteBuffer commentB = entryEncoding.encode(comm);
        byte[] data = new byte[46 + name.limit() + extra.length + commentB.limit()];
        ZipOutputStream.putBytes(CFH_SIG, data, 0);
        this.written += 4L;
        ZipShort.putShort(ze.getPlatform() << 8 | 0x14, data, 4);
        this.written += 2L;
        this.writeVersionNeededToExtractAndGeneralPurposeBits(data, 6, zipMethod, !encodable && this.fallbackToUTF8);
        this.written += 4L;
        ZipShort.putShort(zipMethod, data, 10);
        this.written += 2L;
        ZipLong.putLong(ZipOutputStream.toDosTime(ze.getTime()), data, 12);
        this.written += 4L;
        ZipLong.putLong(ze.getCrc(), data, 16);
        ZipLong.putLong(ze.getCompressedSize(), data, 20);
        ZipLong.putLong(ze.getSize(), data, 24);
        this.written += 12L;
        ZipShort.putShort(name.limit(), data, 28);
        this.written += 2L;
        ZipShort.putShort(extra.length, data, 30);
        this.written += 2L;
        ZipShort.putShort(commentB.limit(), data, 32);
        this.written += 2L;
        this.written += 2L;
        ZipShort.putShort(ze.getInternalAttributes(), data, 36);
        this.written += 2L;
        ZipLong.putLong(ze.getExternalAttributes(), data, 38);
        this.written += 4L;
        ZipLong.putLong(this.offsets.get(ze), data, 42);
        this.written += 4L;
        ZipOutputStream.putBytes(name.array(), name.arrayOffset(), name.limit(), data, 46);
        this.written += (long)name.limit();
        ZipOutputStream.putBytes(extra, data, 46 + name.limit());
        this.written += (long)extra.length;
        ZipOutputStream.putBytes(commentB.array(), commentB.arrayOffset(), commentB.limit(), data, 46 + name.limit() + extra.length);
        this.written += (long)commentB.limit();
        this.writeOut(data);
    }

    protected void writeCentralDirectoryEnd() throws IOException {
        ByteBuffer data = this.zipEncoding.encode(this.comment);
        byte[] buf = new byte[22 + data.limit()];
        ZipOutputStream.putBytes(EOCD_SIG, buf, 0);
        ZipShort.putShort(this.entries.size(), buf, 8);
        ZipShort.putShort(this.entries.size(), buf, 10);
        ZipLong.putLong(this.cdLength, buf, 12);
        ZipLong.putLong(this.cdOffset, buf, 16);
        ZipShort.putShort(data.limit(), buf, 20);
        ZipOutputStream.putBytes(data.array(), data.arrayOffset(), data.limit(), buf, 22);
        this.writeOut(buf);
    }

    protected static long toDosTime(long t) {
        Date time = new Date(t);
        int year = time.getYear() + 1900;
        if (year < 1980) {
            return 8448L;
        }
        int month = time.getMonth() + 1;
        return year - 1980 << 25 | month << 21 | time.getDate() << 16 | time.getHours() << 11 | time.getMinutes() << 5 | time.getSeconds() >> 1;
    }

    protected final void writeOut(byte[] data) throws IOException {
        this.writeOut(data, 0, data.length);
    }

    protected final void writeOut(byte[] data, int offset, int length) throws IOException {
        if (this.raf != null) {
            this.raf.write(data, offset, length);
        } else {
            this.out.write(data, offset, length);
        }
    }

    protected static long adjustToLong(int i) {
        if (i < 0) {
            return 0x100000000L + (long)i;
        }
        return i;
    }

    private void deflateUntilInputIsNeeded() throws IOException {
        while (!this.def.needsInput()) {
            this.deflate();
        }
    }

    private void writeVersionNeededToExtractAndGeneralPurposeBits(byte[] data, int offset, int zipMethod, boolean utfFallback) throws IOException {
        int generalPurposeFlag;
        int versionNeededToExtract = 10;
        int n = generalPurposeFlag = this.useUTF8Flag || utfFallback ? 2048 : 0;
        if (zipMethod == 8 && this.raf == null) {
            versionNeededToExtract = 20;
            generalPurposeFlag |= 8;
        }
        ZipShort.putShort(versionNeededToExtract, data, offset);
        ZipShort.putShort(generalPurposeFlag, data, offset + 2);
    }

    public static final class UnicodeExtraFieldPolicy {
        public static final UnicodeExtraFieldPolicy ALWAYS = new UnicodeExtraFieldPolicy("always");
        public static final UnicodeExtraFieldPolicy NEVER = new UnicodeExtraFieldPolicy("never");
        public static final UnicodeExtraFieldPolicy NOT_ENCODEABLE = new UnicodeExtraFieldPolicy("not encodeable");
        private final String name;

        private UnicodeExtraFieldPolicy(String n) {
            this.name = n;
        }

        public String toString() {
            return this.name;
        }
    }
}

