/*
 * Decompiled with CFR 0.152.
 */
package bin.zip;

import bin.zip.CopyEntryCallback;
import bin.zip.ExtractCallback;
import bin.zip.ZipCallback;
import bin.zip.ZipEntry;
import bin.zip.ZipFile;
import bin.zip.ZipOutputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;

public class ZipManager {
    public static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yy-MM-dd HH:mm");
    private final File file;
    public final ZipFile zipFile;
    private final ZipEntry[] ze;
    private ZipOutputStream zos;
    public File tmp;

    public long getTotalCompressedSize() {
        long size = 0L;
        for (ZipEntry zipEntry : this.ze) {
            if (zipEntry.isDirectory()) continue;
            size += zipEntry.getCompressedSize();
        }
        return size;
    }

    public long getTotalSize() {
        long size = 0L;
        for (ZipEntry zipEntry : this.ze) {
            if (zipEntry.isDirectory()) continue;
            size += zipEntry.getSize();
        }
        return size;
    }

    public ZipEntry[] getZipEntries() {
        return this.ze;
    }

    public void zip(File file, long size, String entryName, ZipCallback callback) throws IOException {
        int len;
        if (size > 0L) {
            callback.onProgress(0L, size);
        }
        FileInputStream is = new FileInputStream(file);
        ZipEntry zipEntry = new ZipEntry(entryName);
        zipEntry.setTime(file.lastModified());
        this.zos.putNextEntry(zipEntry);
        byte[] bytes = new byte[10240];
        long current = 0L;
        while ((len = ((InputStream)is).read(bytes)) > 0) {
            this.zos.write(bytes, 0, len);
            current += (long)len;
            if (size <= 0L) continue;
            callback.onProgress(current, size);
        }
        ((InputStream)is).close();
        this.zos.closeEntry();
    }

    public HashMap<String, ZipEntry> getZipFileEntryMap() {
        HashMap<String, ZipEntry> map = new HashMap<String, ZipEntry>();
        for (ZipEntry zipEntry : this.ze) {
            if (zipEntry.isDirectory()) continue;
            map.put(zipEntry.getName().toLowerCase(), zipEntry);
        }
        return map;
    }

    public void copyEntries(CopyEntryCallback callback) throws IOException {
        for (int i = 0; i < this.ze.length; ++i) {
            ZipEntry zipEntry = callback.filter(this.ze[i], i + 1, this.ze.length);
            if (zipEntry == null) continue;
            if (zipEntry.isDirectory()) {
                this.zos.putNextEntry(zipEntry);
            } else {
                int len;
                InputStream rawInputStream = this.zipFile.getRawInputStream(zipEntry);
                this.zos.putNextRawEntry(zipEntry);
                long total = zipEntry.getCompressedSize();
                long current = 0L;
                byte[] bytes = new byte[10240];
                while ((len = rawInputStream.read(bytes)) > 0) {
                    this.zos.writeRaw(bytes, 0, len);
                    callback.onProgress(current += (long)len, total);
                }
            }
            this.zos.closeEntry();
            callback.done(zipEntry);
        }
    }

    public void copyOtherZipManagerEntries(ZipManager zipManager, CopyEntryCallback callback) throws IOException {
        for (int i = 0; i < zipManager.ze.length; ++i) {
            ZipEntry zipEntry = callback.filter(zipManager.ze[i], i + 1, zipManager.ze.length);
            if (zipEntry == null) continue;
            if (zipEntry.isDirectory()) {
                this.zos.putNextEntry(zipEntry);
            } else {
                int len;
                InputStream rawInputStream = zipManager.zipFile.getRawInputStream(zipManager.ze[i]);
                this.zos.putNextRawEntry(zipEntry);
                long total = zipEntry.getCompressedSize();
                long current = 0L;
                byte[] bytes = new byte[10240];
                while ((len = rawInputStream.read(bytes)) > 0) {
                    this.zos.writeRaw(bytes, 0, len);
                    callback.onProgress(current += (long)len, total);
                }
            }
            this.zos.closeEntry();
            callback.done(zipEntry);
        }
    }

    public void extractZipEntry(ZipEntry zipEntry, File file) throws IOException {
        int len;
        InputStream is = this.zipFile.getInputStream(zipEntry);
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(file));
        byte[] bytes = new byte[10240];
        while ((len = is.read(bytes)) > 0) {
            os.write(bytes, 0, len);
        }
        is.close();
        os.close();
    }

    public void extract(ExtractCallback callback) throws IOException {
        for (int i = 0; i < this.ze.length; ++i) {
            ZipEntry zipEntry = this.ze[i];
            File file = callback.filter(zipEntry, i + 1, this.ze.length);
            if (file == null) continue;
            if (zipEntry.isDirectory()) {
                if (!file.exists() && !file.mkdirs()) {
                    throw new IOException("mkdir \"" + file.getPath() + "\" failed");
                }
            } else {
                int len;
                InputStream is = this.zipFile.getInputStream(zipEntry);
                BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(file));
                byte[] bytes = new byte[10240];
                long total = zipEntry.getSize();
                long current = 0L;
                while ((len = is.read(bytes)) > 0) {
                    os.write(bytes, 0, len);
                    current += (long)len;
                    if (total <= 0L) continue;
                    callback.onProgress(current, total);
                }
                is.close();
                os.close();
            }
            file.setLastModified(zipEntry.getTime());
            callback.done(zipEntry, file);
        }
    }

    public ZipOutputStream createTempZipOutputStream() throws IOException {
        String s = "";
        do {
            s = s + System.currentTimeMillis() % 1000000L;
            this.tmp = new File(this.file.getParentFile(), s + ".tmp");
        } while (this.tmp.exists());
        this.zos = new ZipOutputStream(this.tmp);
        this.zos.setZipEncoding(this.zipFile.getZipEncoding());
        return this.zos;
    }

    public ZipManager(File file) throws IOException {
        this.file = file;
        this.zipFile = new ZipFile(this.file);
        ArrayList<ZipEntry> al = new ArrayList<ZipEntry>(this.zipFile.getEntrySize());
        Enumeration<ZipEntry> entryEnumeration = this.zipFile.getEntries();
        HashMap<String, ZipEntry> map = new HashMap<String, ZipEntry>();
        block0: while (entryEnumeration.hasMoreElements()) {
            ZipEntry dir;
            String parent;
            ZipEntry z = entryEnumeration.nextElement();
            if (!z.isDirectory()) {
                al.add(z);
            } else {
                if (map.containsKey(z.getName())) continue;
                map.put(z.getName(), z);
            }
            if ((parent = z.getParent()) == null) continue;
            long timeZ = z.getTime();
            if (!map.containsKey(parent)) {
                do {
                    dir = new ZipEntry(parent);
                    dir.setTime(timeZ);
                    map.put(parent, dir);
                } while ((parent = dir.getParent()) != null && !map.containsKey(parent));
                continue;
            }
            while ((dir = (ZipEntry)map.get(parent)).getTime() < timeZ) {
                dir.setTime(timeZ);
                parent = dir.getParent();
                if (parent != null) continue;
                continue block0;
            }
        }
        al.addAll(map.values());
        map.clear();
        Collections.sort(al, new Comparator<ZipEntry>(){

            @Override
            public int compare(ZipEntry o1, ZipEntry o2) {
                return o1.getName().compareToIgnoreCase(o2.getName());
            }
        });
        this.ze = new ZipEntry[al.size()];
        al.toArray(this.ze);
        al.clear();
    }

    public static String getEntryTime(ZipEntry zipEntry) {
        return DATE_FORMAT.format(zipEntry.getLastModifiedDate());
    }

    public int getEntrySize() {
        return this.ze.length;
    }

    public void close() throws IOException {
        this.zipFile.close();
    }

    public ArrayList<ZipEntry> list(String path) {
        String p = path == null || path.length() <= 1 ? null : (path.charAt(path.length() - 1) != '/' ? path + "/" : path);
        ArrayList<ZipEntry> l = new ArrayList<ZipEntry>(this.ze.length);
        for (ZipEntry zipEntry : this.ze) {
            String parent = zipEntry.getParent();
            if (parent == null) {
                if (p != null) continue;
                l.add(zipEntry);
                continue;
            }
            if (!parent.equals(p)) continue;
            l.add(zipEntry);
        }
        l.trimToSize();
        return l;
    }
}

