/*
 * Decompiled with CFR 0.152.
 */
package bin.zip;

import bin.zip.ZipShort;
import bin.zip.extrafield.CentralDirectoryParsingZipExtraField;
import bin.zip.extrafield.ExtraFieldUtils;
import bin.zip.extrafield.UnparseableExtraFieldData;
import bin.zip.extrafield.ZipExtraField;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.NoSuchElementException;
import java.util.zip.ZipException;

public class ZipEntry
extends java.util.zip.ZipEntry
implements Cloneable {
    public static final int PLATFORM_UNIX = 3;
    public static final int PLATFORM_FAT = 0;
    private static final int SHORT_MASK = 65535;
    private static final int SHORT_SHIFT = 16;
    private int internalAttributes = 0;
    private int platform = 0;
    private long externalAttributes = 0L;
    private LinkedHashMap<ZipShort, ZipExtraField> extraFields = null;
    private UnparseableExtraFieldData unparseableExtra = null;
    private String name = null;
    private String parent = null;
    private String simpleName = null;
    private int hash = 0;

    public ZipEntry(String name) {
        super(name);
        this.setName(name);
    }

    public ZipEntry(java.util.zip.ZipEntry entry) throws ZipException {
        super(entry);
        this.setName(entry.getName());
        byte[] extra = entry.getExtra();
        if (extra != null) {
            this.setExtraFields(ExtraFieldUtils.parse(extra, true, ExtraFieldUtils.UnparseableExtraField.READ));
        } else {
            this.setExtra();
        }
    }

    public ZipEntry(ZipEntry entry) throws ZipException {
        this((java.util.zip.ZipEntry)entry);
        this.setInternalAttributes(entry.getInternalAttributes());
        this.setExternalAttributes(entry.getExternalAttributes());
        this.setExtraFields(entry.getExtraFields(true));
    }

    protected ZipEntry() {
        super("");
    }

    @Override
    public Object clone() {
        ZipEntry e = (ZipEntry)super.clone();
        e.setInternalAttributes(this.getInternalAttributes());
        e.setExternalAttributes(this.getExternalAttributes());
        e.setExtraFields(this.getExtraFields(true));
        return e;
    }

    public int getInternalAttributes() {
        return this.internalAttributes;
    }

    public void setInternalAttributes(int value) {
        this.internalAttributes = value;
    }

    public long getExternalAttributes() {
        return this.externalAttributes;
    }

    public void setExternalAttributes(long value) {
        this.externalAttributes = value;
    }

    public void setUnixMode(int mode) {
        this.setExternalAttributes(mode << 16 | ((mode & 0x80) == 0 ? 1 : 0) | (this.isDirectory() ? 16 : 0));
        this.platform = 3;
    }

    public int getUnixMode() {
        return this.platform != 3 ? 0 : (int)(this.getExternalAttributes() >> 16 & 0xFFFFL);
    }

    public int getPlatform() {
        return this.platform;
    }

    protected void setPlatform(int platform) {
        this.platform = platform;
    }

    public void setExtraFields(ZipExtraField[] fields) {
        this.extraFields = new LinkedHashMap();
        for (ZipExtraField field : fields) {
            if (field instanceof UnparseableExtraFieldData) {
                this.unparseableExtra = (UnparseableExtraFieldData)field;
                continue;
            }
            this.extraFields.put(field.getHeaderId(), field);
        }
        this.setExtra();
    }

    public ZipExtraField[] getExtraFields() {
        return this.getExtraFields(false);
    }

    public ZipExtraField[] getExtraFields(boolean includeUnparseable) {
        if (this.extraFields == null) {
            ZipExtraField[] zipExtraFieldArray;
            if (!includeUnparseable || this.unparseableExtra == null) {
                zipExtraFieldArray = new ZipExtraField[]{};
            } else {
                ZipExtraField[] zipExtraFieldArray2 = new ZipExtraField[1];
                zipExtraFieldArray = zipExtraFieldArray2;
                zipExtraFieldArray2[0] = this.unparseableExtra;
            }
            return zipExtraFieldArray;
        }
        ArrayList<ZipExtraField> result = new ArrayList<ZipExtraField>(this.extraFields.values());
        if (includeUnparseable && this.unparseableExtra != null) {
            result.add(this.unparseableExtra);
        }
        return result.toArray(new ZipExtraField[0]);
    }

    public void addExtraField(ZipExtraField ze) {
        if (ze instanceof UnparseableExtraFieldData) {
            this.unparseableExtra = (UnparseableExtraFieldData)ze;
        } else {
            if (this.extraFields == null) {
                this.extraFields = new LinkedHashMap();
            }
            this.extraFields.put(ze.getHeaderId(), ze);
        }
        this.setExtra();
    }

    public void addAsFirstExtraField(ZipExtraField ze) {
        if (ze instanceof UnparseableExtraFieldData) {
            this.unparseableExtra = (UnparseableExtraFieldData)ze;
        } else {
            LinkedHashMap<ZipShort, ZipExtraField> copy = this.extraFields;
            this.extraFields = new LinkedHashMap();
            this.extraFields.put(ze.getHeaderId(), ze);
            if (copy != null) {
                copy.remove(ze.getHeaderId());
                this.extraFields.putAll(copy);
            }
        }
        this.setExtra();
    }

    public void removeExtraField(ZipShort type) {
        if (this.extraFields == null) {
            throw new NoSuchElementException();
        }
        if (this.extraFields.remove(type) == null) {
            throw new NoSuchElementException();
        }
        this.setExtra();
    }

    public void removeUnparseableExtraFieldData() {
        if (this.unparseableExtra == null) {
            throw new NoSuchElementException();
        }
        this.unparseableExtra = null;
        this.setExtra();
    }

    public ZipExtraField getExtraField(ZipShort type) {
        if (this.extraFields != null) {
            return this.extraFields.get(type);
        }
        return null;
    }

    public UnparseableExtraFieldData getUnparseableExtraFieldData() {
        return this.unparseableExtra;
    }

    @Override
    public void setExtra(byte[] extra) throws RuntimeException {
        try {
            ZipExtraField[] local = ExtraFieldUtils.parse(extra, true, ExtraFieldUtils.UnparseableExtraField.READ);
            this.mergeExtraFields(local, true);
        }
        catch (Exception e) {
            throw new RuntimeException("Error parsing extra fields for entry: " + this.getName() + " - " + e.getMessage(), e);
        }
    }

    protected void setExtra() {
        super.setExtra(ExtraFieldUtils.mergeLocalFileDataData(this.getExtraFields(true)));
    }

    public void setCentralDirectoryExtra(byte[] b) {
        try {
            ZipExtraField[] central = ExtraFieldUtils.parse(b, false, ExtraFieldUtils.UnparseableExtraField.READ);
            this.mergeExtraFields(central, false);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public byte[] getLocalFileDataExtra() {
        byte[] extra = this.getExtra();
        return extra != null ? extra : new byte[]{};
    }

    public Date getLastModifiedDate() {
        return new Date(this.getTime());
    }

    public byte[] getCentralDirectoryExtra() {
        return ExtraFieldUtils.mergeCentralDirectoryData(this.getExtraFields(true));
    }

    public void setComprSize(long size) {
        this.setCompressedSize(size);
    }

    @Override
    public String getName() {
        return this.name == null ? super.getName() : this.name;
    }

    public String getParent() {
        return this.parent;
    }

    public String getSimpleName() {
        return this.simpleName;
    }

    @Override
    public boolean isDirectory() {
        return this.getName().endsWith("/");
    }

    public void setName(String name) {
        if (name != null && this.getPlatform() == 0 && !name.contains("/")) {
            name = name.replace('\\', '/');
        }
        this.name = name;
        this.setParentAndSimpleName();
    }

    private void setParentAndSimpleName() {
        if (this.name == null || this.name.length() == 0) {
            return;
        }
        if (this.name.charAt(this.name.length() - 1) == '/') {
            int index = this.name.lastIndexOf(47, this.name.length() - 2);
            if (index == -1) {
                this.simpleName = this.name.substring(0, this.name.length() - 1);
                this.parent = null;
            } else {
                this.simpleName = this.name.substring(index + 1, this.name.length() - 1);
                this.parent = this.name.substring(0, index + 1);
            }
        } else {
            int index = this.name.lastIndexOf(47);
            if (index == -1) {
                this.simpleName = this.name;
                this.parent = null;
            } else {
                this.simpleName = this.name.substring(index + 1);
                this.parent = this.name.substring(0, index + 1);
            }
        }
    }

    @Override
    public int hashCode() {
        int h = this.hash;
        if (h == 0) {
            this.hash = h = this.getName().hashCode();
        }
        return h;
    }

    public boolean equals(Object obj) {
        return this == obj;
    }

    private void mergeExtraFields(ZipExtraField[] f, boolean local) throws ZipException {
        if (this.extraFields == null) {
            this.setExtraFields(f);
        } else {
            for (ZipExtraField aF : f) {
                byte[] b;
                ZipExtraField existing = aF instanceof UnparseableExtraFieldData ? this.unparseableExtra : this.getExtraField(aF.getHeaderId());
                if (existing == null) {
                    this.addExtraField(aF);
                    continue;
                }
                if (local || !(existing instanceof CentralDirectoryParsingZipExtraField)) {
                    b = aF.getLocalFileDataData();
                    existing.parseFromLocalFileData(b, 0, b.length);
                    continue;
                }
                b = aF.getCentralDirectoryData();
                ((CentralDirectoryParsingZipExtraField)existing).parseFromCentralDirectoryData(b, 0, b.length);
            }
            this.setExtra();
        }
    }
}

