/*
 * Decompiled with CFR 0.152.
 */
package com.zhh.jiagu;

import com.zhh.jiagu.shell.entity.KeyStore;
import com.zhh.jiagu.shell.util.FileUtils;
import com.zhh.jiagu.shell.util.KeyStoreUtil;
import com.zhh.jiagu.shell.util.ProcessUtil;
import com.zhh.jiagu.shell.util.Zip4jUtil;
import com.zhh.jiagu.shell.util.ZipUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Locale;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.zip.Adler32;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.model.FileHeader;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JiaGuMain {
    private static String ROOT = "";
    private static String OUT_TMP = ROOT + "temp/";
    private static String ORIGIN_APK = "demo/release/demo-release.apk";
    private static String KEYSTORE_CFG = "keystore.cfg";
    private static final boolean isRelease = true;

    public static void main(String[] args) {
        if (args == null || args.length != 3) {
            System.out.println("\u8bf7\u4f7f\u7528\uff1ajava -jar jiaguLib.jar [apk\u6587\u4ef6] [\u7b7e\u540d\u914d\u7f6e\u6587\u4ef6] [\u8def\u5f84]");
            return;
        }
        String arg = args[0];
        KEYSTORE_CFG = args[1];
        OUT_TMP = OUT_TMP + args[2] + "/";
        File file = new File(arg);
        if (file.exists() && arg.endsWith(".apk")) {
            if (new File(KEYSTORE_CFG).exists()) {
                ORIGIN_APK = arg;
                JiaGuMain jiagu = new JiaGuMain();
                jiagu.beginJiaGu();
            } else {
                System.out.println("\u7b7e\u540d\u914d\u7f6e\u6587\u4ef6\u4e0d\u5b58\u5728!");
            }
        } else {
            System.out.println(arg + " is invalid apk path.");
        }
    }

    public void beginJiaGu() {
        try {
            FileUtils.deleteFile(OUT_TMP);
            File shellDexFile = this.shellAar2Dex();
            File dexZipFile = this.apkUnzipAndZipDexFiles();
            if (dexZipFile == null) {
                return;
            }
            File dexFile = this.combine2NewDexFile(shellDexFile, dexZipFile);
            String outpath = this.modifyOriginApkManifest();
            if (dexFile != null && !outpath.isEmpty()) {
                boolean bl = this.replaceDexFiles(outpath, dexFile.getPath());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private File shellAar2Dex() throws Exception {
        this.logTitle("\u6b65\u9aa4\u4e00\uff1a\u5c06\u52a0\u56fa\u58f3\u4e2d\u7684aar\u4e2d\u7684jar\u8f6c\u6210dex\u6587\u4ef6");
        File aarFile = new File(ROOT + "aar/jiagu_shell-release.aar");
        File aarTemp = new File(OUT_TMP + "shell");
        ZipUtil.unZip(aarFile, aarTemp);
        File classesJar = new File(aarTemp, "classes.jar");
        File classesDex = new File(aarTemp, "classes.dex");
        ProcessUtil.doShell("./dxtool/dx", "--dex", "--output", classesDex.getPath(), classesJar.getPath());
        System.out.println("\u5df2\u751f\u6210======" + classesDex.getPath());
        return classesDex;
    }

    private File apkUnzipAndZipDexFiles() {
        this.logTitle("\u6b65\u9aa4\u4e8c\uff1a\u5c06\u9700\u8981\u52a0\u56fa\u7684APK\u89e3\u538b\uff0c\u5e76\u5c06\u6240\u6709dex\u6587\u4ef6\u6253\u5305\u6210\u4e00\u4e2azip\u5305\uff0c\u65b9\u4fbf\u540e\u7eed\u8fdb\u884c\u52a0\u5bc6\u5904\u7406");
        File apkFile = new File(ORIGIN_APK);
        File apkTemp = new File(OUT_TMP + "unzip/");
        try {
            ZipUtil.unZip(apkFile, apkTemp);
            File[] dexFiles = apkTemp.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File file, String s) {
                    return s.endsWith(".dex");
                }
            });
            if (dexFiles == null) {
                return null;
            }
            File outTmpFile = new File(OUT_TMP);
            File outputFile = new File(outTmpFile, "AppDex.zip");
            if (!outTmpFile.exists()) {
                outTmpFile.mkdirs();
            }
            if (outputFile.exists()) {
                outputFile.delete();
            }
            Zip4jUtil.zipFiles(dexFiles, outputFile);
            System.out.println("\u5df2\u751f\u6210======" + outputFile.getPath());
            FileUtils.deleteFile(apkTemp.getPath());
            return outputFile;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private File combine2NewDexFile(File shellDexFile, File originalDexZipFile) {
        this.logTitle("\u6b65\u9aa4\u4e09\uff1a\u5bf9\u6b65\u9aa4\u4e8c\u7684zip\u5305\u8fdb\u884c\u52a0\u5bc6\uff0c\u5e76\u4e0e\u58f3dex\u5408\u6210\u65b0dex\u6587\u4ef6");
        try {
            byte[] data = this.readFileBytes(originalDexZipFile);
            System.out.println("\u52a0\u5bc6\u524d\u6570\u636e\u5927\u5c0f\u4e3a\uff1a" + data.length);
            byte[] payloadArray = data;
            byte[] unShellDexArray = this.readFileBytes(shellDexFile);
            int payloadLen = payloadArray.length;
            int unShellDexLen = unShellDexArray.length;
            int totalLen = payloadLen + unShellDexLen + 4;
            byte[] newdex = new byte[totalLen];
            System.arraycopy(unShellDexArray, 0, newdex, 0, unShellDexLen);
            System.arraycopy(payloadArray, 0, newdex, unShellDexLen, payloadLen);
            System.arraycopy(this.intToByte(payloadLen), 0, newdex, totalLen - 4, 4);
            this.fixFileSizeHeader(newdex);
            this.fixSHA1Header(newdex);
            this.fixCheckSumHeader(newdex);
            String str = OUT_TMP + "classes.dex";
            File file = new File(str);
            if (!file.exists()) {
                file.createNewFile();
            }
            FileOutputStream localFileOutputStream = new FileOutputStream(str);
            localFileOutputStream.write(newdex);
            localFileOutputStream.flush();
            localFileOutputStream.close();
            System.out.println("\u5df2\u751f\u6210\u65b0\u7684Dex\u6587\u4ef6======" + str);
            FileUtils.deleteFile(originalDexZipFile.getAbsolutePath());
            return file;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private String modifyOriginApkManifest() throws Exception {
        String apkPath = ORIGIN_APK;
        String outputPath = OUT_TMP + "apk/";
        this.logTitle("\u6b65\u9aa4\u56db\uff1a\u4fee\u6539AndroidManifest\uff08Application\u7684android:name\u5c5e\u6027\u548c\u65b0\u589e<meta-data>\uff09");
        String path = "";
        long start = System.currentTimeMillis();
        System.out.println("\u5f00\u59cb\u53cd\u7f16\u8bd1\u539fapk ......");
        ProcessUtil.doShell("java", "-jar", "apktool/apktool.jar", "d", "-o", outputPath, apkPath, "-p", "jiaguData", "--only-main-classes");
        this.modifyAndroidManifest(new File(outputPath, "AndroidManifest.xml"));
        System.out.println("\u5f00\u59cb\u56de\u7f16\u8bd1apk ......");
        String apk = OUT_TMP + apkPath.substring(apkPath.lastIndexOf("/") + 1);
        ProcessUtil.doShell("java", "-jar", "apktool/apktool.jar", "b", "-o", apk, outputPath, "-p", "jiaguData");
        path = apk;
        System.out.println("=== modifyOriginApkManifest ==== " + (System.currentTimeMillis() - start) + "ms");
        FileUtils.deleteFile(outputPath);
        return path;
    }

    private String modifyOriginApkManifest2() throws Exception {
        String apkPath = ORIGIN_APK;
        this.logTitle("\u6b65\u9aa4\u56db\uff1a\u4fee\u6539AndroidManifest\uff08Application\u7684android:name\u5c5e\u6027\u548c\u65b0\u589e<meta-data>\uff09");
        String outApk = "";
        long start = System.currentTimeMillis();
        File outAmFile = new File(OUT_TMP, "am.txt");
        ProcessUtil.executeCommand("aapt dump xmltree " + apkPath + " AndroidManifest.xml >" + outAmFile.getPath());
        String clazzName = FileUtils.getAppApplicationName(outAmFile);
        System.out.println("application-name ->" + clazzName);
        FileUtils.deleteFile(outAmFile.getPath());
        Zip4jUtil.extractFile(apkPath, "AndroidManifest.xml", OUT_TMP);
        File manifestFile = new File(OUT_TMP, "AndroidManifest.xml");
        if (manifestFile.exists()) {
            String shellClazzName = "com.zhh.jiagu.shell.StubApplication";
            String cmd = String.format(Locale.CHINESE, "java -jar %slibs/AXMLEditor.jar -attr -r application package name %s %s", ROOT, manifestFile.getPath(), manifestFile.getPath());
            ProcessUtil.executeCommand(cmd);
            cmd = String.format(Locale.CHINESE, "java -jar %slibs/AXMLEditor.jar -attr -m application package name %s %s %s", ROOT, shellClazzName, manifestFile.getPath(), manifestFile.getPath());
            ProcessUtil.executeCommand(cmd);
            String metaXml = OUT_TMP + "meta.xml";
            clazzName = clazzName == null || clazzName.length() <= 0 ? "android.app.Application" : clazzName;
            FileUtils.writeFile("<meta-data android:name=\"APPLICATION_CLASS_NAME\" android:value=\"" + clazzName + "\"/>", metaXml);
            cmd = String.format(Locale.CHINESE, "java -jar %slibs/AXMLEditor.jar -tag -i %s %s %s", ROOT, metaXml, manifestFile.getPath(), manifestFile.getPath());
            ProcessUtil.executeCommand(cmd);
            FileUtils.deleteFile(metaXml);
            outApk = OUT_TMP + apkPath.substring(apkPath.lastIndexOf("/") + 1);
            Files.copy(new File(ORIGIN_APK).toPath(), new File(outApk).toPath(), StandardCopyOption.REPLACE_EXISTING);
            ProcessUtil.executeCommand("aapt r " + outApk + " AndroidManifest.xml");
            Zip4jUtil.addFile2Zip(outApk, manifestFile.getPath(), "");
            FileUtils.deleteFile(manifestFile.getPath());
            System.out.println("=== modifyOriginApkManifest2 ==== " + (System.currentTimeMillis() - start) + "ms");
        }
        return outApk;
    }

    private boolean replaceDexFiles(String zipPath, String newDexPath) {
        this.logTitle("\u6b65\u9aa4\u4e94\uff1a\u5220\u9664\u539fAPK\u4e2d\u7684DEX\u6587\u4ef6\uff0c\u5e76\u653e\u5165\u53efAPK\u7684dex\u6587\u4ef6");
        try {
            Zip4jUtil.deleteDexFromZip(zipPath);
            Zip4jUtil.addFile2Zip(zipPath, newDexPath, "");
            FileUtils.deleteFile(OUT_TMP + "shell");
            FileUtils.deleteFile(newDexPath);
            System.out.println("\u5df2\u5b8c\u6210\u66ff\u6362\u52a0\u5bc6\u540e\u7684Dex\u6587\u4ef6======");
            return true;
        }
        catch (ZipException e) {
            e.printStackTrace();
            return false;
        }
    }

    private boolean matchCpuArm(Stream<FileHeader> stream, final String cpuArm) {
        boolean match = stream.anyMatch(new Predicate<FileHeader>(){

            @Override
            public boolean test(FileHeader fileHeader) {
                return fileHeader.getFileName().contains(cpuArm);
            }
        });
        stream.close();
        return match;
    }

    private File zipalignApk(File unAlignedApk) throws Exception {
        this.logTitle("\u6b65\u9aa4\u516d\uff1a\u91cd\u65b0\u5bf9APK\u8fdb\u884c\u5bf9\u9f50\u5904\u7406.....");
        File alignedApk = new File(unAlignedApk.getParent(), unAlignedApk.getName().replace(".apk", "_align.apk"));
        boolean ret = ProcessUtil.executeCommand("zipalign -v -p 4 " + unAlignedApk.getPath() + " " + alignedApk.getPath());
        if (ret) {
            System.out.println("\u5df2\u5b8c\u6210APK\u8fdb\u884c\u5bf9\u9f50\u5904\u7406======");
        }
        FileUtils.deleteFile(unAlignedApk.getPath());
        return alignedApk;
    }

    private File resignApk(File unSignedApk) throws Exception {
        this.logTitle("\u6b65\u9aa4\u4e03\uff1a\u5bf9\u751f\u6210\u7684APK\u8fdb\u884c\u7b7e\u540d");
        KeyStore store = KeyStoreUtil.readKeyStoreConfig("" + KEYSTORE_CFG);
        File signedApk = new File(ROOT + "out", unSignedApk.getName().replace(".apk", "_signed.apk"));
        if (!signedApk.getParentFile().exists()) {
            signedApk.getParentFile().mkdirs();
        }
        String signerCmd = String.format("apksigner sign --ks %s --ks-key-alias %s --min-sdk-version 21 --ks-pass pass:%s --key-pass pass:%s --out %s %s", store.storeFile, store.alias, store.storePassword, store.keyPassword, signedApk.getPath(), unSignedApk.getPath());
        boolean ret = ProcessUtil.executeCommand(signerCmd);
        System.out.println("\u5df2\u5b8c\u6210\u7b7e\u540d======" + signedApk.getPath());
        FileUtils.deleteFile(unSignedApk.getPath());
        return signedApk;
    }

    private void modifyAndroidManifest(File xmlFile) {
        if (xmlFile == null) {
            System.out.println("\u8bf7\u8bbe\u7f6eAndroidManifest.xml\u6587\u4ef6");
            return;
        }
        if (!xmlFile.exists()) {
            System.out.println("\u6307\u5b9a\u7684AndroidManifest.xml\u6587\u4ef6\u4e0d\u5b58\u5728");
            return;
        }
        System.out.println("\u5f00\u59cb\u4fee\u6539AndroidManifest.xml......");
        String shellApplicationName = "com.zhh.jiagu.shell.StubApplication";
        String metaDataName = "APPLICATION_CLASS_NAME";
        String attrName = "android:name";
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(xmlFile);
            NodeList nl = document.getElementsByTagName("application");
            if (nl != null) {
                Node app = nl.item(0);
                String applicationName = "android.app.Application";
                NamedNodeMap attrMap = app.getAttributes();
                Node node = app.getAttributes().getNamedItem(attrName);
                if (node != null) {
                    applicationName = node.getNodeValue();
                    node.setNodeValue(shellApplicationName);
                } else {
                    Attr attr = document.createAttribute(attrName);
                    attr.setValue(shellApplicationName);
                    attrMap.setNamedItem(attr);
                }
                Element metaData = document.createElement("meta-data");
                metaData.setAttribute("android:name", metaDataName);
                metaData.setAttribute("android:value", applicationName);
                app.appendChild(metaData);
                TransformerFactory outFactory = TransformerFactory.newInstance();
                Transformer transformer = outFactory.newTransformer();
                DOMSource xmlSource = new DOMSource(document);
                StreamResult outResult = new StreamResult(xmlFile);
                transformer.transform(xmlSource, outResult);
                System.out.println("\u5df2\u5b8c\u6210\u4fee\u6539AndroidManifest\u6587\u4ef6======");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private byte[] encrpt(byte[] srcdata) {
        for (int i = 0; i < srcdata.length; ++i) {
            srcdata[i] = (byte)(0xFF ^ srcdata[i]);
        }
        return srcdata;
    }

    private void fixCheckSumHeader(byte[] dexBytes) {
        Adler32 adler = new Adler32();
        adler.update(dexBytes, 12, dexBytes.length - 12);
        long value = adler.getValue();
        int va = (int)value;
        byte[] newcs = this.intToByte(va);
        byte[] recs = new byte[4];
        for (int i = 0; i < 4; ++i) {
            recs[i] = newcs[newcs.length - 1 - i];
        }
        System.arraycopy(recs, 0, dexBytes, 8, 4);
    }

    public byte[] intToByte(int number) {
        byte[] b = new byte[4];
        for (int i = 3; i >= 0; --i) {
            b[i] = (byte)(number % 256);
            number >>= 8;
        }
        return b;
    }

    private void fixSHA1Header(byte[] dexBytes) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("SHA-1");
        md.update(dexBytes, 32, dexBytes.length - 32);
        byte[] newdt = md.digest();
        System.arraycopy(newdt, 0, dexBytes, 12, 20);
        String hexstr = "";
        for (int i = 0; i < newdt.length; ++i) {
            hexstr = hexstr + Integer.toString((newdt[i] & 0xFF) + 256, 16).substring(1);
        }
    }

    private void fixFileSizeHeader(byte[] dexBytes) {
        byte[] newfs = this.intToByte(dexBytes.length);
        System.out.println("fixFileSizeHeader ===== size : " + dexBytes.length);
        byte[] refs = new byte[4];
        for (int i = 0; i < 4; ++i) {
            refs[i] = newfs[newfs.length - 1 - i];
        }
        System.arraycopy(refs, 0, dexBytes, 32, 4);
    }

    private byte[] readFileBytes(File file) throws IOException {
        int i;
        byte[] arrayOfByte = new byte[1024];
        ByteArrayOutputStream localByteArrayOutputStream = new ByteArrayOutputStream();
        FileInputStream fis = new FileInputStream(file);
        while ((i = fis.read(arrayOfByte)) != -1) {
            localByteArrayOutputStream.write(arrayOfByte, 0, i);
        }
        return localByteArrayOutputStream.toByteArray();
    }

    private void logTitle(String title) {
        System.out.println("==================== " + title + " ====================");
    }
}

