/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.utils;

import java.util.Stack;

public class CfgPrinter {
    private final StringBuilder builder = new StringBuilder();
    private final Stack<String> opened = new Stack();
    private final int indentSpacing = 2;
    public int nextUnusedValue = 0;

    public String makeUnusedValue() {
        return "_" + this.nextUnusedValue++;
    }

    public void resetUnusedValue() {
        this.nextUnusedValue = 0;
    }

    public CfgPrinter begin(String title) {
        this.print("begin_");
        this.append(title).ln();
        this.opened.push(title);
        return this;
    }

    public CfgPrinter end(String title) {
        String top = this.opened.pop();
        assert (title.equals(top));
        this.print("end_");
        this.append(title).ln();
        return this;
    }

    public CfgPrinter print(int i) {
        this.printIndent();
        this.builder.append(i);
        return this;
    }

    public CfgPrinter print(String string) {
        this.printIndent();
        this.builder.append(string);
        return this;
    }

    public CfgPrinter append(int i) {
        this.builder.append(i);
        return this;
    }

    public CfgPrinter append(String string) {
        this.builder.append(string);
        return this;
    }

    public CfgPrinter sp() {
        this.builder.append(" ");
        return this;
    }

    public CfgPrinter ln() {
        this.builder.append("\n");
        return this;
    }

    private void printIndent() {
        for (int i = 0; i < this.opened.size() * 2; ++i) {
            this.builder.append(" ");
        }
    }

    public String toString() {
        return this.builder.toString();
    }
}

