/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.naming;

import com.android.tools.r8.naming.ClassNaming;
import com.android.tools.r8.naming.MemberNaming;
import com.android.tools.r8.naming.ProguardMap;
import com.android.tools.r8.naming.Range;
import com.android.tools.r8.utils.IdentifierUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Objects;

public class ProguardMapReader
implements AutoCloseable {
    private final BufferedReader reader;
    private int lineNo = 0;
    private int lineOffset = 0;
    private String line;
    final HashMap<String, String> cache = new HashMap();

    @Override
    public void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
        }
    }

    ProguardMapReader(BufferedReader reader) {
        this.reader = reader;
    }

    private char peek() {
        return this.peek(0);
    }

    private char peek(int distance) {
        return this.lineOffset + distance < this.line.length() ? this.line.charAt(this.lineOffset + distance) : (char)'\n';
    }

    private boolean hasNext() {
        return this.lineOffset < this.line.length();
    }

    private char next() {
        try {
            return this.line.charAt(this.lineOffset++);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ParseException("Unexpected end of line");
        }
    }

    private boolean nextLine() throws IOException {
        if (this.line.length() != this.lineOffset) {
            throw new ParseException("Expected end of line");
        }
        return this.skipLine();
    }

    private static boolean isEmptyOrCommentLine(String line) {
        if (line == null) {
            return true;
        }
        for (int i = 0; i < line.length(); ++i) {
            char c = line.charAt(i);
            if (c == '#') {
                return true;
            }
            if (Character.isWhitespace(c)) continue;
            return false;
        }
        return true;
    }

    private boolean skipLine() throws IOException {
        this.lineOffset = 0;
        do {
            ++this.lineNo;
            this.line = this.reader.readLine();
        } while (this.hasLine() && ProguardMapReader.isEmptyOrCommentLine(this.line));
        return this.hasLine();
    }

    private boolean hasLine() {
        return this.line != null;
    }

    private void skipWhitespace() {
        while (Character.isWhitespace(this.peek())) {
            this.next();
        }
    }

    private char expect(char c) {
        if (!this.hasNext()) {
            throw new ParseException("Expected '" + c + "'", true);
        }
        if (this.next() != c) {
            throw new ParseException("Expected '" + c + "'");
        }
        return c;
    }

    void parse(ProguardMap.Builder mapBuilder) throws IOException {
        do {
            ++this.lineNo;
            this.line = this.reader.readLine();
        } while (this.hasLine() && ProguardMapReader.isEmptyOrCommentLine(this.line));
        this.parseClassMappings(mapBuilder);
    }

    private void parseClassMappings(ProguardMap.Builder mapBuilder) throws IOException {
        while (this.hasLine()) {
            String before = this.parseType(false);
            this.skipWhitespace();
            assert (IdentifierUtils.isDexIdentifierPart('-'));
            if (before.endsWith("package-info")) {
                this.skipLine();
                continue;
            }
            if (before.endsWith("-") && this.acceptString(">")) {
                before = before.substring(0, before.length() - 1);
            } else {
                this.skipWhitespace();
                this.acceptArrow();
            }
            this.skipWhitespace();
            String after = this.parseType(false);
            this.expect(':');
            ClassNaming.Builder currentClassBuilder = mapBuilder.classNamingBuilder(after, before);
            if (!this.nextLine()) continue;
            this.parseMemberMappings(currentClassBuilder);
        }
    }

    private void parseMemberMappings(ClassNaming.Builder classNamingBuilder) throws IOException {
        MemberNaming activeMemberNaming = null;
        Range previousObfuscatedRange = null;
        MemberNaming.Signature previousSignature = null;
        String previousRenamedName = null;
        boolean lastRound = false;
        while (true) {
            MemberNaming.Signature signature = null;
            Object originalRange = null;
            String renamedName = null;
            Range obfuscatedRange = null;
            if (!lastRound) {
                if (!Character.isWhitespace(this.peek())) {
                    lastRound = true;
                    continue;
                }
                this.skipWhitespace();
                Object maybeRangeOrInt = this.maybeParseRangeOrInt();
                if (maybeRangeOrInt != null) {
                    if (!(maybeRangeOrInt instanceof Range)) {
                        throw new ParseException(String.format("Invalid obfuscated line number range (%s).", maybeRangeOrInt));
                    }
                    obfuscatedRange = (Range)maybeRangeOrInt;
                    this.expect(':');
                }
                signature = this.parseSignature();
                if (this.peek() == ':') {
                    this.next();
                    originalRange = this.maybeParseRangeOrInt();
                    if (originalRange == null) {
                        throw new ParseException("No number follows the colon after the method signature.");
                    }
                }
                this.skipWhitespace();
                this.skipArrow();
                this.skipWhitespace();
                renamedName = this.parseMethodName();
            }
            if (previousRenamedName != null && (!Objects.equals(previousObfuscatedRange, obfuscatedRange) || !Objects.equals(previousRenamedName, renamedName) || originalRange != null && originalRange instanceof Range)) {
                if (activeMemberNaming != null) {
                    if (!activeMemberNaming.getOriginalSignature().equals(previousSignature)) {
                        classNamingBuilder.addMemberEntry(activeMemberNaming);
                        activeMemberNaming = null;
                    } else assert (activeMemberNaming.getRenamedName().equals(previousRenamedName));
                }
                if (activeMemberNaming == null) {
                    activeMemberNaming = new MemberNaming(previousSignature, previousRenamedName);
                }
            }
            if (lastRound) {
                if (activeMemberNaming == null) break;
                classNamingBuilder.addMemberEntry(activeMemberNaming);
                break;
            }
            if (obfuscatedRange == null) {
                if (originalRange != null) {
                    throw new ParseException("No mapping for original range " + originalRange + ".");
                }
                if (activeMemberNaming != null) {
                    classNamingBuilder.addMemberEntry(activeMemberNaming);
                }
                activeMemberNaming = new MemberNaming(signature, renamedName);
            } else assert (signature instanceof MemberNaming.MethodSignature);
            if (signature instanceof MemberNaming.MethodSignature) {
                classNamingBuilder.addMappedRange(obfuscatedRange, (MemberNaming.MethodSignature)signature, originalRange, renamedName);
            }
            previousRenamedName = renamedName;
            previousObfuscatedRange = obfuscatedRange;
            previousSignature = signature;
            if (this.nextLine()) continue;
            lastRound = true;
        }
    }

    private void skipIdentifier(boolean allowInit) {
        boolean isInit = false;
        if (allowInit && this.peek() == '<') {
            this.next();
            isInit = true;
        }
        if (!IdentifierUtils.isDexIdentifierStart(this.peek())) {
            throw new ParseException("Identifier expected");
        }
        this.next();
        while (IdentifierUtils.isDexIdentifierPart(this.peek())) {
            this.next();
        }
        if (isInit) {
            this.expect('>');
        }
        if (IdentifierUtils.isDexIdentifierPart(this.peek())) {
            throw new ParseException("End of identifier expected");
        }
    }

    private String substring(int start) {
        String result = this.line.substring(start, this.lineOffset);
        if (this.cache.containsKey(result)) {
            return this.cache.get(result);
        }
        this.cache.put(result, result);
        return result;
    }

    private String parseMethodName() {
        int startPosition = this.lineOffset;
        this.skipIdentifier(true);
        while (this.peek() == '.') {
            this.next();
            this.skipIdentifier(true);
        }
        return this.substring(startPosition);
    }

    private String parseType(boolean allowArray) {
        int startPosition = this.lineOffset;
        this.skipIdentifier(false);
        while (this.peek() == '.') {
            this.next();
            this.skipIdentifier(false);
        }
        if (allowArray) {
            while (this.peek() == '[') {
                this.next();
                this.expect(']');
            }
        }
        return this.substring(startPosition);
    }

    private MemberNaming.Signature parseSignature() {
        MemberNaming.Signature signature;
        String type = this.parseType(true);
        this.expect(' ');
        String name = this.parseMethodName();
        if (this.peek() == '(') {
            String[] arguments;
            this.next();
            if (this.peek() == ')') {
                arguments = new String[]{};
            } else {
                LinkedList<String> items = new LinkedList<String>();
                items.add(this.parseType(true));
                while (this.peek() != ')') {
                    this.expect(',');
                    items.add(this.parseType(true));
                }
                arguments = items.toArray(new String[items.size()]);
            }
            this.expect(')');
            signature = new MemberNaming.MethodSignature(name, type, arguments);
        } else {
            signature = new MemberNaming.FieldSignature(name, type);
        }
        return signature;
    }

    private void skipArrow() {
        this.expect('-');
        this.expect('>');
    }

    private boolean acceptArrow() {
        if (this.peek() == '-' && this.peek(1) == '>') {
            this.next();
            this.next();
            return true;
        }
        return false;
    }

    private boolean acceptString(String s) {
        int i;
        for (i = 0; i < s.length(); ++i) {
            if (this.peek(i) == s.charAt(i)) continue;
            return false;
        }
        for (i = 0; i < s.length(); ++i) {
            this.next();
        }
        return true;
    }

    private Object maybeParseRangeOrInt() {
        if (!Character.isDigit(this.peek())) {
            return null;
        }
        int from = this.parseNumber();
        if (this.peek() != ':') {
            return from;
        }
        this.expect(':');
        int to = this.parseNumber();
        return new Range(from, to);
    }

    private int parseNumber() {
        int result = 0;
        if (!Character.isDigit(this.peek())) {
            throw new ParseException("Number expected");
        }
        do {
            result *= 10;
            result += Character.getNumericValue(this.next());
        } while (Character.isDigit(this.peek()));
        return result;
    }

    private class ParseException
    extends RuntimeException {
        private final int lineNo;
        private final int lineOffset;
        private final boolean eol;
        private final String msg;

        ParseException(String msg) {
            this(msg, false);
        }

        ParseException(String msg, boolean eol) {
            this.lineNo = ProguardMapReader.this.lineNo;
            this.lineOffset = ProguardMapReader.this.lineOffset;
            this.eol = eol;
            this.msg = msg;
        }

        @Override
        public String toString() {
            if (this.eol) {
                return "Parse error [" + this.lineNo + ":eol] " + this.msg;
            }
            return "Parse error [" + this.lineNo + ":" + this.lineOffset + "] " + this.msg;
        }
    }
}

