/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.analysis.type;

import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.AppInfoWithSubtyping;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.analysis.type.ArrayTypeLatticeElement;
import com.android.tools.r8.ir.analysis.type.ClassTypeLatticeElement;
import com.android.tools.r8.ir.analysis.type.NullLatticeElement;
import com.android.tools.r8.ir.analysis.type.PrimitiveTypeLatticeElement;
import com.android.tools.r8.ir.analysis.type.Top;
import java.util.function.BinaryOperator;

public abstract class TypeLatticeElement {
    private final boolean isNullable;

    TypeLatticeElement(boolean isNullable) {
        this.isNullable = isNullable;
    }

    boolean isNullable() {
        return this.isNullable;
    }

    abstract TypeLatticeElement asNullable();

    String isNullableString() {
        return this.isNullable() ? "" : "@NonNull ";
    }

    public static TypeLatticeElement join(AppInfoWithSubtyping appInfo, TypeLatticeElement l1, TypeLatticeElement l2) {
        boolean isNullable;
        if (l1.isBottom()) {
            return l2;
        }
        if (l2.isBottom()) {
            return l1;
        }
        if (l1.isTop() || l2.isTop()) {
            return Top.getInstance();
        }
        if (l1 instanceof NullLatticeElement) {
            return l2.asNullable();
        }
        if (l2 instanceof NullLatticeElement) {
            return l1.asNullable();
        }
        if (l1 instanceof PrimitiveTypeLatticeElement) {
            return l2 instanceof PrimitiveTypeLatticeElement ? l1 : Top.getInstance();
        }
        if (l2 instanceof PrimitiveTypeLatticeElement) {
            return Top.getInstance();
        }
        boolean bl = isNullable = l1.isNullable() || l2.isNullable();
        if (l1.getClass() != l2.getClass()) {
            return TypeLatticeElement.objectType(appInfo, isNullable);
        }
        if (l1 instanceof ArrayTypeLatticeElement) {
            ArrayTypeLatticeElement a1 = (ArrayTypeLatticeElement)l1;
            ArrayTypeLatticeElement a2 = (ArrayTypeLatticeElement)l2;
            if (a1.getArrayType() == a2.getArrayType()) {
                return a1.isNullable() ? a1 : a2;
            }
            DexType a1BaseReferenceType = a1.getArrayBaseType(appInfo.dexItemFactory);
            int a1Nesting = a1.getNesting();
            if (a1BaseReferenceType.isPrimitiveType()) {
                --a1Nesting;
                a1BaseReferenceType = appInfo.dexItemFactory.objectType;
            }
            DexType a2BaseReferenceType = a2.getArrayBaseType(appInfo.dexItemFactory);
            int a2Nesting = a2.getNesting();
            if (a2BaseReferenceType.isPrimitiveType()) {
                --a2Nesting;
                a2BaseReferenceType = appInfo.dexItemFactory.objectType;
            }
            assert (a1BaseReferenceType.isClassType() && a2BaseReferenceType.isClassType());
            if (a1Nesting == 0 || a2Nesting == 0) {
                return TypeLatticeElement.objectType(appInfo, isNullable);
            }
            if (a1Nesting != a2Nesting) {
                int min = Math.min(a1Nesting, a2Nesting);
                return TypeLatticeElement.objectArrayType(appInfo, min, isNullable);
            }
            DexType lub = a1BaseReferenceType.computeLeastUpperBound(appInfo, a2BaseReferenceType);
            DexType arrayTypeLub = appInfo.dexItemFactory.createArrayType(a1Nesting, lub);
            return new ArrayTypeLatticeElement(arrayTypeLub, isNullable);
        }
        if (l1 instanceof ClassTypeLatticeElement) {
            ClassTypeLatticeElement c1 = (ClassTypeLatticeElement)l1;
            ClassTypeLatticeElement c2 = (ClassTypeLatticeElement)l2;
            if (c1.classType == c2.classType) {
                return c1.isNullable() ? c1 : c2;
            }
            DexType lub = c1.classType.computeLeastUpperBound(appInfo, c2.classType);
            return new ClassTypeLatticeElement(lub, isNullable);
        }
        throw new Unreachable("unless a new type lattice is introduced.");
    }

    static BinaryOperator<TypeLatticeElement> joiner(AppInfoWithSubtyping appInfo) {
        return (l1, l2) -> TypeLatticeElement.join(appInfo, l1, l2);
    }

    public boolean isTop() {
        return false;
    }

    boolean isBottom() {
        return false;
    }

    static ClassTypeLatticeElement objectType(AppInfo appInfo, boolean isNullable) {
        return new ClassTypeLatticeElement(appInfo.dexItemFactory.objectType, isNullable);
    }

    static ArrayTypeLatticeElement objectArrayType(AppInfo appInfo, int nesting, boolean isNullable) {
        return new ArrayTypeLatticeElement(appInfo.dexItemFactory.createArrayType(nesting, appInfo.dexItemFactory.objectType), isNullable);
    }

    public static TypeLatticeElement fromDexType(DexType type, boolean isNullable) {
        if (type == DexItemFactory.nullValueType) {
            return NullLatticeElement.getInstance();
        }
        if (type.isPrimitiveType()) {
            return PrimitiveTypeLatticeElement.getInstance();
        }
        if (type.isClassType()) {
            return new ClassTypeLatticeElement(type, isNullable);
        }
        assert (type.isArrayType());
        return new ArrayTypeLatticeElement(type, isNullable);
    }

    public static TypeLatticeElement newArray(DexType arrayType, boolean isNullable) {
        return new ArrayTypeLatticeElement(arrayType, isNullable);
    }

    public TypeLatticeElement arrayGet(AppInfoWithSubtyping appInfo) {
        return Top.getInstance();
    }

    public TypeLatticeElement checkCast(AppInfoWithSubtyping appInfo, DexType castType) {
        return TypeLatticeElement.fromDexType(castType, this.isNullable());
    }

    public abstract String toString();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        TypeLatticeElement otherElement = (TypeLatticeElement)o;
        return otherElement.isNullable() == this.isNullable;
    }

    public int hashCode() {
        return this.isNullable ? 1 : 0;
    }
}

