/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.analysis.type;

import com.android.tools.r8.graph.AppInfoWithSubtyping;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.analysis.type.TypeLatticeElement;

public class ArrayTypeLatticeElement
extends TypeLatticeElement {
    private final DexType arrayType;

    ArrayTypeLatticeElement(DexType arrayType, boolean isNullable) {
        super(isNullable);
        this.arrayType = arrayType;
    }

    public DexType getArrayType() {
        return this.arrayType;
    }

    public int getNesting() {
        return this.arrayType.getNumberOfLeadingSquareBrackets();
    }

    public DexType getArrayElementType(DexItemFactory factory) {
        return this.arrayType.toArrayElementType(factory);
    }

    public DexType getArrayBaseType(DexItemFactory factory) {
        return this.arrayType.toBaseType(factory);
    }

    @Override
    TypeLatticeElement asNullable() {
        return this.isNullable() ? this : new ArrayTypeLatticeElement(this.arrayType, true);
    }

    @Override
    public TypeLatticeElement arrayGet(AppInfoWithSubtyping appInfo) {
        return ArrayTypeLatticeElement.fromDexType(this.getArrayElementType(appInfo.dexItemFactory), true);
    }

    @Override
    public TypeLatticeElement checkCast(AppInfoWithSubtyping appInfo, DexType castType) {
        if (castType.getNumberOfLeadingSquareBrackets() == this.getNesting()) {
            DexType base = castType.toBaseType(appInfo.dexItemFactory);
            if (this.getArrayBaseType(appInfo.dexItemFactory).isSubtypeOf(base, appInfo)) {
                return this;
            }
        }
        return super.checkCast(appInfo, castType);
    }

    @Override
    public String toString() {
        return this.isNullableString() + this.arrayType.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        ArrayTypeLatticeElement other = (ArrayTypeLatticeElement)o;
        return this.arrayType == other.arrayType;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.arrayType.hashCode();
        return result;
    }
}

