/*
 * Decompiled with CFR 0.152.
 */
package com.android.apksig.internal.apk.v4;

import com.android.apksig.apk.ApkUtils;
import com.android.apksig.internal.apk.ApkSigningBlockUtils;
import com.android.apksig.internal.apk.ContentDigestAlgorithm;
import com.android.apksig.internal.apk.SignatureAlgorithm;
import com.android.apksig.internal.apk.SignatureInfo;
import com.android.apksig.internal.apk.v2.V2SchemeVerifier;
import com.android.apksig.internal.apk.v3.V3SchemeSigner;
import com.android.apksig.internal.apk.v3.V3SchemeVerifier;
import com.android.apksig.internal.apk.v4.V4Signature;
import com.android.apksig.internal.util.Pair;
import com.android.apksig.util.DataSource;
import com.android.apksig.zip.ZipFormatException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;

public abstract class V4SchemeSigner {
    private V4SchemeSigner() {
    }

    public static List<SignatureAlgorithm> getSuggestedSignatureAlgorithms(PublicKey signingKey, int minSdkVersion, boolean apkSigningBlockPaddingSupported) throws InvalidKeyException {
        List<SignatureAlgorithm> algorithms = V3SchemeSigner.getSuggestedSignatureAlgorithms(signingKey, minSdkVersion, apkSigningBlockPaddingSupported);
        ListIterator<SignatureAlgorithm> iter = algorithms.listIterator();
        while (iter.hasNext()) {
            SignatureAlgorithm algorithm = (SignatureAlgorithm)((Object)iter.next());
            if (V4SchemeSigner.isSupported(algorithm.getContentDigestAlgorithm(), false)) continue;
            iter.remove();
        }
        return algorithms;
    }

    public static void generateV4Signature(DataSource apkContent, ApkSigningBlockUtils.SignerConfig signerConfig, File outputFile) throws IOException, InvalidKeyException, NoSuchAlgorithmException {
        V4Signature signature;
        byte[] salt = null;
        byte[] additionalData = null;
        long fileSize = apkContent.size();
        byte[] apkDigest = V4SchemeSigner.getApkDigest(apkContent);
        ApkSigningBlockUtils.VerityTreeAndDigest verityContentDigestInfo = ApkSigningBlockUtils.computeChunkVerityTreeAndDigest(apkContent);
        ContentDigestAlgorithm verityContentDigestAlgorithm = verityContentDigestInfo.contentDigestAlgorithm;
        byte[] rootHash = verityContentDigestInfo.rootHash;
        byte[] tree = verityContentDigestInfo.tree;
        Pair<Integer, Byte> hashingAlgorithmBlockSizePair = V4SchemeSigner.convertToV4HashingInfo(verityContentDigestAlgorithm);
        V4Signature.HashingInfo hashingInfo = new V4Signature.HashingInfo(hashingAlgorithmBlockSizePair.getFirst(), hashingAlgorithmBlockSizePair.getSecond(), salt, rootHash);
        try {
            signature = V4SchemeSigner.generateSignature(signerConfig, hashingInfo, apkDigest, additionalData, fileSize);
        }
        catch (InvalidKeyException | SignatureException | CertificateEncodingException e) {
            throw new InvalidKeyException("Signer failed", e);
        }
        try (FileOutputStream output = new FileOutputStream(outputFile);){
            signature.writeTo(output);
            V4Signature.writeBytes(output, tree);
        }
        catch (IOException e) {
            outputFile.delete();
            throw e;
        }
    }

    private static V4Signature generateSignature(ApkSigningBlockUtils.SignerConfig signerConfig, V4Signature.HashingInfo hashingInfo, byte[] apkDigest, byte[] additionaData, long fileSize) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException, CertificateEncodingException {
        if (signerConfig.certificates.isEmpty()) {
            throw new SignatureException("No certificates configured for signer");
        }
        if (signerConfig.certificates.size() != 1) {
            throw new CertificateEncodingException("Should only have one certificate");
        }
        PublicKey publicKey = signerConfig.certificates.get(0).getPublicKey();
        List<byte[]> encodedCertificates = ApkSigningBlockUtils.encodeCertificates(signerConfig.certificates);
        byte[] encodedCertificate = encodedCertificates.get(0);
        V4Signature.SigningInfo signingInfoNoSignature = new V4Signature.SigningInfo(apkDigest, encodedCertificate, additionaData, publicKey.getEncoded(), -1, null);
        byte[] data = V4Signature.getSigningData(fileSize, hashingInfo, signingInfoNoSignature);
        List<Pair<Integer, byte[]>> signatures = ApkSigningBlockUtils.generateSignaturesOverData(signerConfig, data);
        if (signatures.size() != 1) {
            throw new SignatureException("Should only be one signature generated");
        }
        int signatureAlgorithmId = signatures.get(0).getFirst();
        byte[] signature = signatures.get(0).getSecond();
        V4Signature.SigningInfo signingInfo = new V4Signature.SigningInfo(apkDigest, encodedCertificate, additionaData, publicKey.getEncoded(), signatureAlgorithmId, signature);
        return new V4Signature(2, hashingInfo.toByteArray(), signingInfo.toByteArray());
    }

    private static byte[] getApkDigest(DataSource apk) throws IOException {
        ApkUtils.ZipSections zipSections;
        try {
            zipSections = ApkUtils.findZipSections(apk);
        }
        catch (ZipFormatException e) {
            throw new IOException("Malformed APK: not a ZIP archive", e);
        }
        try {
            return V4SchemeSigner.getBestV3Digest(apk, zipSections);
        }
        catch (SignatureException e) {
            SignatureException v3Exception = e;
            try {
                return V4SchemeSigner.getBestV2Digest(apk, zipSections);
            }
            catch (SignatureException e2) {
                SignatureException v2Exception = e2;
                throw new IOException("Failed to obtain v2/v3 digest, v3 exception: " + v3Exception + ", v2 exception: " + v2Exception);
            }
        }
    }

    private static byte[] getBestV3Digest(DataSource apk, ApkUtils.ZipSections zipSections) throws SignatureException {
        HashSet<ContentDigestAlgorithm> contentDigestsToVerify = new HashSet<ContentDigestAlgorithm>(1);
        ApkSigningBlockUtils.Result result = new ApkSigningBlockUtils.Result(3);
        try {
            SignatureInfo signatureInfo = ApkSigningBlockUtils.findSignature(apk, zipSections, -262969152, result);
            ByteBuffer apkSignatureSchemeV3Block = signatureInfo.signatureBlock;
            V3SchemeVerifier.parseSigners(apkSignatureSchemeV3Block, contentDigestsToVerify, result);
        }
        catch (Exception e) {
            throw new SignatureException("Failed to extract and parse v3 block", e);
        }
        if (result.signers.size() != 1) {
            throw new SignatureException("Should only have one signer, errors: " + result.getErrors());
        }
        ApkSigningBlockUtils.Result.SignerInfo signer = result.signers.get(0);
        if (signer.containsErrors()) {
            throw new SignatureException("Parsing failed: " + signer.getErrors());
        }
        List<ApkSigningBlockUtils.Result.SignerInfo.ContentDigest> contentDigests = result.signers.get((int)0).contentDigests;
        return V4SchemeSigner.pickBestDigest(contentDigests);
    }

    private static byte[] getBestV2Digest(DataSource apk, ApkUtils.ZipSections zipSections) throws SignatureException {
        HashSet<ContentDigestAlgorithm> contentDigestsToVerify = new HashSet<ContentDigestAlgorithm>(1);
        HashSet<Integer> foundApkSigSchemeIds = new HashSet<Integer>(1);
        ApkSigningBlockUtils.Result result = new ApkSigningBlockUtils.Result(2);
        try {
            SignatureInfo signatureInfo = ApkSigningBlockUtils.findSignature(apk, zipSections, 1896449818, result);
            ByteBuffer apkSignatureSchemeV2Block = signatureInfo.signatureBlock;
            V2SchemeVerifier.parseSigners(apkSignatureSchemeV2Block, contentDigestsToVerify, Collections.emptyMap(), foundApkSigSchemeIds, Integer.MAX_VALUE, Integer.MAX_VALUE, result);
        }
        catch (Exception e) {
            throw new SignatureException("Failed to extract and parse v2 block", e);
        }
        if (result.signers.size() != 1) {
            throw new SignatureException("Should only have one signer, errors: " + result.getErrors());
        }
        ApkSigningBlockUtils.Result.SignerInfo signer = result.signers.get(0);
        if (signer.containsErrors()) {
            throw new SignatureException("Parsing failed: " + signer.getErrors());
        }
        List<ApkSigningBlockUtils.Result.SignerInfo.ContentDigest> contentDigests = signer.contentDigests;
        return V4SchemeSigner.pickBestDigest(contentDigests);
    }

    private static byte[] pickBestDigest(List<ApkSigningBlockUtils.Result.SignerInfo.ContentDigest> contentDigests) throws SignatureException {
        if (contentDigests == null || contentDigests.isEmpty()) {
            throw new SignatureException("Should have at least one digest");
        }
        int bestAlgorithmOrder = -1;
        byte[] bestDigest = null;
        for (ApkSigningBlockUtils.Result.SignerInfo.ContentDigest contentDigest : contentDigests) {
            int algorithmOrder;
            SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.findById(contentDigest.getSignatureAlgorithmId());
            ContentDigestAlgorithm contentDigestAlgorithm = signatureAlgorithm.getContentDigestAlgorithm();
            if (!V4SchemeSigner.isSupported(contentDigestAlgorithm, true) || bestAlgorithmOrder >= (algorithmOrder = V4SchemeSigner.digestAlgorithmSortingOrder(contentDigestAlgorithm))) continue;
            bestAlgorithmOrder = algorithmOrder;
            bestDigest = contentDigest.getValue();
        }
        if (bestDigest == null) {
            throw new SignatureException("Failed to find a supported digest in the source APK");
        }
        return bestDigest;
    }

    public static int digestAlgorithmSortingOrder(ContentDigestAlgorithm contentDigestAlgorithm) {
        switch (contentDigestAlgorithm) {
            case CHUNKED_SHA256: {
                return 0;
            }
            case VERITY_CHUNKED_SHA256: {
                return 1;
            }
            case CHUNKED_SHA512: {
                return 2;
            }
        }
        return -1;
    }

    private static boolean isSupported(ContentDigestAlgorithm contentDigestAlgorithm, boolean forV3Digest) {
        if (contentDigestAlgorithm == null) {
            return false;
        }
        return contentDigestAlgorithm == ContentDigestAlgorithm.CHUNKED_SHA256 || contentDigestAlgorithm == ContentDigestAlgorithm.CHUNKED_SHA512 || forV3Digest && contentDigestAlgorithm == ContentDigestAlgorithm.VERITY_CHUNKED_SHA256;
    }

    private static Pair<Integer, Byte> convertToV4HashingInfo(ContentDigestAlgorithm algorithm) throws NoSuchAlgorithmException {
        switch (algorithm) {
            case VERITY_CHUNKED_SHA256: {
                return Pair.of(1, (byte)12);
            }
        }
        throw new NoSuchAlgorithmException("Invalid hash algorithm, only SHA2-256 over 4 KB chunks supported.");
    }
}

