/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.decoder;

import brut.androlib.res.xml.ResXmlEncoders;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterators;
import com.google.common.collect.PeekingIterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class StyledString {
    private final String mText;
    private final List<Span> mSpans;
    private static final Logger LOGGER = Logger.getLogger(StyledString.class.getName());

    public StyledString(String text, List<Span> spans) {
        this.mText = text;
        this.mSpans = spans;
    }

    String getText() {
        return this.mText;
    }

    List<Span> getSpans() {
        return this.mSpans;
    }

    public String toString() {
        return new Decoder().decode(this);
    }

    private static class Decoder {
        private String text;
        private StringBuilder xmlValue;
        private int lastOffset;

        private Decoder() {
        }

        String decode(StyledString styledString) {
            this.text = styledString.getText();
            this.xmlValue = new StringBuilder(this.text.length() * 2);
            this.lastOffset = 0;
            PeekingIterator<Span> it = Iterators.peekingIterator(styledString.getSpans().iterator());
            while (it.hasNext()) {
                this.decodeIterate(it);
            }
            if (this.lastOffset < this.text.length()) {
                this.xmlValue.append(ResXmlEncoders.escapeXmlChars(this.text.substring(this.lastOffset)));
            }
            return this.xmlValue.toString();
        }

        private void decodeIterate(PeekingIterator<Span> it) {
            Span span = it.next();
            String name = span.getName();
            Map<String, String> attributes = span.getAttributes();
            int spanStart = span.getFirstChar();
            int spanEnd = span.getLastChar() + 1;
            if (spanStart > this.lastOffset) {
                this.xmlValue.append(ResXmlEncoders.escapeXmlChars(this.text.substring(this.lastOffset, spanStart)));
            }
            this.lastOffset = spanStart;
            this.xmlValue.append('<').append(name);
            if (attributes != null) {
                for (Map.Entry<String, String> attrEntry : attributes.entrySet()) {
                    this.xmlValue.append(' ').append(attrEntry.getKey()).append("=\"").append(ResXmlEncoders.escapeXmlChars(attrEntry.getValue())).append('\"');
                }
            }
            if (spanStart == spanEnd) {
                this.xmlValue.append("/>");
                return;
            }
            this.xmlValue.append('>');
            while (it.hasNext() && it.peek().getFirstChar() < spanEnd) {
                this.decodeIterate(it);
            }
            if (spanEnd > this.lastOffset) {
                this.xmlValue.append(ResXmlEncoders.escapeXmlChars(this.text.substring(this.lastOffset, spanEnd)));
            }
            this.lastOffset = spanEnd;
            this.xmlValue.append("</").append(name).append('>');
        }
    }

    public static class Span
    implements Comparable<Span> {
        private static final Splitter.MapSplitter ATTRIBUTES_SPLITTER = Splitter.on(';').omitEmptyStrings().withKeyValueSeparator(Splitter.on('=').limit(2));
        private final String tag;
        private final int firstChar;
        private final int lastChar;

        public Span(String tag, int firstChar, int lastChar) {
            this.tag = tag;
            this.firstChar = firstChar;
            this.lastChar = lastChar;
        }

        public int getFirstChar() {
            return this.firstChar;
        }

        public int getLastChar() {
            return this.lastChar;
        }

        public String getName() {
            int separatorIdx = this.tag.indexOf(59);
            return separatorIdx == -1 ? this.tag : this.tag.substring(0, separatorIdx);
        }

        public Map<String, String> getAttributes() {
            int separatorIdx = this.tag.indexOf(59);
            return separatorIdx == -1 ? null : ATTRIBUTES_SPLITTER.split(this.tag.substring(separatorIdx + 1, this.tag.endsWith(";") ? this.tag.length() - 1 : this.tag.length()));
        }

        @Override
        public int compareTo(Span o) {
            int res = Integer.compare(this.firstChar, o.firstChar);
            if (res != 0) {
                return res;
            }
            res = Integer.compare(this.lastChar, o.lastChar);
            if (res != 0) {
                return -res;
            }
            return -this.tag.compareTo(o.tag);
        }
    }
}

