/*
 * Decompiled with CFR 0.152.
 */
package com.frezrik.jiagu.pack.util.axml.meditor.visitor;

import com.frezrik.jiagu.pack.util.axml.NodeVisitor;
import com.frezrik.jiagu.pack.util.axml.meditor.property.ModificationProperty;
import com.frezrik.jiagu.pack.util.axml.meditor.utils.Log;
import com.frezrik.jiagu.pack.util.axml.meditor.visitor.ApplicationTagVisitor;
import com.frezrik.jiagu.pack.util.axml.meditor.visitor.ModifyAttributeVisitor;
import com.frezrik.jiagu.pack.util.axml.meditor.visitor.UserPermissionTagVisitor;
import java.util.ArrayList;
import java.util.List;

public class ManifestTagVisitor
extends ModifyAttributeVisitor {
    private ModificationProperty properties;
    private List<String> hasIncludedUsesPermissionList = new ArrayList<String>();
    private UserPermissionTagVisitor.IUsesPermissionGetter addedPermissionGetter;

    public ManifestTagVisitor(NodeVisitor nv, ModificationProperty properties) {
        super(nv, properties.getManifestAttributeList());
        this.properties = properties;
    }

    @Override
    public NodeVisitor child(String ns, String name) {
        Log.d(" ManifestTagVisitor child  --> ns = " + ns + " name = " + name);
        if (ns != null && "uses-permission".equals(name)) {
            NodeVisitor child = super.child(null, "uses-permission");
            return new UserPermissionTagVisitor(child, null, ns);
        }
        NodeVisitor child = super.child(ns, name);
        if ("application".equals(name)) {
            return new ApplicationTagVisitor(child, this.properties.getApplicationAttributeList(), this.properties.getMetaDataList(), this.properties.getDeleteMetaDataList());
        }
        if ("uses-permission".equals(name)) {
            return new UserPermissionTagVisitor(child, this.getUsesPermissionGetter(), null);
        }
        return child;
    }

    @Override
    public void attr(String ns, String name, int resourceId, int type, Object obj) {
        Log.d(" ManifestTagVisitor attr  --> ns = " + ns + " name = " + name + " resourceId=" + resourceId + " obj = " + obj);
        super.attr(ns, name, resourceId, type, obj);
    }

    @Override
    public void end() {
        List<String> list = this.properties.getUsesPermissionList();
        if (list != null && list.size() > 0) {
            for (String permissionName : list) {
                if (this.hasIncludedUsesPermissionList.contains(permissionName)) continue;
                this.child(permissionName, "uses-permission");
            }
        }
        super.end();
    }

    private UserPermissionTagVisitor.IUsesPermissionGetter getUsesPermissionGetter() {
        if (this.addedPermissionGetter == null) {
            this.addedPermissionGetter = permissionName -> {
                if (!this.hasIncludedUsesPermissionList.contains(permissionName)) {
                    this.hasIncludedUsesPermissionList.add(permissionName);
                }
            };
        }
        return this.addedPermissionGetter;
    }
}

