/*
 * Decompiled with CFR 0.152.
 */
package org.conscrypt.ct;

import java.util.Objects;
import org.conscrypt.ct.LogInfo;
import org.conscrypt.ct.SignedCertificateTimestamp;

public final class VerifiedSCT {
    private final SignedCertificateTimestamp sct;
    private final Status status;
    private final LogInfo logInfo;

    private VerifiedSCT(Builder builder) {
        Objects.requireNonNull(builder.sct);
        Objects.requireNonNull(builder.status);
        if (builder.status == Status.VALID) {
            Objects.requireNonNull(builder.logInfo);
        }
        this.sct = builder.sct;
        this.status = builder.status;
        this.logInfo = builder.logInfo;
    }

    public SignedCertificateTimestamp getSct() {
        return this.sct;
    }

    public Status getStatus() {
        return this.status;
    }

    public boolean isValid() {
        return this.status == Status.VALID;
    }

    public LogInfo getLogInfo() {
        return this.logInfo;
    }

    public static class Builder {
        private SignedCertificateTimestamp sct;
        private Status status;
        private LogInfo logInfo;

        public Builder(SignedCertificateTimestamp sct) {
            this.sct = sct;
        }

        public Builder setStatus(Status status) {
            this.status = status;
            return this;
        }

        public Builder setLogInfo(LogInfo logInfo) {
            Objects.requireNonNull(logInfo);
            this.logInfo = logInfo;
            return this;
        }

        public VerifiedSCT build() {
            return new VerifiedSCT(this);
        }
    }

    public static enum Status {
        VALID,
        INVALID_SIGNATURE,
        UNKNOWN_LOG,
        INVALID_SCT;

    }
}

