/*
 * Decompiled with CFR 0.152.
 */
package org.conscrypt.ct;

import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Objects;
import org.conscrypt.Platform;
import org.conscrypt.ct.LogStore;
import org.conscrypt.ct.Policy;
import org.conscrypt.ct.PolicyCompliance;
import org.conscrypt.ct.VerificationResult;
import org.conscrypt.ct.Verifier;
import org.conscrypt.metrics.CertificateTransparencyVerificationReason;
import org.conscrypt.metrics.StatsLog;

public class CertificateTransparency {
    private LogStore logStore;
    private Verifier verifier;
    private Policy policy;
    private StatsLog statsLog;

    public CertificateTransparency(LogStore logStore, Policy policy, Verifier verifier, StatsLog statsLog) {
        Objects.requireNonNull(logStore);
        Objects.requireNonNull(policy);
        Objects.requireNonNull(verifier);
        Objects.requireNonNull(statsLog);
        this.logStore = logStore;
        this.policy = policy;
        this.verifier = verifier;
        this.statsLog = statsLog;
    }

    public boolean isCTVerificationRequired(String host) {
        return Platform.isCTVerificationRequired(host);
    }

    public CertificateTransparencyVerificationReason reasonCTVerificationRequired(String host) {
        return Platform.reasonCTVerificationRequired(host);
    }

    public void checkCT(List<X509Certificate> chain, byte[] ocspData, byte[] tlsData, String host) throws CertificateException {
        if (this.logStore.getState() != LogStore.State.COMPLIANT) {
            this.statsLog.reportCTVerificationResult(this.logStore, null, null, this.reasonCTVerificationRequired(host));
            return;
        }
        VerificationResult result = this.verifier.verifySignedCertificateTimestamps(chain, tlsData, ocspData);
        X509Certificate leaf = chain.get(0);
        PolicyCompliance compliance = this.policy.doesResultConformToPolicy(result, leaf);
        this.statsLog.reportCTVerificationResult(this.logStore, result, compliance, this.reasonCTVerificationRequired(host));
        if (compliance != PolicyCompliance.COMPLY) {
            throw new CertificateException("Certificate chain does not conform to required transparency policy: " + compliance.name());
        }
    }
}

