/*
 * Decompiled with CFR 0.152.
 */
package org.conscrypt;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Objects;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.conscrypt.Preconditions;

public final class Hkdf {
    private final String hmacName;
    private final int macLength;

    public Hkdf(String hmacName) throws NoSuchAlgorithmException {
        Objects.requireNonNull(hmacName);
        this.hmacName = hmacName;
        this.macLength = Mac.getInstance(hmacName).getMacLength();
    }

    public int getMacLength() {
        return this.macLength;
    }

    public byte[] extract(byte[] salt, byte[] ikm) throws InvalidKeyException, NoSuchAlgorithmException {
        Objects.requireNonNull(salt);
        Objects.requireNonNull(ikm);
        Preconditions.checkArgument(ikm.length > 0, "Empty keying material");
        if (salt.length == 0) {
            salt = new byte[this.getMacLength()];
        }
        return this.getMac(salt).doFinal(ikm);
    }

    public byte[] expand(byte[] prk, byte[] info, int length) throws InvalidKeyException, NoSuchAlgorithmException {
        int size;
        Objects.requireNonNull(prk);
        Objects.requireNonNull(info);
        Preconditions.checkArgument(length >= 0, "Negative length");
        Preconditions.checkArgument(length < 255 * this.getMacLength(), "Length too long");
        Mac mac = this.getMac(prk);
        int macLength = this.getMacLength();
        byte[] t = new byte[]{};
        byte[] output = new byte[length];
        byte[] counter = new byte[]{0};
        for (int outputOffset = 0; outputOffset < length; outputOffset += size) {
            counter[0] = (byte)(counter[0] + 1);
            mac.update(t);
            mac.update(info);
            t = mac.doFinal(counter);
            size = Math.min(macLength, length - outputOffset);
            System.arraycopy(t, 0, output, outputOffset, size);
        }
        return output;
    }

    private Mac getMac(byte[] key) throws InvalidKeyException, NoSuchAlgorithmException {
        Mac mac = Mac.getInstance(this.hmacName);
        mac.init(new SecretKeySpec(key, "RAW"));
        return mac;
    }
}

