/*
 * Decompiled with CFR 0.152.
 */
package com.android.apksig.apk;

import com.android.apksig.apk.ApkFormatException;
import com.android.apksig.apk.ApkSigningBlockNotFoundException;
import com.android.apksig.apk.ApkUtilsLite;
import com.android.apksig.apk.CodenameMinSdkVersionException;
import com.android.apksig.apk.MinSdkVersionException;
import com.android.apksig.internal.apk.AndroidBinXmlParser;
import com.android.apksig.internal.apk.v1.V1SchemeVerifier;
import com.android.apksig.internal.util.Pair;
import com.android.apksig.internal.zip.CentralDirectoryRecord;
import com.android.apksig.internal.zip.LocalFileRecord;
import com.android.apksig.internal.zip.ZipUtils;
import com.android.apksig.util.DataSource;
import com.android.apksig.zip.ZipFormatException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

public abstract class ApkUtils {
    public static final String ANDROID_MANIFEST_ZIP_ENTRY_NAME = "AndroidManifest.xml";
    public static final String SOURCE_STAMP_CERTIFICATE_HASH_ZIP_ENTRY_NAME = "stamp-cert-sha256";
    private static final int MIN_SDK_VERSION_ATTR_ID = 16843276;
    private static final int DEBUGGABLE_ATTR_ID = 0x101000F;
    private static final int TARGET_SANDBOX_VERSION_ATTR_ID = 16844108;
    private static final int TARGET_SDK_VERSION_ATTR_ID = 16843376;
    private static final String USES_SDK_ELEMENT_TAG = "uses-sdk";
    private static final int VERSION_CODE_ATTR_ID = 16843291;
    private static final String MANIFEST_ELEMENT_TAG = "manifest";
    private static final int VERSION_CODE_MAJOR_ATTR_ID = 16844150;

    private ApkUtils() {
    }

    public static ZipSections findZipSections(DataSource apk) throws IOException, ZipFormatException {
        com.android.apksig.zip.ZipSections zipSections = ApkUtilsLite.findZipSections(apk);
        return new ZipSections(zipSections.getZipCentralDirectoryOffset(), zipSections.getZipCentralDirectorySizeBytes(), zipSections.getZipCentralDirectoryRecordCount(), zipSections.getZipEndOfCentralDirectoryOffset(), zipSections.getZipEndOfCentralDirectory());
    }

    public static void setZipEocdCentralDirectoryOffset(ByteBuffer zipEndOfCentralDirectory, long offset) {
        ByteBuffer eocd = zipEndOfCentralDirectory.slice();
        eocd.order(ByteOrder.LITTLE_ENDIAN);
        ZipUtils.setZipEocdCentralDirectoryOffset(eocd, offset);
    }

    public static void updateZipEocdCommentLen(ByteBuffer zipEndOfCentralDirectory) {
        ByteBuffer eocd = zipEndOfCentralDirectory.slice();
        eocd.order(ByteOrder.LITTLE_ENDIAN);
        ZipUtils.updateZipEocdCommentLen(eocd);
    }

    public static ApkSigningBlock findApkSigningBlock(DataSource apk) throws ApkFormatException, IOException, ApkSigningBlockNotFoundException {
        ZipSections inputZipSections;
        try {
            inputZipSections = ApkUtils.findZipSections(apk);
        }
        catch (ZipFormatException e) {
            throw new ApkFormatException("Malformed APK: not a ZIP archive", e);
        }
        return ApkUtils.findApkSigningBlock(apk, inputZipSections);
    }

    public static ApkSigningBlock findApkSigningBlock(DataSource apk, ZipSections zipSections) throws IOException, ApkSigningBlockNotFoundException {
        ApkUtilsLite.ApkSigningBlock apkSigningBlock = ApkUtilsLite.findApkSigningBlock(apk, zipSections);
        return new ApkSigningBlock(apkSigningBlock.getStartOffset(), apkSigningBlock.getContents());
    }

    public static ByteBuffer getAndroidManifest(DataSource apk) throws IOException, ApkFormatException {
        ZipSections zipSections;
        try {
            zipSections = ApkUtils.findZipSections(apk);
        }
        catch (ZipFormatException e) {
            throw new ApkFormatException("Not a valid ZIP archive", e);
        }
        List<CentralDirectoryRecord> cdRecords = V1SchemeVerifier.parseZipCentralDirectory(apk, zipSections);
        CentralDirectoryRecord androidManifestCdRecord = null;
        for (CentralDirectoryRecord cdRecord : cdRecords) {
            if (!ANDROID_MANIFEST_ZIP_ENTRY_NAME.equals(cdRecord.getName())) continue;
            androidManifestCdRecord = cdRecord;
            break;
        }
        if (androidManifestCdRecord == null) {
            throw new ApkFormatException("Missing AndroidManifest.xml");
        }
        DataSource lfhSection = apk.slice(0L, zipSections.getZipCentralDirectoryOffset());
        try {
            return ByteBuffer.wrap(LocalFileRecord.getUncompressedData(lfhSection, androidManifestCdRecord, lfhSection.size()));
        }
        catch (ZipFormatException e) {
            throw new ApkFormatException("Failed to read AndroidManifest.xml", e);
        }
    }

    public static int getMinSdkVersionFromBinaryAndroidManifest(ByteBuffer androidManifestContents) throws MinSdkVersionException {
        try {
            int result = 1;
            AndroidBinXmlParser parser = new AndroidBinXmlParser(androidManifestContents);
            int eventType = parser.getEventType();
            while (eventType != 2) {
                if (eventType == 3 && parser.getDepth() == 2 && USES_SDK_ELEMENT_TAG.equals(parser.getName()) && parser.getNamespace().isEmpty()) {
                    int minSdkVersion = 1;
                    block7: for (int i = 0; i < parser.getAttributeCount(); ++i) {
                        if (parser.getAttributeNameResourceId(i) != 16843276) continue;
                        int valueType = parser.getAttributeValueType(i);
                        switch (valueType) {
                            case 2: {
                                minSdkVersion = parser.getAttributeIntValue(i);
                                break block7;
                            }
                            case 1: {
                                minSdkVersion = ApkUtils.getMinSdkVersionForCodename(parser.getAttributeStringValue(i));
                                break block7;
                            }
                            default: {
                                throw new MinSdkVersionException("Unable to determine APK's minimum supported Android: unsupported value type in AndroidManifest.xml's minSdkVersion. Only integer values supported.");
                            }
                        }
                    }
                    result = Math.max(result, minSdkVersion);
                }
                eventType = parser.next();
            }
            return result;
        }
        catch (AndroidBinXmlParser.XmlParserException e) {
            throw new MinSdkVersionException("Unable to determine APK's minimum supported Android platform version: malformed binary resource: AndroidManifest.xml", e);
        }
    }

    static int getMinSdkVersionForCodename(String codename) throws CodenameMinSdkVersionException {
        char firstChar;
        if ("Baklava".equals(codename)) {
            return 34;
        }
        char c = firstChar = codename.isEmpty() ? (char)' ' : (char)codename.charAt(0);
        if (firstChar >= 'A' && firstChar <= 'Z') {
            Pair[] sortedCodenamesFirstCharToApiLevel = CodenamesLazyInitializer.SORTED_CODENAMES_FIRST_CHAR_TO_API_LEVEL;
            int searchResult = Arrays.binarySearch(sortedCodenamesFirstCharToApiLevel, Pair.of(Character.valueOf(firstChar), null), CodenamesLazyInitializer.CODENAME_FIRST_CHAR_COMPARATOR);
            if (searchResult >= 0) {
                return (Integer)sortedCodenamesFirstCharToApiLevel[searchResult].getSecond();
            }
            int insertionIndex = -1 - searchResult;
            if (insertionIndex == 0) {
                return 1;
            }
            Pair newestOlderCodenameMapping = sortedCodenamesFirstCharToApiLevel[insertionIndex - 1];
            char newestOlderCodenameFirstChar = ((Character)newestOlderCodenameMapping.getFirst()).charValue();
            int newestOlderCodenameApiLevel = (Integer)newestOlderCodenameMapping.getSecond();
            return newestOlderCodenameApiLevel + (firstChar - newestOlderCodenameFirstChar);
        }
        throw new CodenameMinSdkVersionException("Unable to determine APK's minimum supported Android platform version : Unsupported codename in AndroidManifest.xml's minSdkVersion: \"" + codename + "\"", codename);
    }

    public static boolean getDebuggableFromBinaryAndroidManifest(ByteBuffer androidManifestContents) throws ApkFormatException {
        try {
            AndroidBinXmlParser parser = new AndroidBinXmlParser(androidManifestContents);
            int eventType = parser.getEventType();
            while (eventType != 2) {
                if (eventType == 3 && parser.getDepth() == 2 && "application".equals(parser.getName()) && parser.getNamespace().isEmpty()) {
                    for (int i = 0; i < parser.getAttributeCount(); ++i) {
                        if (parser.getAttributeNameResourceId(i) != 0x101000F) continue;
                        int valueType = parser.getAttributeValueType(i);
                        switch (valueType) {
                            case 1: 
                            case 2: 
                            case 4: {
                                String value = parser.getAttributeStringValue(i);
                                return "true".equals(value) || "TRUE".equals(value) || "1".equals(value);
                            }
                            case 3: {
                                throw new ApkFormatException("Unable to determine whether APK is debuggable: AndroidManifest.xml's android:debuggable attribute references a resource. References are not supported for security reasons. Only constant boolean, string and int values are supported.");
                            }
                        }
                        throw new ApkFormatException("Unable to determine whether APK is debuggable: AndroidManifest.xml's android:debuggable attribute uses unsupported value type. Only boolean, string and int values are supported.");
                    }
                    return false;
                }
                eventType = parser.next();
            }
            return false;
        }
        catch (AndroidBinXmlParser.XmlParserException e) {
            throw new ApkFormatException("Unable to determine whether APK is debuggable: malformed binary resource: AndroidManifest.xml", e);
        }
    }

    public static String getPackageNameFromBinaryAndroidManifest(ByteBuffer androidManifestContents) throws ApkFormatException {
        try {
            AndroidBinXmlParser parser = new AndroidBinXmlParser(androidManifestContents);
            int eventType = parser.getEventType();
            while (eventType != 2) {
                if (eventType == 3 && parser.getDepth() == 1 && MANIFEST_ELEMENT_TAG.equals(parser.getName()) && parser.getNamespace().isEmpty()) {
                    for (int i = 0; i < parser.getAttributeCount(); ++i) {
                        if (!"package".equals(parser.getAttributeName(i)) || !parser.getNamespace().isEmpty()) continue;
                        return parser.getAttributeStringValue(i);
                    }
                    return null;
                }
                eventType = parser.next();
            }
            return null;
        }
        catch (AndroidBinXmlParser.XmlParserException e) {
            throw new ApkFormatException("Unable to determine APK package name: malformed binary resource: AndroidManifest.xml", e);
        }
    }

    public static int getTargetSandboxVersionFromBinaryAndroidManifest(ByteBuffer androidManifestContents) {
        try {
            return ApkUtils.getAttributeValueFromBinaryAndroidManifest(androidManifestContents, MANIFEST_ELEMENT_TAG, 16844108);
        }
        catch (ApkFormatException e) {
            return 1;
        }
    }

    public static int getTargetSdkVersionFromBinaryAndroidManifest(ByteBuffer androidManifestContents) {
        int minSdkVersion = 1;
        try {
            return ApkUtils.getAttributeValueFromBinaryAndroidManifest(androidManifestContents, USES_SDK_ELEMENT_TAG, 16843376);
        }
        catch (ApkFormatException apkFormatException) {
            androidManifestContents.rewind();
            try {
                minSdkVersion = ApkUtils.getMinSdkVersionFromBinaryAndroidManifest(androidManifestContents);
            }
            catch (ApkFormatException apkFormatException2) {
                // empty catch block
            }
            return minSdkVersion;
        }
    }

    public static int getVersionCodeFromBinaryAndroidManifest(ByteBuffer androidManifestContents) throws ApkFormatException {
        return ApkUtils.getAttributeValueFromBinaryAndroidManifest(androidManifestContents, MANIFEST_ELEMENT_TAG, 16843291);
    }

    public static long getLongVersionCodeFromBinaryAndroidManifest(ByteBuffer androidManifestContents) throws ApkFormatException {
        int versionCode = ApkUtils.getVersionCodeFromBinaryAndroidManifest(androidManifestContents);
        long versionCodeMajor = 0L;
        try {
            androidManifestContents.rewind();
            versionCodeMajor = ApkUtils.getAttributeValueFromBinaryAndroidManifest(androidManifestContents, MANIFEST_ELEMENT_TAG, 16844150);
        }
        catch (ApkFormatException apkFormatException) {
            // empty catch block
        }
        return versionCodeMajor << 32 | (long)versionCode;
    }

    private static int getAttributeValueFromBinaryAndroidManifest(ByteBuffer androidManifestContents, String elementName, int attributeId) throws ApkFormatException {
        if (elementName == null) {
            throw new NullPointerException("elementName cannot be null");
        }
        try {
            AndroidBinXmlParser parser = new AndroidBinXmlParser(androidManifestContents);
            int eventType = parser.getEventType();
            while (eventType != 2) {
                if (eventType == 3 && elementName.equals(parser.getName())) {
                    for (int i = 0; i < parser.getAttributeCount(); ++i) {
                        if (parser.getAttributeNameResourceId(i) != attributeId) continue;
                        int valueType = parser.getAttributeValueType(i);
                        switch (valueType) {
                            case 1: 
                            case 2: {
                                return parser.getAttributeIntValue(i);
                            }
                        }
                        throw new ApkFormatException("Unsupported value type, " + valueType + ", for attribute " + String.format("0x%08X", attributeId) + " under element " + elementName);
                    }
                }
                eventType = parser.next();
            }
            throw new ApkFormatException("Failed to determine APK's " + elementName + " attribute " + String.format("0x%08X", attributeId) + " value");
        }
        catch (AndroidBinXmlParser.XmlParserException e) {
            throw new ApkFormatException("Unable to determine value for attribute " + String.format("0x%08X", attributeId) + " under element " + elementName + "; malformed binary resource: " + ANDROID_MANIFEST_ZIP_ENTRY_NAME, e);
        }
    }

    public static byte[] computeSha256DigestBytes(byte[] data) {
        return ApkUtilsLite.computeSha256DigestBytes(data);
    }

    public static class ZipSections
    extends com.android.apksig.zip.ZipSections {
        public ZipSections(long centralDirectoryOffset, long centralDirectorySizeBytes, int centralDirectoryRecordCount, long eocdOffset, ByteBuffer eocd) {
            super(centralDirectoryOffset, centralDirectorySizeBytes, centralDirectoryRecordCount, eocdOffset, eocd);
        }
    }

    public static class ApkSigningBlock
    extends ApkUtilsLite.ApkSigningBlock {
        public ApkSigningBlock(long startOffsetInApk, DataSource contents) {
            super(startOffsetInApk, contents);
        }
    }

    private static class CodenamesLazyInitializer {
        private static final Pair<Character, Integer>[] SORTED_CODENAMES_FIRST_CHAR_TO_API_LEVEL = new Pair[]{Pair.of(Character.valueOf('C'), 2), Pair.of(Character.valueOf('D'), 3), Pair.of(Character.valueOf('E'), 4), Pair.of(Character.valueOf('F'), 7), Pair.of(Character.valueOf('G'), 8), Pair.of(Character.valueOf('H'), 10), Pair.of(Character.valueOf('I'), 13), Pair.of(Character.valueOf('J'), 15), Pair.of(Character.valueOf('K'), 18), Pair.of(Character.valueOf('L'), 20), Pair.of(Character.valueOf('M'), 22), Pair.of(Character.valueOf('N'), 23), Pair.of(Character.valueOf('O'), 25)};
        private static final Comparator<Pair<Character, Integer>> CODENAME_FIRST_CHAR_COMPARATOR = new ByFirstComparator();

        private CodenamesLazyInitializer() {
        }

        private static class ByFirstComparator
        implements Comparator<Pair<Character, Integer>> {
            private ByFirstComparator() {
            }

            @Override
            public int compare(Pair<Character, Integer> o1, Pair<Character, Integer> o2) {
                char c1 = o1.getFirst().charValue();
                char c2 = o2.getFirst().charValue();
                return c1 - c2;
            }
        }
    }
}

