/*
 * Decompiled with CFR 0.152.
 */
package com.frezrik.jiagu.pack.util.axml.meditor.visitor;

import com.frezrik.jiagu.pack.util.axml.NodeVisitor;
import com.frezrik.jiagu.pack.util.axml.meditor.property.AttributeItem;
import com.frezrik.jiagu.pack.util.axml.meditor.utils.Utils;
import java.util.ArrayList;
import java.util.List;

public class ModifyAttributeVisitor
extends NodeVisitor {
    private List<AttributeItem> hasBeenAddedAttributeList = new ArrayList<AttributeItem>();
    private List<AttributeItem> mModifyAttributeList;
    private boolean isNewAddedTag;

    ModifyAttributeVisitor(NodeVisitor nv, List<AttributeItem> modifyAttributeList, boolean isNewAddedTag) {
        super(nv);
        this.mModifyAttributeList = modifyAttributeList;
        this.isNewAddedTag = isNewAddedTag;
        if (isNewAddedTag) {
            this.modifyAttr();
        }
    }

    ModifyAttributeVisitor(NodeVisitor nv, List<AttributeItem> modifyAttributeList) {
        this(nv, modifyAttributeList, false);
    }

    public void addModifyAttributeItem(AttributeItem item) {
        if (this.mModifyAttributeList == null) {
            this.mModifyAttributeList = new ArrayList<AttributeItem>();
        }
        this.mModifyAttributeList.add(item);
    }

    @Override
    public void attr(String ns, String name, int resourceId, int type, Object obj) {
        Object newObj = null;
        if (this.mModifyAttributeList != null) {
            for (AttributeItem attributeItem : this.mModifyAttributeList) {
                if (attributeItem == null || !Utils.isEqual(ns, attributeItem.getNamespace()) || !Utils.isEqual(name, attributeItem.getName())) continue;
                this.hasBeenAddedAttributeList.add(attributeItem);
                newObj = attributeItem.getValue();
                break;
            }
        }
        if (newObj == null) {
            newObj = obj;
        }
        super.attr(ns, name, resourceId, type, newObj);
    }

    @Override
    public void end() {
        if (!this.isNewAddedTag) {
            this.modifyAttr();
        }
        super.end();
    }

    private void modifyAttr() {
        if (this.mModifyAttributeList != null) {
            for (AttributeItem attributeItem : this.mModifyAttributeList) {
                if (this.hasBeenAddedAttributeList.contains(attributeItem)) continue;
                super.attr(attributeItem.getNamespace(), attributeItem.getName(), attributeItem.getResourceId(), attributeItem.getType(), attributeItem.getValue());
            }
        }
    }
}

