/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.smali.dexlib2.util;

import com.android.tools.smali.dexlib2.dexbacked.DexBackedDexFile$NotADexFile;
import com.android.tools.smali.dexlib2.dexbacked.raw.HeaderItem;
import com.android.tools.smali.dexlib2.util.DexUtil$InvalidFile;
import com.android.tools.smali.dexlib2.util.DexUtil$UnsupportedFile;
import com.android.tools.smali.util.InputStreamUtil;
import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.InputStream;

public abstract class DexUtil {
    public static void verifyDexHeader(BufferedInputStream bufferedInputStream) {
        if (((InputStream)bufferedInputStream).markSupported()) {
            ((InputStream)bufferedInputStream).mark(44);
            byte[] byArray = new byte[44];
            try {
                BufferedInputStream bufferedInputStream2 = bufferedInputStream;
                InputStreamUtil.readFully(bufferedInputStream2, byArray);
                ((InputStream)bufferedInputStream2).reset();
            }
            catch (EOFException eOFException) {
                try {
                    throw new DexBackedDexFile$NotADexFile("File is too short");
                }
                catch (Throwable throwable) {
                    ((InputStream)bufferedInputStream).reset();
                    throw throwable;
                }
            }
            DexUtil.verifyDexHeader(byArray, 0);
            return;
        }
        throw new IllegalArgumentException("InputStream must support mark");
    }

    public static int verifyDexHeader(byte[] object, int n) {
        int n2 = HeaderItem.getVersion(object, n);
        if (n2 == -1) {
            StringBuilder stringBuilder;
            StringBuilder stringBuilder2 = stringBuilder;
            stringBuilder = new StringBuilder("Not a valid dex magic value:");
            for (n2 = 0; n2 < 8; ++n2) {
                Byte by = object[n2];
                Object[] objectArray = new Object[1];
                Object[] objectArray2 = objectArray;
                objectArray[0] = by;
                stringBuilder2.append(String.format(" %02x", objectArray2));
            }
            throw new DexBackedDexFile$NotADexFile(stringBuilder2.toString());
        }
        switch (n2) {
            default: {
                object = n2;
                Object[] objectArray = new Object[1];
                Object[] objectArray3 = objectArray;
                objectArray[0] = object;
                throw new DexUtil$UnsupportedFile(String.format("Dex version %03d is not supported", objectArray3));
            }
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
        }
        int n3 = HeaderItem.getEndian(object, n);
        if (n3 != 2018915346) {
            if (n3 == 305419896) {
                return n2;
            }
            Integer n4 = n3;
            Object[] objectArray = new Object[1];
            Object[] objectArray4 = objectArray;
            objectArray[0] = n4;
            throw new DexUtil$InvalidFile(String.format("Invalid endian tag: 0x%x", objectArray4));
        }
        throw new DexUtil$UnsupportedFile("Big endian dex files are not supported");
    }
}

